/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Agents
 *
 *
 */
ML.load("utils/observable.js");

/**
 * IQAgents
 *   jabber:iq:agents protocol handler
 *
 * Constructor:
 *   IQAgents(jabberService)
 *
 * Methods:
 *   getAgents()
 *
 * Events:
 *   onIQAgentsError(errorCode, errorText)
 *   onIQAgents(name, description, transport, groupchat, service, register, search)
 */

function IQAgents(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQAgents.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:agents",

    getAgents: function()
    {
        this.jabberService.core.iqTag(null, null, null, "get", 
            DB.createElement("jabber:iq:agents", "query"), this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQAgentsError", errTag.getAttribute("code"), domToText(errTag));
        } else {
            var items = tag.getElementsByTagName("agent");
            var group;
            var i;
            var tOn = function(a) { return a ? domToText(a) : null};

            for (i = 0; i < items.length; i++) {
                this.fireEvent("onIQAgents", 
                    items[i].getAttribute("jid"),
                    tOn(items[i].getElementsByTagName("name")[0]),
                    tOn(items[i].getElementsByTagName("description")[0]),
                    items[i].getElementsByTagName("transport")[0] != null,
                    items[i].getElementsByTagName("groupchat")[0] != null,
                    tOn(items[i].getElementsByTagName("service")[0]),
                    items[i].getElementsByTagName("register")[0] != null,
                    items[i].getElementsByTagName("search")[0] != null
                );
            }
        }
    },
}