/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Avatar
 *
 *
 */
ML.load("utils/observable.js");
ML.load("crypto/sha1.js");

/**
 * IQAvatar
 *   jabber:iq:avatar protocol handler
 *
 * Constructor:
 *   IQAvatar(jabberService)
 *
 * Methods:
 *   getAvatar(from)
 *
 * Events:
 *   onIQAvatarError(errorCode, errorText)
 *   onIQAvatar(from, encodedImage)
 *   onIQAvatarRequest(from)
 */

function IQAvatar(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQAvatar.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:avatar",

    getAvatar: function(from)
    {
        this.jabberService.core.iqTag(null, from, null, "get", 
            DB.createElement("jabber:iq:avatar", "query"), this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQAvatarError", errTag.getAttribute("code"), domToText(errTag));
        } else {
            var items = tag.getElementsByTagName("data")[0];
            if (items != null)
                this.fireEvent("onIQAvatar", tag.getAttribute("from"), domToText(items));
        }
    },

    onIQHandler: function(tag)
    {
        if (tag.getAttribute("type") == "get")
        {
            var query = DB.createElement("jabber:iq:avatar", "query");

            query.addElement("jabber:iq:avatar", "data").addText(this.encodedImage);

            this.jabberService.core.iqTag("", tag.getAttribute("from"), null, "result", query);
            this.fireEvent("onIQAvatarRequest", tag.getAttribute("from"));
        }
    }
}