/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Gateway
 *
 *
 */
ML.load("utils/observable.js");

/**
 * IQGateway
 *   jabber:iq:gateway protocol handler
 *
 * Constructor:
 *   IQGateway(jabberService)
 *
 * Methods:
 *   getGateway()
 *   addItem(jid, name, group)
 *   removeItem(jid, name)
 *
 * Events:
 *   onIQGatewayError(errorCode, errorText)
 *   onIQGateway(jid, name, subscription, ask, group)
 */

function IQGateway(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQGateway.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:gateway",

    getPrompt: function(jid)
    {
        this.jabberService.core.iqTag(null, jid, 
            "getprompt"+(this.jabberService.msgId++), "get", 
            DB.createElement("jabber:iq:gateway", "query"), this);
    },

    getJID: function(jid, prompt)
    {
        var query = DB.createElement("jabber:iq:gateway", "query");
        query.addElement("jabber:iq:gateway", "prompt").
            addText(prompt);

        this.jabberService.core.iqTag(null, jid, 
            "getjid"+(this.jabberService.msgId++), "set", query, this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQGatewayError", tag.getAttribute("from"),
                errTag.getAttribute("code"), domToText(errTag));
        } else {
            if (tag.getAttribute("id").search(/getjid/) != -1)
                this.fireEvent("onIQGateway",
                    tag.getAttribute("from"), tag);
            else if (tag.getAttribute("id").search(/getprompt/) != -1)
                this.fireEvent("onIQGatewayInfo",
                    tag.getAttribute("from"), tag);
        }
    },

    onIQHandler: function(tag)
    {
    }
}