/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Roster
 *
 *
 */
ML.load("utils/observable.js");

/**
 * IQRoster
 *   jabber:iq:roster protocol handler
 *
 * Constructor:
 *   IQRoster(jabberService)
 *
 * Methods:
 *   getRoster()
 *   addItem(jid, name, group)
 *   removeItem(jid, name)
 *
 * Events:
 *   onIQRosterError(errorCode, errorText)
 *   onIQRoster(jid, name, subscription, ask, group)
 */

function IQRoster(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
}

IQRoster.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:roster",

    getRoster: function()
    {
        this.jabberService.core.iqTag(null, null, null, "get", 
            DB.createElement("jabber:iq:roster", "query"), this);
    },

    addItem: function(jid, name, groups)
    {
        var i;
        var tag = DB.createElement("jabber:iq:roster", "query")
        var query = DB.createElement("jabber:iq:roster", "item",
            "jid", jid,
            "name", name);

        tag.addDOM(query);

        if (typeof(groups) == "string")
            query.addElement("jabber:iq:roster", "group").
                addText(groups);
        else 
            for (i = 0; i < groups.length; i++)
                query.addElement("jabber:iq:roster", "group").
                    addText(groups[i]);

        this.jabberService.core.iqTag(null, null, null, "set", tag, this);
    },

    removeItem: function(jid)
    {
        var i;
        var tag = DB.createElement("jabber:iq:roster", "query")
        var query = DB.createElement("jabber:iq:roster", "item",
                "jid", jid,
                "subscription", "remove");

        tag.addDOM(query);

        this.jabberService.core.iqTag(null, null, null, "set", tag, this);
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQRosterError", errTag.getAttribute("code"), domToText(errTag));
        } else {
            var items = tag.getElementsByTagName("item");
            var groupTags, groups;
            var i, j;

            for (i = 0; i < items.length; i++) {
                groups = [];
                groupTags = items[i].getElementsByTagName("group");
                for (j = 0; j < groupTags.length; j++) {
                    groups.push(domToText(groupTags[j]));
                }

                this.fireEvent("onIQRoster", 
                    items[i].getAttribute("jid"),
                    items[i].getAttribute("name"),
                    items[i].getAttribute("subscription"),
                    items[i].getAttribute("ask"),
                    groups);
            }
        }
    },

    onIQHandler: function(tag)
    {
        this.onIQResponse(tag);
    }
}