/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * services.IQ.Search
 *
 *
 */
ML.load("utils/observable.js");

/**
 * IQSearch
 *   jabber:iq:search protocol handler
 *
 * Constructors:
 *   IQSearch(jabberService)
 *
 * Methods:
 *   getInfo(from)
 *   search(from, tagname, tagvalue, ...)
 *   searchTag(from, tag, ...)
 *
 * Events:
 *   onIQSearchError(errorCode, errorText)
 *   onIQSearchInfo(queryTag)
 *   onIQSearch(queryTag)
 */

function IQSearch(jabberService)
{
    this.base = Observable;
    this.base();

    this.jabberService = jabberService;
    this.state = 0;
}

IQSearch.prototype =
{
    __proto__: Observable.prototype,
    namespaceURI: "jabber:iq:search",

    getInfo: function(to)
    {
        this.jabberService.core.iqTag(null, to, null, "get", 
            DB.createElement("jabber:iq:search", "query"), this);
        this.state = 1;
    },

    search: function(to)
    {
        var tag = DB.createElement("jabber:iq:search", "query");
        var i;

        for (i = 1; i < arguments.length; i+=2)
            if (arguments[i] && arguments[i+1])
                tag.addElement("jabber:iq:search", arguments[i]).addText(arguments[i+1]);

        this.jabberService.core.iqTag(null, to, null, "set", tag, this);
        this.state = 3;
    },

    searchTag: function(to)
    {
        var tag = DB.createElement("jabber:iq:search", "query");
        var i;

        for (i = 1; i < arguments.length; i++)
            tag.addDOM(arguments[i]);

        this.jabberService.core.iqTag(null, to, null, "set", tag, this);
        this.state = 3;
    },

    onIQResponse: function(tag)
    {
        if (tag.getAttribute("type")=="error") {
            var errTag = tag.getElementsByTagName("error")[0];

            this.fireEvent("onIQSearchError", errTag.getAttribute("code"), domToText(errTag));
        } else if (tag.getAttribute("type")=="result") {
            switch (this.state) {
            case 1:
                this.fireEvent("onIQSearchInfo", tag.getAttribute("from"), tag.getElementsByTagName("query")[0]);
                this.state = 2;
                break;
            case 3:
                this.fireEvent("onIQSearch", tag.getAttribute("from"), tag.getElementsByTagName("query")[0]);
                this.state = 4;
                break;
            }
        }
    },
}