/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * scripts.uiscripts.AddContact
 *
 *
 */
ML.load("utils/misc.js");

function AddContactHandler()
{
    this.bundle = getStringBundle("chrome://jim/locale/jim.properties");
}

AddContactHandler.prototype =
{
    modeAdvance: function()
    {
        if (document.getElementById("mode-radio-jabberid").selected)
            document.getElementById("mode").next="jabberid-contact-info";
        else
            document.getElementById("mode").next="transport-selection";
    },

    finish: function()
    {
        var jid, contact, group, subscribe;

        if (document.getElementById("add-contact-wizard").currentPage.id == "jabberid-contact-info") {
            jid = document.getElementById("jabberid-contact-info-jid").value;
            contact = document.getElementById("jabberid-contact-info-name").value;
            group = document.getElementById("jabberid-contact-info-groups-list").value;
            subscribe = document.getElementById("jabberid-contact-info-subscribe").checked;
        } else if (document.getElementById("add-contact-wizard").currentPage.id == "transport-contact-info") {
            jid = document.getElementById("transport-contact-info-jid").value;
            contact = document.getElementById("transport-contact-info-name").value;
            group = document.getElementById("transport-contact-info-groups-list").value;
            subscribe = document.getElementById("transport-contact-info-subscribe").checked;
        }

        if (jid && contact && group) {
            jabberService.core.iq.roster.addItem(jid, contact, group);
            if (subscribe)
                jabberService.core.subscribe(jid,
                    this.bundle.GetStringFromName("addContactSubscribeText"));
            return true;
        }
        alert(this.bundle.GetStringFromName("addContactIncompleteContactInfo"));
        return false;
    },

    getTransportInfo: function()
    {
        var el = document.getElementById("transport-selection-agents-list");

        document.getElementById("transport-info-deck").selectedIndex = 0;
        document.getElementById("transport-info").next = null;
        jabberService.core.iq.gateway.getPrompt(el.selectedItem.getAttribute("jid"));
    },

    getJabberID: function()
    {
        var el = document.getElementById("transport-selection-agents-list");

        document.getElementById("transport-contact-info-deck").selectedIndex = 0;
        document.getElementById("transport-contact-info").next = null;

        jabberService.core.iq.gateway.getJID(el.selectedItem.getAttribute("jid"),
            document.getElementById("transport-info-main").
                getElementsByTagName("textbox")[0].value);
    },

    onTransportChanged: function(el)
    {
        var list = document.getElementById("transport-selection-agents-list");
        var info = jabberService.core.highlevel.agents.
            getAgentInfoById(list.selectedItem.getAttribute("id"));
        if (!info)
            return;

        document.getElementById("transport-selection-description").value =
            info.description;
    },

    onLoad: function()
    {
        var el, jid;

        el = document.getElementById("transport-selection-agents-popup");
        el.database.AddDataSource(jabberService.localRDF.DS);
        el.builder.rebuild();

        el = document.getElementById("transport-contact-info-groups-popup");
        el.database.AddDataSource(jabberService.localRDF.DS);
        el.builder.rebuild();

        el = document.getElementById("jabberid-contact-info-groups-popup");
        el.database.AddDataSource(jabberService.localRDF.DS);
        el.builder.rebuild();

        jid = window.arguments[0];

        if (jid) {
            document.getElementById("jabberid-contact-info-jid").
                value = jid;
            document.getElementById("add-contact-wizard").currentPage =
                document.getElementById("jabberid-contact-info");
        }

        jabberService.core.iq.gateway.addObserver(this);
    },

    onUnload: function()
    {
        jabberService.core.iq.gateway.removeObserver(this);
    },

    onIQGatewayInfo: function(from, queryTag)
    {
        var el = document.getElementById("transport-info-main");
        var tag;
        var ct;
        var tags = [];

        while (el.hasChildNodes())
            el.removeChild(el.firstChild);

        if (ct = queryTag.getElementsByTagName("desc")[0]) {
            tag = document.createElement("description");
            tag.appendChild(document.createTextNode(domToText(ct)));
            el.appendChild(tag);
        }

        ct = queryTag.getElementsByTagName("prompt");

        for (i = 0; i < ct.length; i++) {
            tag = document.createElement("label");
            tag.setAttribute("value", domToText(ct[i]));
            el.appendChild(tag);
            tag = document.createElement("textbox");
            tag.setAttribute("name", domToText(ct[i]));
            el.appendChild(tag);
        }
        document.getElementById("transport-info-deck").selectedIndex = 1;
        document.getElementById("transport-info").next = "transport-contact-info";
    },

    onIQGatewayError: function(from, errorCode, errorText)
    {
        if (document.getElementById("add-contact-wizard").currentPage == 
            document.getElementById("transport-info"))
        {
            document.getElementById("transport-info-error").value =
                this.bundle.formatStringFromName(
                    "error", [errorCode, errorText], 2);
            document.getElementById("transport-info-deck").selectedIndex = 2;
        } else if (document.getElementById("add-contact-wizard").currentPage == 
            document.getElementById("transport-contact-info"))
        {
            document.getElementById("transport-contact-info-error").value =
                this.bundle.formatStringFromName(
                    "error", [errorCode, errorText], 2);
            document.getElementById("transport-contact-info-deck").selectedIndex = 2;
        }

    },

    onIQGateway: function(from, tag)
    {
        var el = document.getElementById("transport-contact-info-jid");

        if (ct = tag.getElementsByTagName("prompt")[0]) {
            document.getElementById("transport-contact-info-jid").value =
                domToText(ct);
        }
        document.getElementById("transport-contact-info-deck").selectedIndex = 1;
    },
}

var addContactHandler = new AddContactHandler();