/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * scripts.uiscripts.Alert
 *
 *
 */
function AlertHandler()
{
}

AlertHandler.prototype =
{
    onLoad: function()
    {
        var show = false;

        if (window.arguments[0] != null) {
            document.getElementById("title").
                setAttribute("value", window.arguments[0]);
            show = true;
        }
        if (window.arguments[1] != null) {
            document.getElementById("subtitle").
                setAttribute("value", window.arguments[1]);
            show = true;
        }
        if (window.arguments[2] != null) {
            document.getElementById("subtitle").
                setAttribute("class", window.arguments[2]);
            show = true;
        }
        if (window.arguments[3] != null) {
            document.getElementById("msg").
                setAttribute("value", window.arguments[3]);
            show = true;
        }
        if (window.arguments[4] != null) {
            document.getElementById("img").
                setAttribute("src", window.arguments[4]);
            show = true;
        }
        if (window.arguments[5] != null) {
            document.getElementById("img2").
                setAttribute("src", window.arguments[5]);
            show = true;
        }

        if (!show) {
            window.close();
            return;
        }
        setTimeout(this.lazySizeSet, 0, this);
    },

    lazySizeSet: function(_this)
    {
        window.sizeToContent();

        window.moveTo(window.screen.availWidth - window.outerWidth - 10,
            window.screen.availHeight - window.outerHeight);

        _this.timeout = setTimeout(_this.closeAlert, 2000, _this, null);
    },

    closeAlert: function(_this, step)
    {
        if (step == null) {
            _this.closeTimer = setInterval(_this.closeAlert, 10, _this, 2);
            return;
        }
        window.screenY += step;
        window.outerHeight -= step;

        if (window.outerHeight <= 0) {
            clearInterval(_this.closeTimer);
            window.close();
        }
    }
}

window.updateAlert = function(title, subtitle, subtitleclass, msg, img, img2)
{
    if (!window.document)
        return;

    if (title != null)
        document.getElementById("title").
            setAttribute("value", title);
    if (subtitle != null)
        document.getElementById("subtitle").
            setAttribute("value", subtitle);
    if (subtitleclass != null)
        document.getElementById("subtitle").
            setAttribute("class", subtitleclass);
    if (msg != null)
        document.getElementById("msg").
            setAttribute("value", msg);
    if (img != null)
        document.getElementById("img").
            setAttribute("src", img);
    window.sizeToContent();

    window.moveTo(window.screen.availWidth - window.outerWidth - 10,
        window.screen.availHeight - window.outerHeight);
}

var alertHandler = new AlertHandler();
