/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * scripts.uiscripts.AlertMgr
 *
 *
 */
function AlertMgr()
{
}

AlertMgr.prototype =
{
    __getWindow: function(windowType)
    {
        var wmediator = Components.classes["@mozilla.org/appshell/window-mediator;1"].
            getService(Components.interfaces.nsIWindowMediator);

        return wmediator.getMostRecentWindow(windowType);
    },

    showAlert: function(title, subtitle, subtitleclass, msg, imguri, img2uri)
    {
        var win = this.__getWindow("jim:alert");

        if (win)
            win.close();
        else
            window.openDialog("chrome://jim/content/alert.xul",
                "jim:alertWindow", "chrome,dialog=yes,titlebar=no,popup=yes",
                title, subtitle, subtitleclass, msg, imguri, img2uri);
    },

    isOpened: function(title)
    {
        var win = this.__getWindow("jim:alert");

        return win && win.document.getElementById("title") &&
            win.document.getElementById("title").
                getAttribute("value") == title;
    },

    updateAlert: function(title, subtitle, subtitleclass, msg, imguri, img2uri)
    {
        var win = this.__getWindow("jim:alert");

        if (win)
            win.updateAlert(title, subtitle, subtitleclass, msg, imguri. img2uri);

    },
}

var alertMgr = new AlertMgr();
