/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * scripts.uiscripts.EditAccount
 *
 *
 */
ML.load("utils/misc.js");

function EditAccountHandler()
{
    this.bundle = getStringBundle("chrome://jim/locale/jim.properties");
}

EditAccountHandler.prototype =
{
    finish: function()
    {
        var server, port, user, pass, name, resource, rememberPass;
        if (this.accountName) {

            name = document.getElementById("account-info-name").value;
            user = document.getElementById("account-info-username").value;
            pass = document.getElementById("account-info-password").value;
            server = document.getElementById("account-info-server").value;
            port = document.getElementById("account-info-port").value;
            resource = document.getElementById("account-info-resource").value;
            rememberPass = document.getElementById("account-info-remember-pass").checked;
            useSSL = document.getElementById("account-info-use-ssl").checked;

            if (server && port && user && (!rememberPass || pass) && name && resource) {
                if (name != this.accountName && jabberService.core.highlevel.accounts.hasAccountInfo(name)) {
                    alert(this.bundle.GetStringFromName("editAccountAccountExists"));
                    return false;
                }
                if (name != this.accountName)
                    jabberService.core.highlevel.accounts.
                        removeAccountInfo(this.accountName);

                jabberService.core.highlevel.accounts.setAccountInfo(name, user,
                    rememberPass ? pass : null, resource, server, port, useSSL);

                return true;
            }
            alert(this.bundle.GetStringFromName("editAccountIncompleteAccountInfo"));
            return false;
        }
    },


    useSSLChecked: function()
    {
        var state = document.getElementById("account-info-use-ssl").checked;
        var port = document.getElementById("account-info-port");

        if (state && port.value == 5222)
            port.value = 5223;
        else if (!state && port.value == 5223)
            port.value = 5222;
    },

    onLoad: function()
    {
        this.accountName = window.arguments[0];
        var info = jabberService.core.highlevel.accounts.getAccountInfo(this.accountName);

        if (info) {
            document.getElementById("account-info-name").value = info.name;
            document.getElementById("account-info-username").value = info.username;
            document.getElementById("account-info-password").value = info.password || "";
            document.getElementById("account-info-server").value = info.server;
            document.getElementById("account-info-port").value = info.port
            document.getElementById("account-info-resource").value = info.resource;
            document.getElementById("account-info-remember-pass").checked = info.password != null;
            document.getElementById("account-info-use-ssl").checked = !!info.useSSL;
        } else
            this.accountName = null;
    }
}

var editAccountHandler = new EditAccountHandler();