/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * scripts.uiscripts.StatusText
 *
 *
 */
ML.load("utils/misc.js");
ML.load("io/file.js");

function StatusTextHandler()
{
}

StatusTextHandler.prototype =
{
    finish: function()
    {
        var status = document.getElementById("status-text-list").value;
        if (this.type == "disconnected")
            jabberService.disconnect(status);
        else
            jabberService.core.highlevel.users.setPresence(this.type, this.show, status);
    },

    onTextSelectionChanged: function(box)
    {
        this.selectedItem = document.getElementById("status-text-list").
            selectedItem;
    },

    onLoad: function()
    {
        var el;

        this.type = window.arguments[0]
        this.show = window.arguments[1];
        this.mode = this.type || this.show;
        if (this.type == "disconnected")
            this.mode == "unavailable";
        
        if (this.mode) {
            el = document.getElementById("status-text-popup");
            el.setAttribute("ref", jabberService.core.highlevel.
                statustext.getContainerId(this.mode));
            el.database.AddDataSource(jabberService.core.highlevel.statustext.rdf.DS);
            el.builder.rebuild();
        }
    },

    onAddText: function()
    {
        var val = document.getElementById("status-text-list").value;

        if (val)
            jabberService.core.highlevel.statustext.
                addStatusText(this.mode, val)
    },

    onUpdateText: function()
    {
        var val = document.getElementById("status-text-list").value;

        if (this.selectedItem && val)
            jabberService.core.highlevel.statustext.
                updateStatusText(
                    this.selectedItem.getAttribute("status-text-id"),
                    this.mode,
                    val);
    },

    onRemoveText: function()
    {
        if (this.selectedItem)
            jabberService.core.highlevel.statustext.
               removeStatusText(
                    this.selectedItem.getAttribute("status-text-id"),
                    this.mode);
        this.selectedItem = null;
    }
}

var statusTextHandler = new StatusTextHandler();