/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * utils.Config
 *
 *
 */

function getPref(name)
{
    var val = jabberService.configRes.getTarget(name);

    if (val)
        return val.value;
    else
        return defaultConfValues[name];
}

function getBoolPref(name)
{
    var val = jabberService.configRes.getTarget(name);

    if (val)
        return val.value == "true";
    else
        return defaultConfValues[name];
}

function setPref(name, value)
{
    if (value)
        jabberService.configRes.setAssertion(name, value, true);
    else
        jabberService.configRes.setAssertion(name, defaultConfValues[name], true);
}

function setBoolPref(name, value)
{
    if (value)
        jabberService.configRes.setAssertion(name, value ? "true" : "false", true);
    else
        jabberService.configRes.setAssertion(name,
            defaultConfValues[name] ? "true" : "false", true);
}

var defaultConfValues =
{
    "proto-time-send":        true,
    "proto-time-recv":        true,
    "proto-last-send":        true,
    "proto-last-recv":        true,
    "proto-version-send":     true,
    "proto-version-recv":     true,
    "priority-available":     8,
    "priority-chat":          10,
    "priority-dnd":           4,
    "priority-away":          4,
    "priority-xa":            2,
}
