/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * utils.Misc
 *
 *
 */

function generateRandomName(len)
{
    var charSet = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    var name = "";

    len = len || 10

    for (var i = 0; i < len; ++i)
      name += charSet.charAt(Math.floor(Math.random() * charSet.length));

    return name;
}

function getStringBundle(path) {
    var strBundleService = Components.classes["@mozilla.org/intl/stringbundle;1"].
        getService(Components.interfaces.nsIStringBundleService);

  return strBundleService.createBundle(path); 
}

function formatDate(date, locale, dateFormat, timeFormat)
{
    var formater = Components.classes["@mozilla.org/intl/scriptabledateformat;1"].
        getService(Components.interfaces.nsIScriptableDateFormat);

    switch (dateFormat) {
    case "none":
        dateFormat = formater.dateFormatNone;
        break;
    case "short":
        dateFormat = formater.dateFormatShort;
        break;
    case "long":
        dateFormat = formater.dateFormatLong;
        break;
    default:
        dateFormat = formater.dateFormatShort;
    }

    switch (timeFormat) {
    case "none":
        timeFormat = formater.timeFormatNone;
        break;
    case "short":
        timeFormat = formater.timeFormatNoSeconds;
        break;
    case "long":
        timeFormat = formater.timeFormatSeconds;
        break;
    case "short24":
        timeFormat = formater.timeFormatNoSecondsForce24Hour;
        break;
    case "long24":
        timeFormat = formater.timeFormatSecondsForce24Hour;
        break;
    default:
        timeFormat = formater.timeFormatShort;
    }
    return formater.FormatDateTime(locale, dateFormat, timeFormat,
        date.getFullYear(), date.getMonth()+1, date.getDate(),
        date.getHours(), date.getMinutes(), date.getSeconds());
}

function dateToUTCString(date)
{
    var res, c;

    with (date) {
        res = getUTCFullYear().toString();
        c = (getUTCMonth()+1).toString();
        res += c.length < 2 ? "0"+c : c;
        c = getUTCDate().toString();
        res += c.length < 2 ? "0"+c : c;
        c = getUTCHours().toString();
        res += c.length < 2 ? "T0"+c : "T"+c;
        c = getUTCMinutes().toString();
        res += c.length < 2 ? ":0"+c : ":"+c;
        c = getUTCSeconds().toString();
        res += c.length < 2 ? ":0"+c : ":"+c;
    }
    return res;
}

function dateToISO8601Timestamp(date)
{
    var res, o, c;

    with (date) {
        res = getUTCFullYear().toString();
        c = (getUTCMonth()+1).toString();
        res += c.length < 2 ? "-0"+c : "-"+c;
        c = getUTCDate().toString();
        res += c.length < 2 ? "-0"+c : "-"+c;
        c = getUTCHours().toString();
        res += c.length < 2 ? "T0"+c : "T"+c;
        c = getUTCMinutes().toString();
        res += c.length < 2 ? ":0"+c : ":"+c;
        c = getUTCSeconds().toString();
        res += c.length < 2 ? ":0"+c : ":"+c;
        o = getTimezoneOffset();
        if (o > 0)
            res += "+";
        else {
            res += "-";
            o = -o;
        }
        c = o/60;
        res += c.length < 2 ? "0"+c : c;
        c = o % 60;
        res += c.length < 2 ? ":0"+c : ":"+c;
    }
    return res;
}

function utcStringToDate(string)
{
    var date = new Date();

    date.setUTCFullYear(string.substr(0,4));
    date.setUTCMonth(string.substr(4,2));
    date.setUTCDate(string.substr(6,2));
    date.setUTCHours(string.substr(9,2));
    date.setUTCMinutes(string.substr(12,2));
    date.setUTCSeconds(string.substr(15,2));

    return date;
}
