/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * utils.ModuleLoader
 *
 *
 */
function ModuleLoader()
{
    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
    this.incpath = "chrome://jim/content/scripts";
    this.loadedscripts = {};
    this.loader = new (new Components.Constructor("@mozilla.org/moz/jssubscript-loader;1",
        "mozIJSSubScriptLoader"));
}

ModuleLoader.prototype =
{
    load: function(script)
    {
        var i, paths;
        var exc;

        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");

        if (this.loadedscripts[script])
            return Components.results.NS_OK;

        paths = this.incpath.split("@");

        for (i = 0; i < paths.length; i++) {
            try {
                this.loadedscripts[script] = 1;
                this.loader.loadSubScript(paths[i]+"/"+script);
                return Components.results.NS_OK;
            } catch (ex) {
                exc = ex;
                delete this.loadedscripts[script];
            }
        }
        alert("[excception:"+ (exc.message ? (exc.message +" on "+exc.fileName+":"+exc.lineNumber) : exc) + "]");
        return Components.results.NS_ERROR_INVALID_ARG;
    },

    addIncPath: function(path)
    {
        this.incpath += "@"+path;
    }
}

var ML = new ModuleLoader();