/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is JIM.
 *
 * The Initial Developer of the Original Code is
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Pawel Chmielowski <prefiks@o2.pl>
 *
 * ***** END LICENSE BLOCK ***** */

/**
 * utils.Observable
 *
 *
 */

function Observable()
{
    this.observers = [];
}

Observable.prototype =
{
    addObserver: function(observer, priority)
    {
        if (priority == null)
            priority = this.observers.length;
        this.observers.splice(priority, 0, observer);
    },

    removeObserver: function(observer)
    {
        var i;

        for (i = 0; i < this.observers.length; i++)
            if (this.observers[i] == observer) {
                this.observers.splice(i, 1);
                break;
            }
    },

    fireEvent: function(name)
    {
        var i, j, k;

        for (i = 0; i < this.observers.length; i++)
            if (name in this.observers[i]) {
                if (j == null && arguments.length > 1) {
                    j = new Array(arguments.length-1);
                    for (k = 1; k < arguments.length; k++)
                        j[k-1] = arguments[k];
                }
                this.observers[i][name].apply(this.observers[i], j);
        }
    }
}