// this function verifies disk space in kilobytes
function verifyDiskSpace(dirPath, spaceRequired)
{
  var spaceAvailable;

  // Get the available disk space on the given path
  spaceAvailable = fileGetDiskSpaceAvailable(dirPath);

  // Convert the available disk space into kilobytes
  spaceAvailable = parseInt(spaceAvailable / 1024);

  // do the verification
  if(spaceAvailable < spaceRequired)
  {
    logComment("Insufficient disk space: " + dirPath);
    logComment("  required : " + spaceRequired + " K");
    logComment("  available: " + spaceAvailable + " K");
    return(false);
  }

  return(true);
}

// this function deletes a file if it exists
function deleteThisFile(dirKey, file)
{
  var fFileToDelete;

  fFileToDelete = getFolder(dirKey, file);
  logComment("File to delete: " + fFileToDelete);
  if(File.isFile(fFileToDelete))
  {
    File.remove(fFileToDelete);
    return(true);
  }
  else
    return(false);
}

// this function deletes a folder if it exists
function deleteThisFolder(dirKey, folder, recursiveDelete)
{
  var fToDelete;

  if(typeof recursiveDelete == "undefined")
    recursiveDelete = true;

  fToDelete = getFolder(dirKey, folder);
  logComment("folder to delete: " + fToDelete);
  if(File.isDirectory(fToDelete))
  {
    File.dirRemove(fToDelete, recursiveDelete);
    return(true);
  }
  else
    return(false);
}

// OS type detection
// which platform?
function getPlatform()
{
  var platformStr;
  var platformNode;

  if('platform' in Install)
  {
    platformStr = new String(Install.platform);

    if (!platformStr.search(/^Macintosh/))
      platformNode = 'mac';
    else if (!platformStr.search(/^Win/))
      platformNode = 'win';
    else if (!platformStr.search(/^OS\/2/))
      platformNode = 'win';
    else
      platformNode = 'unix';
  }
  else
  {
    var fOSMac  = getFolder("Mac System");
    var fOSWin  = getFolder("Win System");

    logComment("fOSMac: "  + fOSMac);
    logComment("fOSWin: "  + fOSWin);

    if(fOSMac != null)
      platformNode = 'mac';
    else if(fOSWin != null)
      platformNode = 'win';
    else
      platformNode = 'unix';
  }

  return platformNode;
}

function upgradeCleanup()
{
  // Obsolete files from Netscape 6.0 and Netscape 6.01 that
  // need to be cleaned up.
  deleteThisFile("Components", "libmozucth.so");
  deleteThisFile("Components", "libpsmglue.so");
  deleteThisFile("Components", "libsample.so");
  deleteThisFile("Components", "nsSample.js");
  deleteThisFile("Components", "libucvja.so");
  deleteThisFile("Components", "libucvko.so");
  deleteThisFile("Components", "libucvtw.so");
  deleteThisFile("Components", "libucvtw2.so");
  deleteThisFile("Components", "libucvlatin.so");
  deleteThisFile("Components", "libucvcn.so");
  deleteThisFile("Components", "libucvibm.so");
  deleteThisFile("Components", "libtxtsvc.so");
  deleteThisFile("Components", "libgfx2.so");
  deleteThisFile("Components", "gfx2.xpt");
  deleteThisFile("Components", "libimggif.so");
  deleteThisFile("Components", "libimgjpeg.so");
  deleteThisFile("Components", "libimgpng.so");
  deleteThisFile("Components", "libimgbmp.so");
  deleteThisFile("Components", "libimgppm.so");
  deleteThisFile("Components", "libimgxbm.so");
  deleteThisFile("Components", "libimgmng.so");
  deleteThisFile("Components", "libunicharutil.so");
  deleteThisFile("Components", "libchardet.so");
  deleteThisFile("Components", "liblwbrk.so");
  deleteThisFile("Components", "libnslocale.so");
  deleteThisFile("Components", "libstrres.so");
  deleteThisFile("Components", "libmozbrwsr.so");
  deleteThisFile("Components", "libnkcache.so");
  deleteThisFile("Components", "libjsloader.so");
  deleteThisFile("Components", "libgkcontent.so");
  deleteThisFile("Components", "libjsurl.so");
  deleteThisFile("Components", "liburiloader.so");
  deleteThisFile("Components", "libgkview.so");
  deleteThisFile("Components", "libshistory.so");
  deleteThisFile("Components", "libjsdom.so");
  deleteThisFile("Components", "compreg.dat");
  deleteThisFile("Components", "xpti.dat");
  deleteThisFile("Components", "xptitemp.dat");
  deleteThisFile("Program",    "defaults/pref/config.js");
  deleteThisFile("Program",    "defaults/pref/initpref.js");
  deleteThisFile("Program",    "defaults/pref/bug307259.js");
  deleteThisFile("Program",    "defaults/wallet/URLFieldSchema.tbl");
  deleteThisFile("Program",    "libcmt.so");
  deleteThisFile("Program",    "libjpeg.so");
  deleteThisFile("Program",    "libprotocol.so");
}

var srDest = 21903;

var err = initInstall("Mozilla Navigator", "Browser", "1.7.12"); 
logComment("initInstall: " + err);

var communicatorFolder = getFolder("Program");
logComment("communicatorFolder: " + communicatorFolder);

if (verifyDiskSpace(communicatorFolder, srDest))
{
    // Call upgradeCleanup() before addDirectory() in case we accidentaly
    // delete files that we happen to be also installing.  This way, if we do,
    // it will just get reinstalled.  This is for safety measure.
    upgradeCleanup();
    err = addDirectory("Program",
                       "1.7.12",
                       "bin",              // jar source folder
                       communicatorFolder, // target folder
                       "",                 // target subdir 
                       true );             // force flag 

    logComment("addDirectory() returned: " + err);

    // create the plugins folder next to mozilla 
    var pluginsFolder = getFolder("Plugins");
    var ignoreErr = dirCreate(pluginsFolder);
    logComment("dirCreate() returned: " + ignoreErr);

    var cf = getFolder("Chrome");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"toolkit.jar"),"content/global-platform/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/communicator-platform/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/navigator-platform/");

    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"toolkit.jar"),"content/global-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/communicator-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/editor-region/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/navigator-region/");

    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"toolkit.jar"),"content/global/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/autoconfig/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/cookie/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/wallet/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"content-packs.jar"),"content/content-packs/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/communicator/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/editor/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/navigator/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/necko/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/mozldap/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"modern.jar"),"skin/modern/communicator/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"modern.jar"),"skin/modern/editor/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"modern.jar"),"skin/modern/global/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"modern.jar"),"skin/modern/messenger/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"modern.jar"),"skin/modern/navigator/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"classic.jar"),"skin/classic/communicator/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"classic.jar"),"skin/classic/editor/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"classic.jar"),"skin/classic/global/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"classic.jar"),"skin/classic/messenger/");
    registerChrome(SKIN | DELAYED_CHROME, getFolder(cf,"classic.jar"),"skin/classic/navigator/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"help.jar"),"content/help/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/xbl-marquee/");
    registerChrome(CONTENT | DELAYED_CHROME, getFolder(cf,"comm.jar"),"content/p3p/");

    if (err==SUCCESS)
    {
	    err = performInstall(); 
	    logComment("performInstall() returned: " + err);
        if (! ('buildID' in Install))
        {
          logComment("Running Pre-Mozilla 0.9.1");
          initInstall("Post-install Cleanup Utility", "Browser/xpicleanup", "1.7.12");
          cleanupUtility = getFolder(communicatorFolder, "xpicleanup");
          err = File.execute(cleanupUtility);
          logComment("execute() returned: " + err);
          err = performInstall();
        }
    }
    else
    {
	    cancelInstall(err);
	    logComment("cancelInstall() due to error: " + err);
    }
}
else
    cancelInstall(INSUFFICIENT_DISK_SPACE);
