/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import java.applet.AudioClip;
import java.net.URL;
import netscape.application.AWTCompatibility;
import netscape.application.Application;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Sound
implements Codable {
    String name;
    AudioClip awtSound;
    boolean shouldLoop;
    static final String NAME_KEY = "name";

    public static synchronized Sound soundNamed(String soundName) {
        if (soundName == null || soundName.equals("")) {
            return null;
        }
        Application app = Application.application();
        Sound sound = (Sound)app.soundByName.get(soundName);
        if (sound != null) {
            return sound;
        }
        URL url = app._appResources.urlForSoundNamed(soundName);
        sound = Sound.soundFromURL(url);
        if (sound == null) {
            System.err.println("Unknown sound: " + url);
            return null;
        }
        app.soundByName.put(soundName, sound);
        sound.name = soundName;
        return sound;
    }

    public static Sound soundFromURL(URL url) {
        AudioClip awtSound = AWTCompatibility.awtApplet().getAudioClip(url);
        Sound sound = new Sound();
        sound.awtSound = awtSound;
        return sound;
    }

    synchronized void nameSound(String soundName, Sound sound) {
        Application.application().soundByName.put(soundName, sound);
    }

    public String name() {
        return this.name;
    }

    public void setLoops(boolean flag) {
        this.shouldLoop = flag;
    }

    public boolean doesLoop() {
        return this.shouldLoop;
    }

    public void play() {
        if (this.awtSound != null) {
            if (this.shouldLoop) {
                this.awtSound.loop();
                return;
            }
            this.awtSound.play();
        }
    }

    public void stop() {
        if (this.awtSound != null) {
            this.awtSound.stop();
        }
    }

    public String toString() {
        if (this.name != null) {
            return "Sound(" + this.name + ")";
        }
        return super.toString();
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Sound", 1);
        info.addField(NAME_KEY, (byte)16);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.name == null) {
            throw new CodingException("An encoded Sound must have a name");
        }
        encoder.encodeString(NAME_KEY, this.name);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.name = decoder.decodeString(NAME_KEY);
        if (this.name == null) {
            throw new CodingException("A decoded Sound must have a name");
        }
        Application app = Application.application();
        URL url = app._appResources.urlForSoundNamed(this.name);
        this.awtSound = app.applet.getAudioClip(url);
        this.nameSound(this.name, this);
    }

    public void finishDecoding() throws CodingException {
    }
}

