/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import netscape.util.DeserializationException;

class TokenGenerator
extends FilterInputStream {
    public static final byte NULL_TOKEN = 0;
    public static final byte STRING_TOKEN = 1;
    public static final byte ARRAY_BEGIN_TOKEN = 2;
    public static final byte ARRAY_END_TOKEN = 3;
    public static final byte VECTOR_BEGIN_TOKEN = 4;
    public static final byte VECTOR_END_TOKEN = 5;
    public static final byte HASHTABLE_BEGIN_TOKEN = 6;
    public static final byte HASHTABLE_KEY_VALUE_SEP_TOKEN = 7;
    public static final byte HASHTABLE_KEY_VALUE_END_TOKEN = 8;
    public static final byte HASHTABLE_END_TOKEN = 9;
    public static final byte GENERIC_SEP_TOKEN = 10;
    public static final byte NULL_VALUE_TOKEN = 11;
    public static final byte LAST_TOKEN_TYPE = 11;
    static byte[] tokenToAscii = new byte[12];
    static byte[] asciiToToken;
    static final int CHARACTER_COUNT_PER_ARRAY = 128;
    static final int CCPA_BIT_COUNT = 7;
    static final int CCPA_MASK = 127;
    static final int PARSING_NONE_STATE = 0;
    static final int PARSING_STRING_STATE = 1;
    static final int PARSING_QUOTED_STRING_STATE = 2;
    static final int PARSING_COMMENT_STATE = 3;
    static final int PARSING_C_STYLE_COMMENT_STATE = 4;
    static final int PARSING_C_PLUS_PLUS_STYLE_COMMENT_STATE = 5;
    private byte[][] input = new byte[1][];
    private int nextAvailableByteIndex;
    private int markedByteIndex;
    private int nextFreeByteSlotIndex;
    private byte[] bytesForCurrentToken;
    private int currentToken;
    private int lastToken;
    private int currentLineNumber;
    private boolean previousCharacterWasBackslash = false;
    private boolean starFound = false;
    private int parserState;

    public TokenGenerator(InputStream in) {
        super(in);
        this.input[0] = new byte[128];
        this.nextAvailableByteIndex = 0;
        this.nextFreeByteSlotIndex = 0;
        this.currentLineNumber = 0;
        this.parserState = 0;
    }

    private final void markCurrentCharacter() {
        this.markedByteIndex = this.nextAvailableByteIndex;
    }

    private final void markPreviousCharacter() {
        this.markedByteIndex = this.nextAvailableByteIndex - 1;
    }

    private final void growInputBuffer() {
        byte[][] newInput = new byte[this.input.length + 1][];
        System.arraycopy(this.input, 0, newInput, 0, this.input.length);
        newInput[this.input.length] = new byte[128];
        this.input = newInput;
    }

    private final void readMoreCharacters() throws IOException {
        int length;
        int currentArrayIndex = this.nextFreeByteSlotIndex >> 7;
        if (currentArrayIndex >= this.input.length) {
            this.growInputBuffer();
        }
        if ((length = this.read(this.input[currentArrayIndex], this.nextFreeByteSlotIndex & 0x7F, 128 - (this.nextFreeByteSlotIndex & 0x7F))) != -1) {
            this.nextFreeByteSlotIndex += length;
        } else {
            return;
        }
        if (this.available() > 0 && length < 128) {
            currentArrayIndex = this.nextFreeByteSlotIndex >> 7;
            if (currentArrayIndex >= this.input.length) {
                this.growInputBuffer();
            }
            if ((length = this.read(this.input[currentArrayIndex], this.nextFreeByteSlotIndex & 0x7F, 128 - (this.nextFreeByteSlotIndex & 0x7F))) != -1) {
                this.nextFreeByteSlotIndex += length;
            }
        }
    }

    private final boolean hasMoreCharacters() throws IOException {
        if (this.nextAvailableByteIndex < this.nextFreeByteSlotIndex) {
            return true;
        }
        this.readMoreCharacters();
        return this.nextAvailableByteIndex < this.nextFreeByteSlotIndex;
    }

    private final byte peekNextCharacter() throws IOException {
        byte result = 0;
        if (this.nextAvailableByteIndex >= this.nextFreeByteSlotIndex) {
            this.readMoreCharacters();
        }
        if (this.nextAvailableByteIndex < this.nextFreeByteSlotIndex) {
            result = this.input[this.nextAvailableByteIndex >> 7][this.nextAvailableByteIndex & 0x7F];
            ++this.nextAvailableByteIndex;
        }
        return result;
    }

    private final void rewindToMarkedCharacter() {
        this.nextAvailableByteIndex = this.markedByteIndex;
    }

    private final void deletePeekedCharacters() {
        this.markedByteIndex = -1;
        while (this.nextAvailableByteIndex >> 7 > 0) {
            byte[] tmp = this.input[0];
            int i = 0;
            int c = this.input.length - 1;
            while (i < c) {
                this.input[i] = this.input[i + 1];
                ++i;
            }
            this.input[this.input.length - 1] = tmp;
            this.nextAvailableByteIndex -= 128;
            this.nextFreeByteSlotIndex -= 128;
        }
    }

    private final void deletePeekedCharactersMinusOne() {
        this.markedByteIndex = -1;
        while (this.nextAvailableByteIndex - 1 >> 7 > 0) {
            byte[] tmp = this.input[0];
            int i = 0;
            int c = this.input.length - 1;
            while (i < c) {
                this.input[i] = this.input[i + 1];
                ++i;
            }
            this.input[this.input.length - 1] = tmp;
            this.nextAvailableByteIndex -= 128;
            this.nextFreeByteSlotIndex -= 128;
        }
    }

    private final byte[] getAndDeletePeekedCharacters() {
        int length = this.nextAvailableByteIndex - this.markedByteIndex;
        byte[] result = new byte[length];
        int i = this.markedByteIndex;
        int c = this.markedByteIndex + length;
        while (i < c) {
            result[i - this.markedByteIndex] = this.input[i >> 7][i & 0x7F];
            ++i;
        }
        this.deletePeekedCharacters();
        this.markedByteIndex = -1;
        return result;
    }

    private final byte[] getAndDeletePeekedCharactersMinusOne() {
        int length = this.nextAvailableByteIndex - this.markedByteIndex - 1;
        byte[] result = new byte[length];
        int i = this.markedByteIndex;
        int c = this.markedByteIndex + length;
        while (i < c) {
            result[i - this.markedByteIndex] = this.input[i >> 7][i & 0x7F];
            ++i;
        }
        this.deletePeekedCharactersMinusOne();
        this.markedByteIndex = -1;
        return result;
    }

    private final void parseOneToken() throws DeserializationException, IOException {
        while (this.currentToken == 0) {
            if (this.nextAvailableByteIndex >= this.nextFreeByteSlotIndex) {
                this.readMoreCharacters();
                if (this.nextAvailableByteIndex >= this.nextFreeByteSlotIndex) break;
            }
            if (this.markedByteIndex == -1) {
                this.markedByteIndex = this.nextAvailableByteIndex;
            }
            byte ch = this.input[this.nextAvailableByteIndex >> 7][this.nextAvailableByteIndex & 0x7F];
            ++this.nextAvailableByteIndex;
            if (ch == 10) {
                ++this.currentLineNumber;
            }
            if (this.parserState == 2) {
                if (!this.previousCharacterWasBackslash && ch == 34) {
                    this.currentToken = 1;
                    this.bytesForCurrentToken = this.getAndDeletePeekedCharacters();
                    this.parserState = 0;
                    this.markedByteIndex = this.nextAvailableByteIndex;
                    this.previousCharacterWasBackslash = false;
                    continue;
                }
                if (ch == 92) {
                    this.previousCharacterWasBackslash = true;
                    continue;
                }
                this.previousCharacterWasBackslash = false;
                continue;
            }
            int token = ch >= 0 && ch < 127 ? asciiToToken[ch] : 0;
            if (this.parserState == 1) {
                if (ch != 34 && token == 1) continue;
                this.currentToken = 1;
                this.bytesForCurrentToken = this.getAndDeletePeekedCharactersMinusOne();
                this.parserState = 0;
                this.markedByteIndex = this.nextAvailableByteIndex - 1;
                this.rewindToMarkedCharacter();
                continue;
            }
            if (this.parserState == 3) {
                if (ch == 42) {
                    this.parserState = 4;
                    continue;
                }
                if (ch == 47) {
                    this.parserState = 5;
                    continue;
                }
                throw new DeserializationException("Syntax error at line " + this.lineForLastToken(), this.lineForLastToken());
            }
            if (this.parserState == 4) {
                if (this.starFound && ch == 47) {
                    this.starFound = false;
                    this.parserState = 0;
                    continue;
                }
                if (ch == 42) {
                    this.starFound = true;
                    continue;
                }
                this.starFound = false;
                continue;
            }
            if (this.parserState == 5) {
                if (ch != 10) continue;
                this.parserState = 0;
                continue;
            }
            if (ch == 47) {
                this.parserState = 3;
                continue;
            }
            if (token == 0) continue;
            if (token == 1) {
                this.parserState = ch == 34 ? 2 : 1;
                this.deletePeekedCharactersMinusOne();
                this.markedByteIndex = this.nextAvailableByteIndex - 1;
                continue;
            }
            this.currentToken = token;
            this.bytesForCurrentToken = null;
            this.markedByteIndex = -1;
            while (this.nextAvailableByteIndex >> 7 > 0) {
                byte[] tmp = this.input[0];
                int i = 0;
                int c = this.input.length - 1;
                while (i < c) {
                    this.input[i] = this.input[i + 1];
                    ++i;
                }
                this.input[this.input.length - 1] = tmp;
                this.nextAvailableByteIndex -= 128;
                this.nextFreeByteSlotIndex -= 128;
            }
            this.markedByteIndex = this.nextAvailableByteIndex;
        }
        if (this.currentToken == 0 && !this.hasMoreCharacters()) {
            switch (this.parserState) {
                case 1: {
                    this.currentToken = 1;
                    this.bytesForCurrentToken = this.getAndDeletePeekedCharacters();
                    this.parserState = 0;
                    this.previousCharacterWasBackslash = false;
                    return;
                }
                case 2: {
                    this.parserState = 0;
                    this.previousCharacterWasBackslash = false;
                    throw new DeserializationException("Unterminated string at line " + this.lineForLastToken(), this.lineForLastToken());
                }
                case 3: {
                    this.parserState = 0;
                    throw new DeserializationException("Syntax error at line " + this.lineForLastToken(), this.lineForLastToken());
                }
                case 4: {
                    this.parserState = 0;
                    this.starFound = false;
                    throw new DeserializationException("Unterminated comment at line " + this.lineForLastToken(), this.lineForLastToken());
                }
                case 5: {
                    this.parserState = 0;
                    return;
                }
            }
        }
    }

    public final boolean hasMoreTokens() throws DeserializationException, IOException {
        if (this.currentToken != 0) {
            return true;
        }
        this.parseOneToken();
        return this.currentToken != 0;
    }

    public final int nextToken() throws DeserializationException, IOException {
        int result = 0;
        if (this.currentToken == 0) {
            this.parseOneToken();
        }
        if (this.currentToken != 0) {
            result = this.currentToken;
            this.lastToken = this.currentToken;
            this.currentToken = 0;
        }
        return result;
    }

    public final int peekNextToken() throws DeserializationException, IOException {
        this.hasMoreTokens();
        this.lastToken = this.currentToken;
        return this.currentToken;
    }

    public final byte[] bytesForLastToken() {
        if (this.lastToken == 1) {
            return this.bytesForCurrentToken;
        }
        byte[] b = new byte[]{tokenToAscii[this.lastToken]};
        return b;
    }

    public byte byteForLastToken() {
        return tokenToAscii[this.lastToken];
    }

    public int lineForLastToken() {
        return this.currentLineNumber + 1;
    }

    static {
        TokenGenerator.tokenToAscii[0] = 0;
        TokenGenerator.tokenToAscii[1] = 0;
        TokenGenerator.tokenToAscii[2] = 91;
        TokenGenerator.tokenToAscii[3] = 93;
        TokenGenerator.tokenToAscii[4] = 40;
        TokenGenerator.tokenToAscii[5] = 41;
        TokenGenerator.tokenToAscii[6] = 123;
        TokenGenerator.tokenToAscii[7] = 61;
        TokenGenerator.tokenToAscii[8] = 59;
        TokenGenerator.tokenToAscii[9] = 125;
        TokenGenerator.tokenToAscii[10] = 44;
        TokenGenerator.tokenToAscii[11] = 64;
        asciiToToken = new byte[127];
        int i = 0;
        while (i <= 32) {
            TokenGenerator.asciiToToken[i] = 0;
            ++i;
        }
        i = 33;
        while (i < 127) {
            TokenGenerator.asciiToToken[i] = 1;
            ++i;
        }
        TokenGenerator.asciiToToken[91] = 2;
        TokenGenerator.asciiToToken[93] = 3;
        TokenGenerator.asciiToToken[40] = 4;
        TokenGenerator.asciiToToken[41] = 5;
        TokenGenerator.asciiToToken[123] = 6;
        TokenGenerator.asciiToToken[61] = 7;
        TokenGenerator.asciiToToken[59] = 8;
        TokenGenerator.asciiToToken[125] = 9;
        TokenGenerator.asciiToToken[44] = 10;
        TokenGenerator.asciiToToken[64] = 11;
        TokenGenerator.asciiToToken[47] = 0;
    }
}

