/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer.io;

import java.io.IOException;
import java.io.Reader;

class SlidingBuffer
extends Reader {
    static final int DEFAULT_BUFFER_LENGTH = 4096;
    protected Reader in;
    protected char[] buffer;
    protected int offset;
    protected int end;

    public SlidingBuffer(Reader in) {
        this.in = in;
        this.buffer = new char[4096];
    }

    public SlidingBuffer(Reader in, int buflen) {
        this.in = in;
        if (buflen < 4096) {
            buflen = 4096;
        }
        this.buffer = new char[buflen];
    }

    public int read() throws IOException {
        int amount = this.end - this.offset;
        if (amount == 0 && !this.fill()) {
            return -1;
        }
        char c = this.buffer[this.offset++];
        return c;
    }

    public int read(char[] c) throws IOException {
        int amount = this.end - this.offset;
        if (amount == 0 && !this.fill()) {
            return -1;
        }
        amount = this.end - this.offset;
        if (amount > c.length) {
            amount = c.length;
        }
        System.arraycopy(this.buffer, this.offset, c, 0, amount);
        this.offset += amount;
        return amount;
    }

    public int read(char[] c, int off, int len) throws IOException {
        int amount = this.end - this.offset;
        if (amount == 0 && !this.fill()) {
            return -1;
        }
        amount = this.end - this.offset;
        if (amount > len) {
            amount = len;
        }
        System.arraycopy(this.buffer, this.offset, c, off, amount);
        this.offset += amount;
        return amount;
    }

    public long skip(long n) throws IOException {
        int amount = this.end - this.offset;
        if ((long)amount >= n) {
            this.offset = (int)((long)this.offset + n);
            return n;
        }
        this.offset = 0;
        this.end = 0;
        return (long)amount + this.in.skip(n - (long)amount);
    }

    public int peek() throws IOException {
        int amount = this.end - this.offset;
        if (amount == 0 && !this.fill()) {
            return -1;
        }
        char c = this.buffer[this.offset];
        return c;
    }

    public void unread(int count) throws IOException {
        if (this.offset < count) {
            throw new IOException("invalid unread; offset=" + this.offset + " count=" + count);
        }
        this.offset -= count;
    }

    public boolean lookAhead(char c) throws IOException {
        int amount = this.end - this.offset;
        if (amount == 0 && !this.fill()) {
            return false;
        }
        if (this.buffer[this.offset] == c) {
            ++this.offset;
            return true;
        }
        return false;
    }

    public boolean lookAhead(String s) throws IOException {
        return this.lookAhead(s, false);
    }

    public boolean lookAhead(String s, boolean ignoreCase) throws IOException {
        int amount = this.end - this.offset;
        int slen = s.length();
        if (amount < slen && !this.fillForCapacity(slen)) {
            return false;
        }
        int i = 0;
        while (i < slen) {
            char c1 = this.buffer[this.offset + i];
            char c2 = s.charAt(i);
            if (ignoreCase) {
                c1 = Character.toLowerCase(c1);
                c2 = Character.toLowerCase(c2);
            }
            if (c1 != c2) {
                return false;
            }
            ++i;
        }
        this.offset += slen;
        return true;
    }

    public boolean eatWhiteSpace() throws IOException {
        boolean eaten = false;
        do {
            int i = this.offset;
            while (i < this.end) {
                char c = this.buffer[i];
                if (c != ' ' && c != '\t' && c != '\r' && c != '\n' && c != '\f') {
                    this.offset = i;
                    return eaten;
                }
                eaten = true;
                ++i;
            }
        } while (this.fill());
        return eaten;
    }

    public boolean eatNewline() throws IOException {
        boolean eaten = false;
        int amount = this.end - this.offset;
        if (amount < 2 && !this.fillForCapacity(2)) {
            if (this.end - this.offset == 0) {
                return false;
            }
            if (this.buffer[this.offset] == '\r' || this.buffer[this.offset] == '\n') {
                ++this.offset;
                return true;
            }
            return false;
        }
        if (this.buffer[this.offset] == '\r') {
            ++this.offset;
            eaten = true;
        }
        if (this.buffer[this.offset] == '\n') {
            eaten = true;
            ++this.offset;
        }
        return eaten;
    }

    protected boolean fill() throws IOException {
        if (this.end - this.offset != 0) {
            throw new IOException("fill of non-empty buffer");
        }
        this.offset = 0;
        this.end = this.in.read(this.buffer, 0, this.buffer.length);
        if (this.end < 0) {
            this.end = 0;
            return false;
        }
        return true;
    }

    protected boolean fillForCapacity(int capacity) throws IOException {
        int amount = this.end - this.offset;
        if (amount >= capacity) {
            return true;
        }
        if (capacity >= this.buffer.length) {
            int newBufLen = this.buffer.length * 2;
            if (newBufLen < capacity) {
                newBufLen = capacity;
            }
            char[] newbuf = new char[newBufLen];
            System.arraycopy(this.buffer, this.offset, newbuf, 0, amount);
            this.offset = 0;
            this.end = amount;
            this.buffer = newbuf;
        } else if (amount != 0) {
            System.arraycopy(this.buffer, this.offset, this.buffer, 0, amount);
            this.offset = 0;
            this.end = amount;
        }
        int mustRead = capacity - amount;
        int nb = this.in.read(this.buffer, this.offset, this.buffer.length - this.offset);
        if (nb < mustRead) {
            if (nb > 0) {
                this.end += nb;
            }
            return false;
        }
        this.end += nb;
        return true;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

