/*
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the
 * License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is the Mozilla OS/2 libraries.
 *
 * The Initial Developer of the Original Code is John Fairhurst,
 * <john_fairhurst@iname.com>.  Portions created by John Fairhurst are
 * Copyright (C) 1999 John Fairhurst. All Rights Reserved.
 *
 * Contributor(s): 
 *
 */

#ifndef _nscollationos2_h_
#define _nscollationos2_h_

#include "nsICollation.h"

class nsILocaleOS2;

class nsCollationOS2 : public nsICollation
{
 public:
   nsCollationOS2();
   virtual ~nsCollationOS2();

   // nsISupports
   NS_DECL_ISUPPORTS

   // nsICollation
   // compare two strings; result is same as strcmp
   NS_IMETHOD CompareString( const nsCollationStrength  aStrength, 
                             const nsString            &aString1,
                             const nsString            &aString2,
                             PRInt32                   *aResult);
   
   // get a length (of character) of a sort key to be generated by an
   // input string length is a byte length 
   NS_IMETHOD GetSortKeyLen( const nsCollationStrength  aStrength, 
                             const nsString            &aStringIn,
                             PRUint32                  *aOutLen);
   
   // create sort key from input string
   // length is a byte length, caller should allocate a memory for a key
   NS_IMETHOD CreateRawSortKey( const nsCollationStrength  aStrength, 
                                const nsString            &aStringIn,
                                PRUint8                   *aKey,
                                PRUint32                  *aOutLen);
   
   // create a sort key (nsString)
   NS_IMETHOD CreateSortKey( const nsCollationStrength  aStrength, 
                             const nsString            &aStringIn,
                             nsString                  &aKey);
   
   // compare two sort keys
   // length is a byte length, result is same as strcmp
   NS_IMETHOD CompareRawSortKey( const PRUint8 *aKey1, const PRUint32 aLen1, 
                                 const PRUint8 *aKey2, const PRUint32 aLen2, 
                                 PRInt32       *aResult);
   
   // compare two sort keys (nsString)
   NS_IMETHOD CompareSortKey( const nsString &aKey1,
                              const nsString &aKey2,
                              PRInt32        *aResult);
   
   // init to a specified locale
   NS_IMETHOD Initialize( nsILocale *aLocale);

 protected:
   LocaleObject mLocaleObject;
   nsILocale   *mLocale;
};

// Strange collationfactory class
class nsCollationFactoryOS2 : public nsICollationFactory
{
 public:
   nsCollationFactoryOS2();
   virtual ~nsCollationFactoryOS2();

   // nsISupports
   NS_DECL_ISUPPORTS

   // nsICollationFactory
   NS_IMETHOD CreateCollation( nsILocale *aLocale, nsICollation **aInstance);
};

#endif
