/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is Netscape Communications
 * Corporation.  Portions created by Netscape are Copyright (C) 1998
 * Netscape Communications Corporation.  All Rights Reserved.
 */

#ifndef nsCharsetMenu_h___
#define nsCharsetMenu_h___

#include "nsIFactory.h"

//----------------------------------------------------------------------------
// Global functions and data [declaration]

#define NS_CHARSETMENU_CID \
  {0xcd131b11, 0x6f85, 0x11d3, {0x8a, 0xb5, 0x0, 0x60, 0x8, 0x11, 0xa8, 0x36}}

#define NS_CHARSETMENU_PID "charset-menu"

//----------------------------------------------------------------------------
// Class nsCharsetMenuFactory [declaration]

/**
 * Factory class for the nsCharsetMenu objects.
 * 
 * @created         17/Sep/1999
 * @author  Catalin Rotaru [CATA]
 */
class nsCharsetMenuFactory : public nsIFactory
{
  NS_DECL_ISUPPORTS

public:

  /**
   * Class constructor.
   */
  nsCharsetMenuFactory();

  /**
   * Class destructor.
   */
  virtual ~nsCharsetMenuFactory();

  //--------------------------------------------------------------------------
  // Interface nsIFactory [declaration]

  NS_IMETHOD CreateInstance(nsISupports *aDelegate, const nsIID &aIID,
                            void **aResult);
  NS_IMETHOD LockFactory(PRBool aLock);
};

#endif /* nsCharsetMenu_h___ */
