/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public
 * License Version 1.1 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation. All
 * Rights Reserved.
 *
 * Contributor(s): 
 */

#ifndef nsICheckControlFrame_h___
#define nsICheckControlFrame_h___

#include "nsISupports.h"
class nsIStyleContext;

// IID for the nsICheckControlFrame class
// {401347ED-0101-11d4-9706-0060B0FB9956}
#define NS_ICHECKBOXCONTROLFRAME_IID    \
{ 0x401347ed, 0x101, 0x11d4,  \
  { 0x97, 0x6, 0x0, 0x60, 0xb0, 0xfb, 0x99, 0x56 } }

/** 
  * nsICheckControlFrame is the common interface radio buttons.
  * @see nsFromControlFrame and its base classes for more info
  */
class nsICheckboxControlFrame : public nsISupports {

public:
  NS_DEFINE_STATIC_IID_ACCESSOR(NS_ICHECKBOXCONTROLFRAME_IID)

  /**
   * Sets the Pseudo Style Contexts for the Check button
   *
   */
   NS_IMETHOD SetCheckboxFaceStyleContext(nsIStyleContext *aCheckboxFaceStyleContext) = 0;
};

#endif

