/*
 * Decompiled with CFR 0.152.
 */
package netscape.console;

import java.awt.TextArea;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class Console {
    private static InputStream in;
    private static PrintStream out;
    private static PrintStream err;
    private static TextArea console;

    public static void init(TextArea text) {
        in = System.in;
        out = System.out;
        err = System.err;
        console = text;
        System.setIn(new Input());
        System.setOut(new PrintStream(new Output()));
        System.setErr(new PrintStream(new Error()));
    }

    public static void dispose() {
        System.setIn(in);
        System.setOut(out);
        System.setErr(err);
        console = null;
    }

    private static class Input
    extends InputStream {
        byte[] buffer = new byte[1024];
        int position = 0;
        int count = 0;

        private void fillBuffer() throws EOFException {
            int length = 1024;
            if (length == -1) {
                throw new EOFException();
            }
            this.count = length;
            this.position = 0;
        }

        public int read() throws IOException {
            Input input = this;
            synchronized (input) {
                if (this.position >= this.count) {
                    this.fillBuffer();
                }
                byte by = this.buffer[this.position++];
                Object var3_3 = null;
                return by;
            }
        }

        public int read(byte[] b, int offset, int length) throws IOException {
            Input input = this;
            synchronized (input) {
                if (this.position >= this.count) {
                    this.fillBuffer();
                }
                int initialOffset = offset;
                while (offset < length && this.position < this.count) {
                    b[offset++] = this.buffer[this.position++];
                }
                int n = offset - initialOffset;
                Object var6_7 = null;
                return n;
            }
        }

        Input() {
        }
    }

    private static class Output
    extends OutputStream
    implements Runnable {
        StringBuffer buffer = new StringBuffer();

        public Output() {
            Thread flusher = new Thread((Runnable)this, String.valueOf(this.getClass().getName()) + "-Flusher");
            flusher.setDaemon(true);
            flusher.start();
        }

        public synchronized void write(int b) throws IOException {
            this.buffer.append((char)b);
            this.notify();
        }

        public synchronized void write(byte[] buffer, int offset, int count) throws IOException {
            this.buffer.append(new String(buffer, 0, offset, count));
            this.notify();
        }

        public synchronized void flush() throws IOException {
            String value = this.buffer.toString();
            console.append(value);
            this.buffer.setLength(0);
        }

        public synchronized void run() {
            while (true) {
                try {
                    while (true) {
                        this.wait();
                        this.flush();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }

    private static class Error
    extends Output {
        Error() {
        }
    }
}

