/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Color
implements Codable {
    java.awt.Color _color = java.awt.Color.white;
    public static final Color red = new Color(255, 0, 0);
    public static final Color green = new Color(0, 255, 0);
    public static final Color blue = new Color(0, 0, 255);
    public static final Color cyan = new Color(0, 255, 255);
    public static final Color magenta = new Color(255, 0, 255);
    public static final Color yellow = new Color(255, 255, 0);
    public static final Color orange = new Color(255, 200, 0);
    public static final Color pink = new Color(255, 175, 175);
    public static final Color white = new Color(255, 255, 255);
    public static final Color lightGray = new Color(192, 192, 192);
    public static final Color gray = new Color(128, 128, 128);
    public static final Color darkGray = new Color(64, 64, 64);
    public static final Color black = new Color(0, 0, 0);
    static final Color gray192 = lightGray;
    static final Color gray128 = gray;
    static final Color gray231 = new Color(231, 231, 231);
    static final Color gray204 = new Color(204, 204, 204);
    static final Color gray153 = new Color(153, 153, 153);
    static final Color gray102 = new Color(102, 102, 102);
    static final Color gray51 = new Color(51, 51, 51);
    static final Color gray160 = new Color(160, 160, 164);
    static final Color gray255 = new Color(255, 251, 240);
    static final String R_KEY = "r";
    static final String G_KEY = "g";
    static final String B_KEY = "b";
    private static Class colorClass;
    public static final String COLOR_TYPE = "netscape.application.Color";

    private static Class colorClass() {
        if (colorClass == null) {
            colorClass = black.getClass();
        }
        return colorClass;
    }

    public static int rgbForHSB(float hue, float saturation, float brightness) {
        return java.awt.Color.HSBtoRGB(hue, saturation, brightness);
    }

    public static Color colorForHSB(float hue, float saturation, float brightness) {
        return new Color(Color.rgbForHSB(hue, saturation, brightness));
    }

    public Color() {
    }

    public Color(int red, int green, int blue) {
        this();
        this._color = new java.awt.Color(red, green, blue);
    }

    public Color(int rgb) {
        this();
        this._color = new java.awt.Color(rgb);
    }

    public Color(float red, float green, float blue) {
        this();
        if ((double)red < 0.0) {
            red = 0.0f;
        }
        if ((double)red > 1.0) {
            red = 1.0f;
        }
        if ((double)green < 0.0) {
            green = 0.0f;
        }
        if ((double)green > 1.0) {
            green = 1.0f;
        }
        if ((double)blue < 0.0) {
            blue = 0.0f;
        }
        if ((double)blue > 1.0) {
            blue = 1.0f;
        }
        this._color = new java.awt.Color(red, green, blue);
    }

    Color(java.awt.Color awtColor) {
        this();
        this._color = awtColor;
    }

    public int red() {
        return this._color.getRed();
    }

    public int green() {
        return this._color.getGreen();
    }

    public int blue() {
        return this._color.getBlue();
    }

    public int rgb() {
        return this._color.getRGB();
    }

    public int hashCode() {
        return this._color.hashCode();
    }

    public boolean equals(Object anObject) {
        if (anObject instanceof Color) {
            Color theColor = (Color)anObject;
            return this._color.equals(theColor.awtColor());
        }
        if (anObject instanceof java.awt.Color) {
            return this._color.equals((java.awt.Color)anObject);
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + " (" + this.red() + ", " + this.green() + ", " + this.blue() + ")";
    }

    java.awt.Color awtColor() {
        return this._color;
    }

    public Color lighterColor() {
        int b;
        int g;
        if (this == lightGray) {
            return white;
        }
        int r = 256 * this.red() / 192;
        if (r > 255) {
            r = 255;
        }
        if ((g = 256 * this.green() / 192) > 255) {
            g = 255;
        }
        if ((b = 256 * this.blue() / 192) > 255) {
            b = 255;
        }
        return new Color(r, g, b);
    }

    public Color darkerColor() {
        if (this == lightGray) {
            return gray;
        }
        int r = 128 * this.red() / 192;
        int g = 128 * this.green() / 192;
        int b = 128 * this.blue() / 192;
        return new Color(r, g, b);
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass(COLOR_TYPE, 1);
        info.addField(R_KEY, (byte)4);
        info.addField(G_KEY, (byte)4);
        info.addField(B_KEY, (byte)4);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeByte(R_KEY, (byte)this.red());
        encoder.encodeByte(G_KEY, (byte)this.green());
        encoder.encodeByte(B_KEY, (byte)this.blue());
    }

    public void decode(Decoder decoder) throws CodingException {
        int r = decoder.decodeByte(R_KEY) & 0xFF;
        int g = decoder.decodeByte(G_KEY) & 0xFF;
        int b = decoder.decodeByte(B_KEY) & 0xFF;
        if (this.getClass() == Color.colorClass()) {
            if (r == 0) {
                if (g == 0) {
                    if (b == 0) {
                        decoder.replaceObject(black);
                        return;
                    }
                    if (b == 255) {
                        decoder.replaceObject(blue);
                        return;
                    }
                } else if (g == 255) {
                    if (b == 0) {
                        decoder.replaceObject(green);
                        return;
                    }
                    if (b == 255) {
                        decoder.replaceObject(cyan);
                        return;
                    }
                }
            } else if (r == 255) {
                if (g == 255) {
                    if (b == 255) {
                        decoder.replaceObject(white);
                        return;
                    }
                    if (b == 0) {
                        decoder.replaceObject(yellow);
                        return;
                    }
                } else if (g == 0) {
                    if (b == 0) {
                        decoder.replaceObject(red);
                        return;
                    }
                    if (b == 255) {
                        decoder.replaceObject(magenta);
                        return;
                    }
                }
            } else if (r == 192) {
                if (g == 192 && b == 192) {
                    decoder.replaceObject(lightGray);
                    return;
                }
            } else if (r == 128) {
                if (g == 128 && b == 128) {
                    decoder.replaceObject(gray);
                    return;
                }
            } else if (r == 64 && g == 64 && b == 64) {
                decoder.replaceObject(darkGray);
                return;
            }
        }
        this._color = new java.awt.Color(r, g, b);
    }

    public void finishDecoding() throws CodingException {
    }
}

