/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License.  You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Mozilla Communicator client code.
 *
 * The Initial Developer of the Original Code is Netscape Communications
 * Corporation.  Portions created by Netscape are Copyright (C) 1998
 * Netscape Communications Corporation.  All Rights Reserved.
 */

/* Do not edit - generated by gentags.pl */
#include "nsCRT.h"
#include "nsHTMLTags.h"

static char* tagTable[] = {
  "a", "abbr", "acronym", "address", "applet", "area", "b", "base", 
  "basefont", "bdo", "bgsound", "big", "blink", "blockquote", "body", "br", 
  "button", "caption", "center", "cite", "code", "col", "colgroup", "dd", 
  "del", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "font", 
  "form", "frame", "frameset", "h1", "h2", "h3", "h4", "h5", "h6", "head", 
  "hr", "html", "i", "iframe", "ilayer", "img", "input", "ins", "isindex", 
  "kbd", "keygen", "label", "layer", "legend", "li", "link", "listing", 
  "map", "menu", "meta", "multicol", "nobr", "noembed", "noframes", 
  "nolayer", "noscript", "object", "ol", "optgroup", "option", "p", "param", 
  "parsererror", "plaintext", "pre", "q", "s", "samp", "script", "select", 
  "server", "small", "sound", "sourcetext", "spacer", "span", "strike", 
  "strong", "style", "sub", "sup", "table", "tbody", "td", "textarea", 
  "tfoot", "th", "thead", "title", "tr", "tt", "u", "ul", "var", "wbr", "xmp"
};

nsHTMLTag NS_TagToEnum(const char* aTagName) {
  int low = 0;
  int high = NS_HTML_TAG_MAX - 1;
  while (low <= high) {
    int middle = (low + high) >> 1;
    int result = nsCRT::strcasecmp(aTagName, tagTable[middle]);
    if (result == 0)
      return (nsHTMLTag) (middle + 1);
    if (result < 0)
      high = middle - 1; 
    else
      low = middle + 1; 
  }
  return eHTMLTag_userdefined;
}

const char* NS_EnumToTag(nsHTMLTag aTagID) {
  if ((int(aTagID) <= 0) || (int(aTagID) > NS_HTML_TAG_MAX)) {
    return 0;
  }
  return tagTable[int(aTagID) - 1];
}

#ifdef NS_DEBUG
#include <stdio.h>

class nsTestTagTable {
public:
   nsTestTagTable() {
     const char *tag;
     nsHTMLTag id;

     // Make sure we can find everything we are supposed to
     for (int i = 0; i < NS_HTML_TAG_MAX; i++) {
       tag = tagTable[i];
       id = NS_TagToEnum(tag);
       NS_ASSERTION(id != eHTMLTag_userdefined, "can't find tag id");
       const char* check = NS_EnumToTag(id);
       NS_ASSERTION(check == tag, "can't map id back to tag");
     }

     // Make sure we don't find things that aren't there
     id = NS_TagToEnum("@");
     NS_ASSERTION(id == eHTMLTag_userdefined, "found @");
     id = NS_TagToEnum("zzzzz");
     NS_ASSERTION(id == eHTMLTag_userdefined, "found zzzzz");

     tag = NS_EnumToTag((nsHTMLTag) 0);
     NS_ASSERTION(0 == tag, "found enum 0");
     tag = NS_EnumToTag((nsHTMLTag) -1);
     NS_ASSERTION(0 == tag, "found enum -1");
     tag = NS_EnumToTag((nsHTMLTag) (NS_HTML_TAG_MAX + 1));
     NS_ASSERTION(0 == tag, "found past max enum");
   }
};
nsTestTagTable validateTagTable;
#endif

