// Most browsers don't support unicode mathematical symbols yet.
// As a workaround, this code maps them to the Symbol font using
// either the ISO-8859-1 or ISO-8859-1-to-MacRoman inverse mapping.

var mapping_Unicode = 0; // Output true unicode
var mapping_Win = 1;     // Emulate using Windows Symbol font
var mapping_Mac = 2;     // Emulate using Mac Symbol font

// CSS class names to use depending on the mapping
var cssClassNames = ["unicode", "symbol", "symbol"];


var mapping = mapping_Win;
if (navigator.platform.indexOf("Mac") != -1)
  mapping = mapping_Mac;
else if (navigator.platform.indexOf("Win") != -1 && navigator.appVersion >= 5)
  mapping = mapping_Unicode;

function defMap(unicode, win, mac) {
  return '<SPAN class="' + cssClassNames[mapping] + '">&#' + arguments[mapping] + ';</SPAN>';
}


var U_times =   defMap(0x00D7, 0xB4, 0xA5);

var U_alpha =   defMap(0x03B1, 0x61, 0x61);
var U_beta =    defMap(0x03B2, 0x62, 0x62);
var U_gamma =   defMap(0x03B3, 0x67, 0x67);
var U_delta =   defMap(0x03B4, 0x64, 0x64);
var U_epsilon = defMap(0x03B5, 0x65, 0x65);
var U_zeta =    defMap(0x03B6, 0x7A, 0x7A);
var U_eta =     defMap(0x03B7, 0x68, 0x68);
var U_theta =   defMap(0x03B8, 0x71, 0x71);
var U_iota =    defMap(0x03B9, 0x69, 0x69);
var U_kappa =   defMap(0x03BA, 0x6B, 0x6B);
var U_lambda =  defMap(0x03BB, 0x6C, 0x6C);
var U_mu =      defMap(0x03BC, 0x6D, 0x6D);
var U_nu =      defMap(0x03BD, 0x6E, 0x6E);
var U_xi =      defMap(0x03BE, 0x78, 0x78);
var U_omicron = defMap(0x03BF, 0x6F, 0x6F);
var U_pi =      defMap(0x03C0, 0x70, 0x70);
var U_rho =     defMap(0x03C1, 0x72, 0x72);
var U_sigma =   defMap(0x03C3, 0x73, 0x73);
var U_tau =     defMap(0x03C4, 0x74, 0x74);
var U_upsilon = defMap(0x03C5, 0x75, 0x75);
var U_phi =     defMap(0x03C6, 0x66, 0x66);
var U_chi =     defMap(0x03C7, 0x63, 0x63);
var U_psi =     defMap(0x03C8, 0x79, 0x79);
var U_omega =   defMap(0x03C9, 0x77, 0x77);

var U_bull =    defMap(0x2022, 0xB7, 0x2211);

var U_larr =    defMap(0x2190, 0xAC, 0xA8);
var U_uarr =    defMap(0x2191, 0xAD, 0x2260);
var U_rarr =    defMap(0x2192, 0xAE, 0xC6);
var U_darr =    defMap(0x2193, 0xAF, 0xD8);
var U_harr =    defMap(0x2194, 0xAB, 0xB4);
var U_lArr =    defMap(0x21D0, 0xDC, 0x2039);
var U_uArr =    defMap(0x21D1, 0xDD, 0x203A);
var U_rArr =    defMap(0x21D2, 0xDE, 0xFB01);
var U_dArr =    defMap(0x21D3, 0xDF, 0xFB02);
var U_hArr =    defMap(0x21D4, 0xDB, 0x20AC);

var U_forall =  defMap(0x2200, 0x22, 0x22);
var U_exist =   defMap(0x2203, 0x24, 0x24);
var U_empty =   defMap(0x2205, 0xC6, 0x2206);
var U_isin =    defMap(0x2208, 0xCE, 0x0152);
var U_notin =   defMap(0x2209, 0xCF, 0x0153);
var U_infin =   defMap(0x221E, 0xA5, 0x2022);
var U_and =     defMap(0x2227, 0xD9, 0x0178);
var U_or =      defMap(0x2228, 0xDA, 0x2044);
var U_cap =     defMap(0x2229, 0xC7, 0xAB);
var U_cup =     defMap(0x222A, 0xC8, 0xBB);
var U_cong =    defMap(0x2245, 0x40, 0x40);
var U_asymp =   defMap(0x2248, 0xBB, 0xAA);
var U_ne =      defMap(0x2260, 0xB9, 0x03C0);
var U_equiv =   defMap(0x2261, 0xBA, 0x222B);
var U_le =      defMap(0x2264, 0xA3, 0xA3);
var U_ge =      defMap(0x2265, 0xB3, 0x2265);
var U_sub =     defMap(0x2282, 0xCC, 0xC3);
var U_sup =     defMap(0x2283, 0xC9, 0x2026);
var U_nsub =    defMap(0x2284, 0xCB, 0xC0);
var U_sube =    defMap(0x2286, 0xCD, 0xD5);
var U_supe =    defMap(0x2287, 0xCA, 0xA0); //Mac Navigator confuses it with nbsp
var U_oplus =   defMap(0x2295, 0xC5, 0x2248);
var U_otimes =  defMap(0x2297, 0xC4, 0x0192);
var U_perp =    defMap(0x22A5, 0x5E, 0x5E);

var U_lceil =   defMap(0x2308, 0xE9, 0xC8);
var U_rceil =   defMap(0x2309, 0xF9, 0x02D8);
var U_lfloor =  defMap(0x230A, 0xEB, 0xCE);
var U_rfloor =  defMap(0x230B, 0xFB, 0x02DA);
var U_lang =    defMap(0x2329, 0xE1, 0xB7);
var U_rang =    defMap(0x232A, 0xF1, 0xD2);
