/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.0 (the "NPL"); you may not use this file except in
 * compliance with the NPL.  You may obtain a copy of the NPL at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the NPL is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the NPL
 * for the specific language governing rights and limitations under the
 * NPL.
 *
 * The Initial Developer of this code under the NPL is Netscape
 * Communications Corporation.  Portions created by Netscape are
 * Copyright (C) 1998 Netscape Communications Corporation.  All Rights
 * Reserved.
 */
#include "nsCSSAtoms.h"

// XXX make this be autogenerated. doh!

nsIAtom* nsCSSAtoms::activePseudo;

nsIAtom* nsCSSAtoms::disabledPseudo;

nsIAtom* nsCSSAtoms::enabledPseudo;

nsIAtom* nsCSSAtoms::firstChildPseudo;
nsIAtom* nsCSSAtoms::focusPseudo;

nsIAtom* nsCSSAtoms::hoverPseudo;

nsIAtom* nsCSSAtoms::langPseudo;
nsIAtom* nsCSSAtoms::linkPseudo;

nsIAtom* nsCSSAtoms::outOfDatePseudo;

nsIAtom* nsCSSAtoms::selectedPseudo;
nsIAtom* nsCSSAtoms::selectionPseudo;

nsIAtom* nsCSSAtoms::universalSelector;

nsIAtom* nsCSSAtoms::visitedPseudo;


static nsrefcnt gRefCnt;

void nsCSSAtoms::AddrefAtoms()
{
  if (0 == gRefCnt) {
    activePseudo = NS_NewAtom(":active");

    disabledPseudo = NS_NewAtom(":disabled");

    enabledPseudo = NS_NewAtom(":enabled");

    firstChildPseudo = NS_NewAtom(":first-child");
    focusPseudo = NS_NewAtom(":focus");

    hoverPseudo = NS_NewAtom(":hover");

    langPseudo = NS_NewAtom(":lang");
    linkPseudo = NS_NewAtom(":link");

    outOfDatePseudo = NS_NewAtom(":out-of-date");

    selectedPseudo = NS_NewAtom(":selected");
    selectionPseudo = NS_NewAtom(":selection");

    universalSelector = NS_NewAtom("*");

    visitedPseudo = NS_NewAtom(":visited");
  }
  ++gRefCnt;
}

void nsCSSAtoms::ReleaseAtoms()
{
  NS_PRECONDITION(gRefCnt != 0, "bad release atoms");
  if (--gRefCnt == 0) {
    NS_RELEASE(activePseudo);

    NS_RELEASE(disabledPseudo);

    NS_RELEASE(enabledPseudo);

    NS_RELEASE(firstChildPseudo);
    NS_RELEASE(focusPseudo);

    NS_RELEASE(hoverPseudo);

    NS_RELEASE(langPseudo);
    NS_RELEASE(linkPseudo);

    NS_RELEASE(outOfDatePseudo);

    NS_RELEASE(universalSelector);

    NS_RELEASE(selectedPseudo);
    NS_RELEASE(selectionPseudo);

    NS_RELEASE(visitedPseudo);
  }
}

