/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.Font;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.TextField;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class ContainerView
extends View
implements FormElement {
    private String title = "";
    private Font titleFont;
    private Image image;
    private TextField titleField;
    private Color backgroundColor = Color.lightGray;
    private Color titleColor = Color.black;
    private Border border = BezelBorder.groovedBezel();
    private int imageDisplayStyle = 0;
    private boolean transparent = false;
    static Vector _fieldDescription = null;
    static final String TITLE_KEY = "title";
    static final String TITLE_FONT_KEY = "titleFont";
    static final String BACKGROUND_COLOR_KEY = "backgroundColor";
    static final String TITLE_COLOR_KEY = "titleColor";
    static final String BORDER_KEY = "border";
    static final String IMAGE_KEY = "image";
    static final String IMAGE_DISPLAY_STYLE_KEY = "imageDisplayStyle";
    static final String TRANSPARENT_KEY = "transparent";

    public ContainerView() {
        this(0, 0, 0, 0);
    }

    public ContainerView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ContainerView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.titleField = new TextField(0, 0, 10, 18);
        this.titleField.setBorder(null);
        this.titleField.setTransparent(true);
        this.titleField.setEditable(false);
        this.titleField.setVertResizeInstruction(4);
        this.titleField.setHorizResizeInstruction(2);
        this.titleField.setJustification(1);
        this.titleFont = Font.fontNamed("Helvetica", 1, 12);
        this.layoutParts();
    }

    void layoutParts() {
        int rightM;
        int leftM;
        this.titleField.removeFromSuperview();
        this.titleField.setStringValue(this.title);
        this.titleField.setFont(this.titleFont);
        this.titleField.sizeToMinSize();
        if (this.border != null) {
            leftM = this.border.leftMargin();
            rightM = this.border.rightMargin();
        } else {
            leftM = 0;
            rightM = 0;
        }
        if (!this.titleField.isEmpty()) {
            this.titleField.moveTo(leftM, 0);
            this.titleField.sizeTo(this.width() - leftM - rightM, this.titleField.height());
            this.addSubview(this.titleField);
        }
    }

    public Size minSize() {
        Size basesize = super.minSize();
        Vector subviews = this.subviews();
        int maxx = 0;
        int maxy = 0;
        if (basesize.width != 0 || basesize.height != 0) {
            return basesize;
        }
        if (this.title != null && !"".equals(this.title)) {
            this.titleField.setStringValue(this.title);
            this.titleField.setFont(this.titleFont);
            maxx = this.titleField.minSize().width + 6;
            maxy = this.titleField.minSize().height + 2;
        }
        this.layoutView(0, 0);
        int count = subviews.count();
        int i = 0;
        while (i < count) {
            View v = (View)subviews.elementAt(i);
            if (v.bounds().maxX() > maxx) {
                maxx = v.bounds().maxX();
            }
            if (v.bounds().maxY() > maxy) {
                maxy = v.bounds().maxY();
            }
            ++i;
        }
        basesize.width = maxx;
        basesize.height = maxy;
        if (this.border != null) {
            basesize.width += this.border.rightMargin();
            basesize.height += this.border.bottomMargin();
        }
        return basesize;
    }

    public Rect interiorRect() {
        Rect tmpRect = this.border != null ? this.border.interiorRect(0, 0, this.width(), this.height()) : new Rect(0, 0, this.width(), this.height());
        if (this.titleField._superview != null) {
            tmpRect.y += this.titleField.bounds.height;
            tmpRect.height -= this.titleField.bounds.height;
        }
        return tmpRect;
    }

    public void setTitle(String aString) {
        this.title = aString != null ? aString : "";
        this.layoutParts();
        this.setDirty(true);
    }

    public String title() {
        return this.title;
    }

    public void setTitleColor(Color aColor) {
        if (aColor == null || aColor.equals(this.titleColor)) {
            return;
        }
        this.titleColor = aColor;
        this.titleField.setTextColor(aColor);
        this.setDirty(true);
    }

    public Color titleColor() {
        return this.titleColor;
    }

    public void setTitleFont(Font aFont) {
        this.titleFont = aFont == null ? Font.fontNamed("Helvetica", 1, 12) : aFont;
        this.layoutParts();
        this.setDirty(true);
    }

    public Font titleFont() {
        return this.titleFont;
    }

    public void setBackgroundColor(Color aColor) {
        this.backgroundColor = aColor;
        this.setDirty(true);
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setBorder(Border newBorder) {
        if (newBorder == null) {
            newBorder = EmptyBorder.emptyBorder();
        }
        this.border = newBorder;
        this.layoutParts();
        this.setDirty(true);
    }

    public Border border() {
        return this.border;
    }

    public void setImage(Image anImage) {
        this.image = anImage;
        this.setDirty(true);
    }

    public Image image() {
        return this.image;
    }

    public void setImageDisplayStyle(int aStyle) {
        if (aStyle != 0 && aStyle != 2 && aStyle != 1) {
            throw new InconsistencyException("Unknown image display style: " + aStyle);
        }
        this.imageDisplayStyle = aStyle;
        this.setDirty(true);
    }

    public int imageDisplayStyle() {
        return this.imageDisplayStyle;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
    }

    public boolean isTransparent() {
        return this.transparent || !this.titleField.isEmpty();
    }

    public void drawViewBackground(Graphics g) {
        if (!this.transparent && (this.image == null || this.imageDisplayStyle == 0 && this.backgroundColor != null)) {
            Rect tmpRect = this.image == null ? Rect.newRect() : Rect.newRect(0, 0, this.image.width(), this.image.height());
            if (!tmpRect.contains(this.bounds)) {
                tmpRect.setBounds(0, 0, this.width(), this.height());
                if (this.titleField.isInViewHierarchy()) {
                    tmpRect.moveBy(0, this.titleField.bounds.height / 2);
                    tmpRect.sizeBy(0, -this.titleField.bounds.height / 2);
                }
                g.setColor(this.backgroundColor);
                g.fillRect(tmpRect);
            }
            Rect.returnRect(tmpRect);
        }
        if (this.image != null) {
            this.image.drawWithStyle(g, 0, 0, this.width(), this.height(), this.imageDisplayStyle);
        }
    }

    public void drawViewBorder(Graphics g) {
        if (this.border == null) {
            return;
        }
        Rect borderRect = Rect.newRect(0, 0, this.width(), this.height());
        if (this.titleField.isInViewHierarchy()) {
            borderRect.moveBy(0, this.titleField.bounds.height / 2);
            borderRect.sizeBy(0, -this.titleField.bounds.height / 2);
        }
        if (!this.titleField.isInViewHierarchy()) {
            this.border.drawInRect(g, borderRect);
            Rect.returnRect(borderRect);
            return;
        }
        Size titleSize = this.titleField.minSize();
        Rect titleRect = Rect.newRect(this.titleField.bounds);
        titleRect.x = titleRect.midX() - titleSize.width / 2 - 4;
        titleRect.width = titleSize.width + 8;
        Rect clipRect = Rect.newRect(borderRect);
        clipRect.width = titleRect.x - borderRect.x;
        g.pushState();
        g.setClipRect(clipRect);
        this.border.drawInRect(g, borderRect);
        g.popState();
        clipRect.x = titleRect.maxX();
        clipRect.width = borderRect.maxX() - titleRect.maxX();
        g.pushState();
        g.setClipRect(clipRect);
        this.border.drawInRect(g, borderRect);
        g.popState();
        clipRect.x = titleRect.x;
        clipRect.y = titleRect.maxY();
        clipRect.width = titleRect.width;
        clipRect.height = borderRect.maxY() - titleRect.maxY();
        g.pushState();
        g.setClipRect(clipRect);
        this.border.drawInRect(g, borderRect);
        g.popState();
        Rect.returnRect(clipRect);
        Rect.returnRect(titleRect);
        Rect.returnRect(borderRect);
    }

    public void drawView(Graphics g) {
        this.drawViewBackground(g);
    }

    public void drawSubviews(Graphics g) {
        super.drawSubviews(g);
        this.drawViewBorder(g);
    }

    public void layoutView(int deltaX, int deltaY) {
        if (this.titleField.isInViewHierarchy()) {
            this.titleField.removeFromSuperview();
        }
        super.layoutView(deltaX, deltaY);
        this.layoutParts();
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ContainerView", 1);
        info.addField(TITLE_KEY, (byte)16);
        info.addField(TITLE_FONT_KEY, (byte)18);
        info.addField(BACKGROUND_COLOR_KEY, (byte)18);
        info.addField(TITLE_COLOR_KEY, (byte)18);
        info.addField(IMAGE_KEY, (byte)18);
        info.addField(IMAGE_DISPLAY_STYLE_KEY, (byte)8);
        info.addField(BORDER_KEY, (byte)18);
        info.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        boolean addField = false;
        if (this.titleField.superview() != null) {
            this.titleField.removeFromSuperview();
            addField = true;
        }
        super.encode(encoder);
        encoder.encodeString(TITLE_KEY, this.title);
        encoder.encodeObject(TITLE_FONT_KEY, this.titleFont);
        encoder.encodeObject(BACKGROUND_COLOR_KEY, this.backgroundColor);
        encoder.encodeObject(TITLE_COLOR_KEY, this.titleColor);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeInt(IMAGE_DISPLAY_STYLE_KEY, this.imageDisplayStyle);
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
        } else {
            encoder.encodeObject(BORDER_KEY, this.border);
        }
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
        if (addField) {
            this.addSubview(this.titleField);
        }
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.title = decoder.decodeString(TITLE_KEY);
        this.setTitleFont((Font)decoder.decodeObject(TITLE_FONT_KEY));
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUND_COLOR_KEY);
        this.setTitleColor((Color)decoder.decodeObject(TITLE_COLOR_KEY));
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.imageDisplayStyle = decoder.decodeInt(IMAGE_DISPLAY_STYLE_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }

    public void finishDecoding() throws CodingException {
        super.finishDecoding();
        String unarchTitle = this.title;
        this.title = null;
        this.setTitle(unarchTitle);
    }

    public String formElementText() {
        if (this.titleField != null) {
            return this.titleField.stringValue();
        }
        return "";
    }
}

