/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.DragSession;
import netscape.application.Graphics;
import netscape.application.InternalWindow;
import netscape.application.MouseEvent;
import netscape.application.Timer;
import netscape.application.View;

class DragView
extends InternalWindow {
    int animationCount;
    int animationDeltaX;
    int animationDeltaY;
    boolean _animatingBack;
    boolean _wasAccepted;
    Timer timer;
    DragSession session;

    public DragView() {
    }

    public DragView(DragSession session) {
        this.setBounds(session.initialX, session.initialY, session.image.width(), session.image.height());
        this.session = session;
        this._lastX = session.mouseDownX;
        this._lastY = session.mouseDownY;
        this.setType(0);
        this.setTransparent(session.image.isTransparent());
        this.contentView().setTransparent(true);
        this.setLayer(400);
        this.setRootView(session.rootView);
        this.show();
        this.rootView().setMouseView(this);
        this.draw();
    }

    public void performCommand(String command, Object data) {
        if ("animateRejectedDrag".equals(command)) {
            this.animateRejectedDrag();
            return;
        }
        super.performCommand(command, data);
    }

    private void animateRejectedDrag() {
        if (this.animationCount <= 0) {
            this.timer.stop();
            this.timer = null;
            this._animatingBack = false;
            this.animationCount = 0;
            this.animationDeltaX = 0;
            this.animationDeltaY = 0;
            this.stopDragging();
            return;
        }
        --this.animationCount;
        int animX = this._lastX - (this.animationDeltaX + this.bounds.x);
        int animY = this._lastY - (this.animationDeltaY + this.bounds.y);
        MouseEvent dragEvent = new MouseEvent(0L, -2, animX, animY, 0);
        this.mouseDragged(dragEvent);
    }

    void startAnimatingRejectedDrag() {
        this._animatingBack = true;
        if (this._lastX - this.session.mouseDownX != 0 && this._lastY - this.session.mouseDownY != 0) {
            int count;
            int increment;
            float deltaX = this._lastX - this.session.mouseDownX;
            float deltaY = this._lastY - this.session.mouseDownY;
            if (deltaX > deltaY) {
                increment = 1 + (int)(Math.abs(deltaY) / 5.0f);
                count = (int)(Math.abs(deltaY) / (float)increment);
                deltaX /= Math.abs(deltaY);
                deltaY = deltaY < 0.0f ? -1.0f : 1.0f;
            } else if (deltaY > deltaX) {
                increment = 1 + (int)(Math.abs(deltaX) / 5.0f);
                count = (int)(Math.abs(deltaX) / (float)increment);
                deltaY /= Math.abs(deltaX);
                deltaX = deltaX < 0.0f ? -1.0f : 1.0f;
            } else {
                count = 0;
                increment = 0;
            }
            if (count > 0) {
                this.animationCount = count;
                this.animationDeltaX = (int)((float)increment * deltaX);
                this.animationDeltaY = (int)((float)increment * deltaY);
                this.timer = new Timer(this, "animateRejectedDrag", 25);
                this.timer.start();
                return;
            }
            this._animatingBack = false;
            this.stopDragging();
            return;
        }
        this._animatingBack = false;
        this.stopDragging();
    }

    public boolean canBecomeMain() {
        return false;
    }

    public boolean canBecomeDocument() {
        return false;
    }

    public void mouseDragged(MouseEvent event) {
        super.mouseDragged(event);
        if (!this._animatingBack) {
            this.session.mouseDragged(event);
        }
    }

    void stopDragging() {
        if (!this.isVisible()) {
            return;
        }
        this.hide();
        this.setBuffered(false);
        this.rootView.redraw(this.bounds);
    }

    public void mouseUp(MouseEvent event) {
        super.mouseUp(event);
        this.session.mouseUp(event);
    }

    public void drawView(Graphics g) {
        this.session.image.drawAt(g, 0, 0);
    }

    public View viewForMouse(int x, int y) {
        return null;
    }
}

