/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.ApplicationEvent;
import netscape.application.Event;
import netscape.application.EventFilter;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class EventLoop
implements Runnable {
    Vector events = new Vector();
    Thread mainThread;
    private boolean shouldRun = false;
    static boolean letAwtThreadRun = true;
    Application application;

    public void addEvent(Event anEvent) {
        Vector vector = this.events;
        synchronized (vector) {
            this.events.addElement(anEvent);
            this.events.notify();
            return;
        }
    }

    final void letAWTThreadRun() {
        if (letAwtThreadRun) {
            if (!this.shouldProcessSynchronously()) {
                return;
            }
            Thread thread = Thread.currentThread();
            int priority = thread.getPriority();
            int tmpPriority = priority - 1;
            if (tmpPriority < 1) {
                tmpPriority = 1;
            }
            try {
                thread.setPriority(tmpPriority);
                Thread.yield();
                thread.setPriority(priority);
                return;
            }
            catch (SecurityException securityException) {
                letAwtThreadRun = false;
                return;
            }
        }
    }

    public void removeEvent(Event anEvent) {
        Vector vector = this.events;
        synchronized (vector) {
            this.events.removeElement(anEvent);
            return;
        }
    }

    public Object filterEvents(EventFilter filter) {
        Object returnValue;
        this.letAWTThreadRun();
        Vector vector = this.events;
        synchronized (vector) {
            returnValue = filter.filterEvents(this.events);
            this.events.notify();
        }
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Event getNextEvent() {
        Event nextEvent = null;
        Vector vector = this.events;
        synchronized (vector) {
            while (true) {
                if (this.events.count() != 0) {
                    return (Event)this.events.removeFirstElement();
                }
                try {
                    this.events.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public Event peekNextEvent() {
        Event nextEvent;
        this.letAWTThreadRun();
        Vector vector = this.events;
        synchronized (vector) {
            nextEvent = (Event)this.events.firstElement();
        }
        return nextEvent;
    }

    public void processEvent(Event nextEvent) {
        Object lock = nextEvent.synchronousLock();
        Application application = Application.application();
        application.willProcessInternalEvent(nextEvent);
        application.willProcessEvent(nextEvent);
        nextEvent.processor().processEvent(nextEvent);
        if (lock != null) {
            Object object = lock;
            synchronized (object) {
                nextEvent.clearSynchronousLock();
                lock.notify();
            }
        }
        application.didProcessEvent(nextEvent);
        application.didProcessInternalEvent(nextEvent);
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        var2_1 = this;
        synchronized (var2_1) {
            if (this.mainThread != null) {
                throw new InconsistencyException("Only one thread may run an EventLoop");
            }
            this.mainThread = Thread.currentThread();
            this.shouldRun = true;
            // MONITOREXIT @DISABLED, blocks:[0, 3] lbl8 : MonitorExitStatement: MONITOREXIT : var2_1
            if (true) ** GOTO lbl22
        }
        do {
            nextEvent = this.getNextEvent();
            if (!this.shouldRun) continue;
            try {
                this.processEvent(nextEvent);
            }
            catch (Exception e) {
                System.err.println(Application.application().exceptionHeader());
                e.printStackTrace(System.err);
                System.err.println("Restarting EventLoop.");
            }
lbl22:
            // 4 sources

        } while (this.shouldRun);
        var2_1 = this;
        synchronized (var2_1) {
            this.mainThread = null;
            return;
        }
    }

    public synchronized void stopRunning() {
        ApplicationEvent stopEvent = new ApplicationEvent();
        this.shouldRun = false;
        stopEvent.type = -25;
        this.addEvent(stopEvent);
    }

    public synchronized boolean isRunning() {
        return this.shouldRun;
    }

    synchronized boolean shouldProcessSynchronously() {
        return this.mainThread == null || Thread.currentThread() == this.mainThread;
    }

    public void addEventAndWait(Event event) {
        Object lock;
        if (Thread.currentThread() == this.mainThread) {
            throw new InconsistencyException("Can't call addEventAndWait from within the EventLoop's main thread");
        }
        Object object = lock = event.createSynchronousLock();
        synchronized (object) {
            this.addEvent(event);
            while (event.synchronousLock() != null) {
                try {
                    lock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }

    public synchronized String toString() {
        return this.events.toString();
    }
}

