/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

class FastStringBuffer {
    String string;
    char[] buffer;
    int length;
    boolean doublesCapacity;

    public FastStringBuffer() {
        this("");
    }

    public FastStringBuffer(String aString) {
        if (aString == null || aString.equals("")) {
            this.buffer = new char[8];
        } else {
            this.buffer = new char[aString.length() + 1];
            this.setStringValue(aString);
        }
        this.doublesCapacity = false;
    }

    public FastStringBuffer(String aString, int start, int end) {
        this.buffer = new char[end - start];
        this.length = end - start;
        this.string = null;
        this.doublesCapacity = false;
        aString.getChars(start, end, this.buffer, 0);
    }

    public FastStringBuffer(char aChar) {
        this.buffer = new char[8];
        this.buffer[0] = aChar;
        this.length = 1;
        this.doublesCapacity = false;
    }

    void _increaseCapacityTo(int newCapacity) {
        if (this.buffer.length <= newCapacity) {
            char[] oldBuffer = this.buffer;
            this.buffer = this.doublesCapacity ? new char[newCapacity * 2] : new char[newCapacity + 20];
            System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
        }
    }

    public void setDoublesCapacityWhenGrowing(boolean aFlag) {
        this.doublesCapacity = aFlag;
    }

    public boolean doublesCapacityWhenGrowing() {
        return this.doublesCapacity;
    }

    public void setStringValue(String aString) {
        if (aString == null || aString.equals("")) {
            this.length = 0;
        } else {
            this.length = aString.length();
            this._increaseCapacityTo(this.length);
            aString.getChars(0, this.length, this.buffer, 0);
        }
        this.string = aString;
    }

    public String toString() {
        if (this.string == null) {
            this.string = new String(this.buffer, 0, this.length);
        }
        return this.string;
    }

    public char charAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.buffer[index];
    }

    public int indexOf(char aChar, int offset) {
        if (offset < 0 || offset >= this.length) {
            throw new StringIndexOutOfBoundsException(offset);
        }
        int i = offset;
        while (i < this.length) {
            if (this.buffer[i] == aChar) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(char aChar) {
        return this.indexOf(aChar, 0);
    }

    public boolean tabOrSpaceAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.buffer[index] == ' ' || this.buffer[index] == '\t';
    }

    public void append(char aChar) {
        this._increaseCapacityTo(this.length + 1);
        this.buffer[this.length++] = aChar;
        this.string = null;
    }

    public void append(String aString) {
        if (aString == null || aString.equals("")) {
            return;
        }
        this._increaseCapacityTo(this.length + aString.length());
        aString.getChars(0, aString.length(), this.buffer, this.length);
        this.length += aString.length();
        this.string = null;
    }

    public void insert(char aChar, int index) {
        if (index < 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index >= this.length) {
            this.append(aChar);
            return;
        }
        if (this.length < this.buffer.length) {
            if (index != this.length) {
                System.arraycopy(this.buffer, index, this.buffer, index + 1, this.length - index);
            }
            this.buffer[index] = aChar;
            ++this.length;
            this.string = null;
            return;
        }
        char[] oldBuffer = this.buffer;
        this.buffer = new char[this.buffer.length + 20];
        if (index > 0) {
            System.arraycopy(oldBuffer, 0, this.buffer, 0, index);
        }
        if (index != this.length) {
            System.arraycopy(oldBuffer, index, this.buffer, index + 1, this.length - index);
        }
        this.buffer[index] = aChar;
        ++this.length;
        this.string = null;
    }

    public void insert(String aString, int index) {
        if (index < 0) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index > this.length) {
            this.append(aString);
            return;
        }
        if (aString == null || aString.equals("")) {
            return;
        }
        int stringLength = aString.length();
        if (this.length + stringLength < this.buffer.length) {
            System.arraycopy(this.buffer, index, this.buffer, index + stringLength, this.length - index);
            aString.getChars(0, stringLength, this.buffer, index);
            this.length += stringLength;
            this.string = null;
            return;
        }
        char[] oldBuffer = this.buffer;
        this.buffer = new char[this.length + stringLength + 20];
        if (index > 0) {
            System.arraycopy(oldBuffer, 0, this.buffer, 0, index);
        }
        System.arraycopy(oldBuffer, index, this.buffer, index + stringLength, this.length - index);
        aString.getChars(0, stringLength, this.buffer, index);
        this.length += stringLength;
        this.string = null;
    }

    public void removeCharAt(int index) {
        if (index < 0 || index >= this.length) {
            throw new StringIndexOutOfBoundsException(index);
        }
        if (index + 1 == this.length) {
            --this.length;
            this.string = null;
            return;
        }
        System.arraycopy(this.buffer, index + 1, this.buffer, index, this.length - (index + 1));
        --this.length;
        this.string = null;
    }

    public void truncateToLength(int aLength) {
        if (aLength < 0 || aLength > this.length) {
            return;
        }
        this.length = aLength;
        this.string = null;
    }

    public int length() {
        return this.length;
    }

    public void moveChars(int fromIndex, int toIndex) {
        if (fromIndex <= toIndex) {
            return;
        }
        if (fromIndex < 0 || fromIndex >= this.length) {
            throw new StringIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex < 0 || toIndex >= this.length) {
            throw new StringIndexOutOfBoundsException(toIndex);
        }
        System.arraycopy(this.buffer, fromIndex, this.buffer, toIndex, this.length - fromIndex);
        this.length -= fromIndex - toIndex;
        this.string = null;
    }

    public char[] charArray() {
        return this.buffer;
    }
}

