/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Application;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.DebugGraphics;
import netscape.application.DebugGraphicsInfo;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.GraphicsState;
import netscape.application.Point;
import netscape.application.Polygon;
import netscape.application.Rect;
import netscape.application.View;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Graphics {
    Vector graphicsStates = new Vector();
    java.awt.Graphics primaryAwtGraphics;
    java.awt.Graphics currentAwtGraphics;
    static int graphicsCount;
    int graphicsID = graphicsCount++;
    Rect primaryClipRect;
    Bitmap buffer;
    public static final int LEFT_JUSTIFIED = 0;
    public static final int CENTERED = 1;
    public static final int RIGHT_JUSTIFIED = 2;

    public Graphics(View view) {
        Rect absoluteBounds = view.convertRectToView(null, view.bounds);
        absoluteBounds.x -= view.bounds.x;
        absoluteBounds.y -= view.bounds.y;
        this.buffer = null;
        this.init(absoluteBounds, view.rootView().panel.getGraphics());
    }

    public Graphics(Bitmap aBitmap) {
        this.buffer = aBitmap;
        this.init(new Rect(0, 0, aBitmap.width(), aBitmap.height()), aBitmap.awtImage.getGraphics());
    }

    Graphics(Rect bounds, java.awt.Graphics awtGraphics) {
        this.init(new Rect(bounds), awtGraphics);
    }

    static Graphics newGraphics(View view) {
        if (Graphics.debugViewCount() == 0) {
            return new Graphics(view);
        }
        return new DebugGraphics(view);
    }

    static Graphics newGraphics(Bitmap bitmap) {
        if (Graphics.debugViewCount() == 0) {
            return new Graphics(bitmap);
        }
        return new DebugGraphics(bitmap);
    }

    void init(Rect clipRect, java.awt.Graphics graphics) {
        GraphicsState state = new GraphicsState();
        this.graphicsStates.addElement(state);
        state.absoluteClipRect = clipRect;
        this.currentAwtGraphics = this.primaryAwtGraphics = graphics;
        this.primaryAwtGraphics.clipRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        this.primaryClipRect = clipRect;
        state.xOffset = clipRect.x;
        state.yOffset = clipRect.y;
    }

    public void pushState() {
        GraphicsState lastState = this.state();
        GraphicsState newState = lastState != null ? (GraphicsState)lastState.clone() : new GraphicsState();
        this.graphicsStates.addElement(newState);
    }

    final void restoreAwtGraphics(java.awt.Graphics awtGraphics, GraphicsState state) {
        if (state.font != null) {
            if (state.font.wasDownloaded()) {
                awtGraphics.setFont(null);
            } else {
                awtGraphics.setFont(state.font._awtFont);
            }
        }
        if (state.color == null) {
            awtGraphics.setColor(null);
            return;
        }
        awtGraphics.setColor(state.color._color);
        if (state.xorColor != null) {
            awtGraphics.setXORMode(state.xorColor._color);
            return;
        }
        awtGraphics.setPaintMode();
    }

    public void popState() {
        GraphicsState state = this.state();
        this.graphicsStates.removeLastElement();
        if (state.awtGraphics != null) {
            state.awtGraphics.dispose();
            this.currentAwtGraphics = this.awtGraphics();
        }
        if ((state = this.state()) != null) {
            this.restoreAwtGraphics(this.currentAwtGraphics, state);
        }
    }

    final GraphicsState state() {
        return (GraphicsState)this.graphicsStates.lastElement();
    }

    java.awt.Graphics awtGraphics() {
        int iState = this.graphicsStates.count();
        while (iState-- > 0) {
            GraphicsState state = (GraphicsState)this.graphicsStates.elementAt(iState);
            if (state.awtGraphics == null) continue;
            return state.awtGraphics;
        }
        return this.primaryAwtGraphics;
    }

    public void setFont(Font aFont) {
        GraphicsState state = this.state();
        state.font = aFont;
        if (aFont == null || aFont.wasDownloaded()) {
            this.currentAwtGraphics.setFont(null);
            return;
        }
        this.currentAwtGraphics.setFont(aFont._awtFont);
    }

    public Font font() {
        return this.state().font;
    }

    public void setColor(Color aColor) {
        GraphicsState state = this.state();
        state.color = aColor;
        this.currentAwtGraphics.setColor(aColor == null ? null : aColor._color);
    }

    public Color color() {
        return this.state().color;
    }

    public void translate(int x, int y) {
        GraphicsState state = this.state();
        state.xOffset += x;
        state.yOffset += y;
        state.clipRect = null;
    }

    public int xTranslation() {
        GraphicsState state = this.state();
        return state.xOffset;
    }

    public int yTranslation() {
        GraphicsState state = this.state();
        return state.yOffset;
    }

    public Point translation() {
        GraphicsState state = this.state();
        return new Point(state.xOffset, state.yOffset);
    }

    public void setClipRect(Rect rect, boolean intersect) {
        Rect clipRect;
        GraphicsState state = this.state();
        Rect oldClipRect = this.absoluteClipRect();
        if (rect == null) {
            Rect newClipRect = clipRect = this.primaryClipRect;
            clipRect = new Rect(clipRect);
        } else {
            Rect newClipRect = rect;
            clipRect = new Rect(rect);
            clipRect.moveBy(state.xOffset, state.yOffset);
        }
        if (intersect) {
            clipRect.intersectWith(oldClipRect);
        }
        if (!clipRect.equals(oldClipRect)) {
            if (!intersect && state.awtGraphics != null) {
                state.awtGraphics.dispose();
                state.awtGraphics = null;
            }
            if (state.awtGraphics == null) {
                this.currentAwtGraphics = state.awtGraphics = this.primaryAwtGraphics.create();
                if (state.color != null) {
                    this.currentAwtGraphics.setColor(Color.white._color);
                    this.currentAwtGraphics.setColor(state.color._color);
                }
            }
            this.currentAwtGraphics.clipRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
            state.absoluteClipRect = clipRect;
            state.clipRect = null;
            this.restoreAwtGraphics(this.currentAwtGraphics, state);
        }
    }

    public void setClipRect(Rect rect) {
        this.setClipRect(rect, true);
    }

    public Rect clipRect() {
        GraphicsState state = this.state();
        if (state.clipRect != null) {
            return state.clipRect;
        }
        int iState = this.graphicsStates.count();
        while (iState-- > 0) {
            GraphicsState clipState = (GraphicsState)this.graphicsStates.elementAt(iState);
            if (clipState.absoluteClipRect == null) continue;
            state.clipRect = new Rect(clipState.absoluteClipRect);
            state.clipRect.moveBy(-state.xOffset, -state.yOffset);
            return state.clipRect;
        }
        return null;
    }

    Rect absoluteClipRect() {
        int iState = this.graphicsStates.count();
        while (iState-- > 0) {
            GraphicsState state = (GraphicsState)this.graphicsStates.elementAt(iState);
            if (state.absoluteClipRect == null) continue;
            return state.absoluteClipRect;
        }
        return null;
    }

    public void clearClipRect() {
        this.setClipRect(null, false);
    }

    public Bitmap buffer() {
        return this.buffer;
    }

    public boolean isDrawingBuffer() {
        return this.buffer != null;
    }

    public void dispose() {
        int iState = this.graphicsStates.count();
        while (iState-- > 0) {
            GraphicsState state = (GraphicsState)this.graphicsStates.elementAt(iState);
            if (state.awtGraphics == null) continue;
            state.awtGraphics.dispose();
        }
        this.graphicsStates.removeAllElements();
        this.primaryAwtGraphics.dispose();
        this.primaryAwtGraphics = null;
        this.currentAwtGraphics = null;
    }

    public void sync() {
        Application.application().syncGraphics();
    }

    public void setPaintMode() {
        GraphicsState state = this.state();
        state.xorColor = null;
        this.currentAwtGraphics.setPaintMode();
    }

    public void setXORMode(Color aColor) {
        if (aColor == null) {
            this.setPaintMode();
            return;
        }
        GraphicsState state = this.state();
        state.xorColor = aColor;
        this.currentAwtGraphics.setXORMode(aColor._color);
    }

    public void drawRect(Rect aRect) {
        this.drawRect(aRect.x, aRect.y, aRect.width, aRect.height);
    }

    public void drawRect(int x, int y, int width, int height) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.drawRect(x += state.xOffset, y += state.yOffset, width - 1, height - 1);
    }

    public void fillRect(Rect aRect) {
        this.fillRect(aRect.x, aRect.y, aRect.width, aRect.height);
    }

    public void fillRect(int x, int y, int width, int height) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.fillRect(x += state.xOffset, y += state.yOffset, width, height);
    }

    public void drawRoundedRect(Rect aRect, int arcWidth, int arcHeight) {
        this.drawRoundedRect(aRect.x, aRect.y, aRect.width, aRect.height, arcWidth, arcHeight);
    }

    public void drawRoundedRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.drawRoundRect(x += state.xOffset, y += state.yOffset, width - 1, height - 1, arcWidth, arcHeight);
    }

    public void fillRoundedRect(Rect aRect, int arcWidth, int arcHeight) {
        this.fillRoundedRect(aRect.x, aRect.y, aRect.width, aRect.height, arcWidth, arcHeight);
    }

    public void fillRoundedRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.fillRoundRect(x += state.xOffset, y += state.yOffset, width, height, arcWidth, arcHeight);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.drawLine(x1 += state.xOffset, y1 += state.yOffset, x2 += state.xOffset, y2 += state.yOffset);
    }

    public void drawPoint(int x, int y) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.drawLine(x += state.xOffset, y += state.yOffset, x, y);
    }

    public void drawOval(Rect aRect) {
        this.drawOval(aRect.x, aRect.y, aRect.width - 1, aRect.height - 1);
    }

    public void drawOval(int x, int y, int width, int height) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.drawOval(x += state.xOffset, y += state.yOffset, width, height);
    }

    public void fillOval(Rect aRect) {
        this.fillOval(aRect.x, aRect.y, aRect.width, aRect.height);
    }

    public void fillOval(int x, int y, int width, int height) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.fillOval(x += state.xOffset, y += state.yOffset, width, height);
    }

    public void drawArc(Rect aRect, int startAngle, int arcAngle) {
        this.drawArc(aRect.x, aRect.y, aRect.width, aRect.height, startAngle, arcAngle);
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.drawArc(x += state.xOffset, y += state.yOffset, width, height, startAngle, arcAngle);
    }

    public void fillArc(Rect aRect, int startAngle, int arcAngle) {
        this.fillArc(aRect.x, aRect.y, aRect.width, aRect.height, startAngle, arcAngle);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.fillArc(x += state.xOffset, y += state.yOffset, width, height, startAngle, arcAngle);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GraphicsState state = this.state();
        if (state.xOffset != 0 || state.yOffset != 0) {
            this.currentAwtGraphics.translate(state.xOffset, state.yOffset);
            this.currentAwtGraphics.drawPolygon(xPoints, yPoints, nPoints);
            this.currentAwtGraphics.translate(-state.xOffset, -state.yOffset);
            return;
        }
        this.currentAwtGraphics.drawPolygon(xPoints, yPoints, nPoints);
    }

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xPoints, polygon.yPoints, polygon.numPoints);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        GraphicsState state = this.state();
        if (state.xOffset != 0 || state.yOffset != 0) {
            this.currentAwtGraphics.translate(state.xOffset, state.yOffset);
            this.currentAwtGraphics.fillPolygon(xPoints, yPoints, nPoints);
            this.currentAwtGraphics.translate(-state.xOffset, -state.yOffset);
            return;
        }
        this.currentAwtGraphics.fillPolygon(xPoints, yPoints, nPoints);
    }

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xPoints, polygon.yPoints, polygon.numPoints);
    }

    public void drawBitmapAt(Bitmap bitmap, int x, int y) {
        GraphicsState state = this.state();
        x += state.xOffset;
        y += state.yOffset;
        if (bitmap == null) {
            return;
        }
        if (!bitmap.loadsIncrementally()) {
            bitmap.loadData();
        }
        if (!bitmap.isValid()) {
            System.err.println("Graphics.drawBitmapAt() - Invalid bitmap: " + bitmap.name());
            return;
        }
        this.currentAwtGraphics.drawImage(bitmap.awtImage, x, y, bitmap.bitmapObserver());
    }

    public void drawBitmapScaled(Bitmap bitmap, int x, int y, int width, int height) {
        GraphicsState state = this.state();
        if (bitmap == null) {
            return;
        }
        x += state.xOffset;
        y += state.yOffset;
        bitmap.createScaledVersion(width, height);
        if (!bitmap.isValid()) {
            System.err.println("Graphics.drawBitmapScaled() - Invalid bitmap: " + bitmap.name());
            return;
        }
        this.currentAwtGraphics.drawImage(bitmap.awtImage, x, y, width, height, bitmap.bitmapObserver());
    }

    static int computeStringWidth(FontMetrics fm, String str) {
        return fm.stringWidth(str);
    }

    public void drawStringInRect(String aString, int x, int y, int width, int height, int justification) {
        int startX;
        if (this.font() == null) {
            throw new InconsistencyException("No font set");
        }
        FontMetrics fontMetrics = this.font().fontMetrics();
        if (fontMetrics == null) {
            throw new InconsistencyException("No metrics for Font " + this.font());
        }
        if (justification == 1) {
            int drawWidth = Graphics.computeStringWidth(fontMetrics, aString);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + (width - drawWidth) / 2;
        } else if (justification == 2) {
            int drawWidth = Graphics.computeStringWidth(fontMetrics, aString);
            if (drawWidth > width) {
                drawWidth = width;
            }
            startX = x + width - drawWidth;
        } else {
            startX = x;
        }
        int delta = (height - fontMetrics.ascent() - fontMetrics.descent()) / 2;
        if (delta < 0) {
            delta = 0;
        }
        int startY = y + height - delta - fontMetrics.descent();
        this.drawString(aString, startX, startY);
    }

    public void drawStringInRect(String aString, Rect aRect, int justification) {
        if (aRect == null) {
            throw new InconsistencyException("Null Rect passed to drawStringInRect.");
        }
        this.drawStringInRect(aString, aRect.x, aRect.y, aRect.width, aRect.height, justification);
    }

    public void drawString(String aString, int x, int y) {
        if (aString == null) {
            throw new InconsistencyException("Null String passed to drawString.");
        }
        Font font = this.font();
        if (font == null || !font.wasDownloaded()) {
            GraphicsState state = this.state();
            this.currentAwtGraphics.drawString(aString, x += state.xOffset, y += state.yOffset);
            return;
        }
        FontMetrics fontMetrics = font.fontMetrics();
        int[] widthsArray = fontMetrics.widthsArray();
        int widthsArrayBase = fontMetrics.widthsArrayBase();
        Vector glyphVector = font.glyphVector();
        y -= fontMetrics.ascent();
        int i = 0;
        while (i < aString.length()) {
            int index = aString.charAt(i) - widthsArrayBase;
            if (index < 0 || index >= widthsArray.length - widthsArrayBase) {
                if (aString.charAt(i) == ' ') {
                    x += widthsArray[32];
                }
            } else {
                this.drawBitmapAt((Bitmap)glyphVector.elementAt(index), x, y);
                x += widthsArray[aString.charAt(i)];
            }
            ++i;
        }
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        Font font = this.font();
        if (font == null || !font.wasDownloaded()) {
            GraphicsState state = this.state();
            this.currentAwtGraphics.drawBytes(data, offset, length, x += state.xOffset, y += state.yOffset);
            return;
        }
        FontMetrics fontMetrics = font.fontMetrics();
        int[] widthsArray = fontMetrics.widthsArray();
        int widthsArrayBase = fontMetrics.widthsArrayBase();
        Vector glyphVector = font.glyphVector();
        y -= fontMetrics.ascent();
        int i = 0;
        while (i < length) {
            int index = data[i] - widthsArrayBase;
            if (index < 0 || index >= widthsArray.length - widthsArrayBase) {
                if ((char)data[i] == ' ') {
                    x += widthsArray[32];
                }
            } else {
                this.drawBitmapAt((Bitmap)glyphVector.elementAt(index), x, y);
                x += widthsArray[data[i]];
            }
            ++i;
        }
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        Font font = this.font();
        if (font == null) {
            return;
        }
        if (!font.wasDownloaded()) {
            GraphicsState state = this.state();
            this.currentAwtGraphics.drawChars(data, offset, length, x += state.xOffset, y += state.yOffset);
            return;
        }
        FontMetrics fontMetrics = font.fontMetrics();
        int[] widthsArray = fontMetrics.widthsArray();
        int widthsArrayBase = fontMetrics.widthsArrayBase();
        Vector glyphVector = font.glyphVector();
        y -= fontMetrics.ascent();
        int i = 0;
        while (i < length) {
            int index = data[i] - widthsArrayBase;
            if (index < 0 || index >= widthsArray.length - widthsArrayBase) {
                if (data[i] == ' ') {
                    x += widthsArray[32];
                }
            } else {
                this.drawBitmapAt((Bitmap)glyphVector.elementAt(index), x, y);
                x += widthsArray[data[i]];
            }
            ++i;
        }
    }

    void copyArea(int x, int y, int width, int height, int destX, int destY) {
        GraphicsState state = this.state();
        this.currentAwtGraphics.copyArea(x += state.xOffset, y += state.yOffset, width, height, (destX += state.xOffset) - x, (destY += state.yOffset) - y);
    }

    public String toString() {
        int iState = this.graphicsStates.count();
        String tmpString = this.buffer != null ? " for Bitmap " : " ";
        StringBuffer stringBuffer = new StringBuffer("Graphics" + tmpString + iState + " states:\n");
        while (iState-- > 0) {
            GraphicsState state = (GraphicsState)this.graphicsStates.elementAt(iState);
            stringBuffer.append(state.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    String toShortString() {
        StringBuffer buffer = new StringBuffer("Graphics" + (this.isDrawingBuffer() ? "<B>" : "") + "(" + this.graphicsID + ")");
        int stateDepth = this.graphicsStates.count();
        while (stateDepth-- > 0) {
            buffer.append("-");
        }
        buffer.append(">");
        return buffer.toString();
    }

    public void setDebugOptions(int debugOptions) {
        if (debugOptions != 0) {
            throw new InconsistencyException("Can't set non zero debugOptions on a Graphics.  Use DebugGraphics instead.");
        }
    }

    public int debugOptions() {
        return 0;
    }

    static DebugGraphicsInfo info() {
        Application app = Application.application();
        if (app.debugGraphicsInfo == null) {
            app.debugGraphicsInfo = new DebugGraphicsInfo();
        }
        return app.debugGraphicsInfo;
    }

    void setDebug(View view) {
    }

    static void setViewDebug(View view, int debugOptions) {
        DebugGraphicsInfo info = Graphics.info();
        info.setViewDebug(view, debugOptions);
    }

    static int shouldViewDebug(View view) {
        Application app = Application.application();
        if (app.debugGraphicsInfo == null) {
            return 0;
        }
        DebugGraphicsInfo info = app.debugGraphicsInfo;
        int debugOptions = 0;
        while (view != null) {
            debugOptions |= info.viewDebug(view);
            view = view._superview;
        }
        return debugOptions;
    }

    static int viewDebug(View view) {
        Application app = Application.application();
        if (app.debugGraphicsInfo == null) {
            return 0;
        }
        DebugGraphicsInfo info = app.debugGraphicsInfo;
        return info.viewDebug(view);
    }

    static int debugViewCount() {
        Application app = Application.application();
        if (app != null && app.debugGraphicsInfo != null && app.debugGraphicsInfo.viewToDebug != null) {
            return app.debugGraphicsInfo.viewToDebug.count();
        }
        return 0;
    }
}

