/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.AWTCompatibility;
import netscape.application.Bitmap;
import netscape.application.Color;
import netscape.application.Event;
import netscape.application.EventProcessor;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.FoundationCheckMenuItem;
import netscape.application.FoundationMenuItem;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.JDK11AirLock;
import netscape.application.Menu;
import netscape.application.Rect;
import netscape.application.Target;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;

public class MenuItem
implements Codable,
Cloneable,
EventProcessor {
    Menu submenu;
    Menu supermenu;
    java.awt.MenuItem foundationMenuItem;
    String command;
    String title;
    Target target;
    char commandKey;
    Font font;
    Image checkedImage;
    Image uncheckedImage;
    Image image;
    Image selectedImage;
    Color selectedColor;
    Color selectedTextColor;
    Color textColor;
    Color disabledColor;
    boolean selected;
    boolean separator;
    boolean state;
    boolean enabled;
    Object data;
    static final String SUBMENU_KEY = "submenu";
    static final String SUPERMENU_KEY = "supermenu";
    static final String COMMAND_KEY = "command";
    static final String TITLE_KEY = "title";
    static final String TARGET_KEY = "target";
    static final String COMMANDKEY_KEY = "commandKey";
    static final String FONT_KEY = "font";
    static final String CHECKEDIMAGE_KEY = "checkedImage";
    static final String UNCHECKEDIMAGE_KEY = "uncheckedImage";
    static final String IMAGE_KEY = "image";
    static final String SELECTEDIMAGE_KEY = "selectedImage";
    static final String SELECTEDCOLOR_KEY = "selectedColor";
    static final String SELECTEDTEXTCOLOR_KEY = "selectedTextColor";
    static final String TEXTCOLOR_KEY = "textColor";
    static final String DISABLEDCOLOR_KEY = "disabledColor";
    static final String SEPARATOR_KEY = "separator";
    static final String STATE_KEY = "state";
    static final String ENABLED_KEY = "enabled";
    static final String DATA_KEY = "data";

    public MenuItem() {
        this("", '\u0000', null, null, false);
    }

    public MenuItem(String title, String command, Target target) {
        this(title, '\u0000', command, target, false);
    }

    public MenuItem(String title, char key, String command, Target target) {
        this(title, key, command, target, false);
    }

    public MenuItem(String title, String command, Target target, boolean isCheckbox) {
        this(title, '\u0000', command, target, isCheckbox);
    }

    public MenuItem(String title, char key, String command, Target target, boolean isCheckbox) {
        this.commandKey = Character.toUpperCase(key);
        if (!isCheckbox) {
            this.foundationMenuItem = new FoundationMenuItem(title, this);
        } else {
            this.foundationMenuItem = new FoundationCheckMenuItem(title, this);
            this.setUncheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOff.gif"));
            this.setCheckedImage(Bitmap.bitmapNamed("netscape/application/RadioButtonOn.gif"));
            this.setImage(this.uncheckedImage);
            this.setSelectedImage(this.uncheckedImage);
        }
        this.setEnabled(true);
        this.setFont(new Font("Helvetica", 0, 12));
        this.setTitle(title);
        this.setTarget(target);
        this.setCommand(command);
        this.selectedColor = Color.white;
        this.textColor = Color.black;
        this.selectedTextColor = Color.black;
        this.disabledColor = Color.gray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InconsistencyException(String.valueOf(this) + ": clone() not supported :" + e);
        }
    }

    java.awt.MenuItem foundationMenuItem() {
        return this.foundationMenuItem;
    }

    public void setSeparator(boolean isSeparator) {
        this.separator = isSeparator;
        if (isSeparator) {
            this.setEnabled(true);
        }
    }

    public boolean isSeparator() {
        return this.separator;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Object data() {
        return this.data;
    }

    public void setSubmenu(Menu aMenu) {
        this.submenu = aMenu;
        if (this.submenu != null) {
            this.submenu.setSuperitem(this);
        }
    }

    public Menu submenu() {
        return this.submenu;
    }

    public boolean hasSubmenu() {
        return this.submenu != null;
    }

    public void setSupermenu(Menu aMenu) {
        this.supermenu = aMenu;
    }

    public Menu supermenu() {
        return this.supermenu;
    }

    public void setCommandKey(char key) {
        this.commandKey = Character.toUpperCase(key);
        this.setTitle(this.title);
    }

    public char commandKey() {
        return this.commandKey;
    }

    public void setState(boolean aState) {
        this.state = aState;
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem) {
            ((FoundationCheckMenuItem)this.foundationMenuItem).setState(this.state);
            if (this.state) {
                this.setImage(this.checkedImage());
                this.setSelectedImage(this.checkedImage());
                return;
            }
            this.setImage(this.uncheckedImage());
            this.setSelectedImage(this.uncheckedImage());
        }
    }

    public boolean state() {
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem) {
            return this.state;
        }
        return false;
    }

    public void setImage(Image theImage) {
        this.image = theImage;
    }

    public Image image() {
        return this.image;
    }

    public void setSelectedImage(Image theImage) {
        this.selectedImage = theImage;
    }

    public Image selectedImage() {
        return this.selectedImage;
    }

    public void setCheckedImage(Image theImage) {
        this.checkedImage = theImage;
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem && this.state()) {
            this.setImage(this.checkedImage);
            this.setSelectedImage(this.checkedImage);
        }
    }

    public Image checkedImage() {
        return this.checkedImage;
    }

    public void setUncheckedImage(Image theImage) {
        this.uncheckedImage = theImage;
        if (this.foundationMenuItem instanceof FoundationCheckMenuItem && !this.state()) {
            this.setImage(this.uncheckedImage);
            this.setSelectedImage(this.uncheckedImage);
        }
    }

    public Image uncheckedImage() {
        return this.uncheckedImage;
    }

    public void setSelectedColor(Color color) {
        this.selectedColor = color;
    }

    public Color selectedColor() {
        return this.selectedColor;
    }

    public void setSelectedTextColor(Color color) {
        this.selectedTextColor = color;
    }

    public Color selectedTextColor() {
        return this.selectedTextColor;
    }

    public void setTextColor(Color color) {
        this.textColor = color;
    }

    public Color textColor() {
        return this.textColor;
    }

    public void setDisabledColor(Color color) {
        this.disabledColor = color;
    }

    public Color disabledColor() {
        return this.disabledColor;
    }

    public void setSelected(boolean isSelected) {
        if (!this.isEnabled()) {
            isSelected = false;
        }
        this.selected = isSelected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setCommand(String newCommand) {
        this.command = newCommand;
    }

    public String command() {
        return this.command;
    }

    public void setTarget(Target aTarget) {
        this.target = aTarget;
    }

    public Target target() {
        return this.target;
    }

    public void processEvent(Event event) {
        this.sendCommand();
    }

    public void sendCommand() {
        if (this.target != null) {
            this.target.performCommand(this.command, this);
        }
    }

    private boolean canUseTabFormatter() {
        return false;
    }

    public void setTitle(String aString) {
        String tmpString = aString;
        this.title = aString;
        if (this.commandKey() != '\u0000') {
            if (JDK11AirLock.setMenuShortcut(this, this.commandKey())) {
                tmpString = aString;
            } else if (this.canUseTabFormatter()) {
                tmpString = String.valueOf(aString) + "\tCtrl+" + this.commandKey();
            } else {
                StringBuffer buf = new StringBuffer();
                FontMetrics metrics = this.font().fontMetrics();
                int maxWidth = this.supermenu() != null ? this.supermenu().minItemWidth() : this.minWidth();
                int width = metrics.stringWidth(aString);
                buf.append(aString);
                int numSpaces = (maxWidth - width) / metrics.stringWidth(" ");
                int i = 0;
                while (i < numSpaces) {
                    buf.append(' ');
                    ++i;
                }
                tmpString = String.valueOf(buf.toString()) + "  Ctrl+" + this.commandKey();
            }
        }
        this.foundationMenuItem.setLabel(tmpString);
    }

    public String title() {
        return this.title;
    }

    public int minHeight() {
        int height = 0;
        if (this.font() != null) {
            height = this.font().fontMetrics().stringHeight();
        }
        return height;
    }

    public int minWidth() {
        int width = 0;
        if (this.image != null) {
            width = this.image.width();
        }
        if (this.selectedImage != null && this.selectedImage.width() > width) {
            width = this.selectedImage.width();
        }
        if (this.font() != null) {
            width += this.font().fontMetrics().stringWidth(this.title);
        }
        if (width > 0) {
            width += 11;
        }
        return width += this.commandKeyWidth();
    }

    int commandKeyWidth() {
        int width = 0;
        if (this.font() != null && this.commandKey() != '\u0000') {
            width = this.font().fontMetrics().stringWidth("Ctrl+W");
            width += 10;
        }
        return width;
    }

    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
        if (this.hasSubmenu()) {
            this.submenu.awtMenu().enable(isEnabled);
        } else {
            this.foundationMenuItem.enable(isEnabled);
        }
        this.requestDraw();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setFont(Font aFont) {
        this.font = aFont;
        java.awt.Font awtFont = AWTCompatibility.awtFontForFont(this.font);
        this.foundationMenuItem.setFont(awtFont);
    }

    public Font font() {
        return this.font;
    }

    public void requestDraw() {
        if (this.supermenu() != null && this.supermenu().menuView != null) {
            this.supermenu().menuView.drawItemAt(this.supermenu().indexOfItem(this));
        }
    }

    protected void drawSeparator(Graphics g, Rect boundsRect) {
        int midHeight = boundsRect.y + boundsRect.height / 2;
        int width = boundsRect.x + boundsRect.width;
        g.setColor(Color.gray153);
        g.drawLine(boundsRect.x, midHeight - 1, width, midHeight - 1);
        g.setColor(Color.gray231);
        g.drawLine(boundsRect.x, midHeight, width, midHeight);
    }

    protected void drawBackground(Graphics g, Rect boundsRect) {
        if (this.isSelected()) {
            g.setColor(this.selectedColor);
            g.fillRect(boundsRect);
        }
    }

    protected void drawStringInRect(Graphics g, String title, Font titleFont, Rect textBounds, int justification) {
        int width = 0;
        if (this.isEnabled() && !this.isSelected()) {
            g.setColor(this.textColor);
        } else if (this.isEnabled() && this.isSelected()) {
            g.setColor(this.selectedTextColor);
        } else {
            g.setColor(this.disabledColor);
        }
        g.setFont(titleFont);
        g.drawStringInRect(title, textBounds, justification);
        if (this.commandKey() != '\u0000') {
            Font font = this.font();
            if (font != null) {
                width = font.fontMetrics().stringWidth("Ctrl+W");
                width += 10;
            }
            Rect textRect = new Rect(textBounds.x + textBounds.width - width, textBounds.y, width, textBounds.height);
            String string = "Ctrl+" + this.commandKey();
            g.drawStringInRect(string, textRect, 0);
        }
    }

    public void drawInRect(Graphics g, Rect boundsRect, boolean showsArrow) {
        if (this.isSeparator()) {
            this.drawSeparator(g, boundsRect);
            return;
        }
        this.drawBackground(g, boundsRect);
        Image theImage = this.isSelected() ? this.selectedImage : this.image;
        int height = 0;
        int width = 0;
        if (this.image != null) {
            width = this.image.width();
            height = this.image.height();
        }
        if (this.selectedImage != null) {
            if (this.selectedImage.width() > width) {
                width = this.selectedImage.width();
            }
            if (this.selectedImage.height() > height) {
                height = this.selectedImage.height();
            }
        }
        if (theImage != null) {
            theImage.drawAt(g, boundsRect.x, boundsRect.y + (boundsRect.height - height) / 2);
        }
        if (this.title != null && this.title.length() > 0) {
            Rect tmpRect = Rect.newRect(boundsRect.x + 2 + width, boundsRect.y, boundsRect.width - 2 - width, boundsRect.height);
            this.drawStringInRect(g, this.title, this.font(), tmpRect, 0);
            Rect.returnRect(tmpRect);
        }
        if (showsArrow && this.hasSubmenu()) {
            theImage = Bitmap.bitmapNamed("netscape/application/ScrollRightArrow.gif");
            width = theImage.width();
            height = theImage.height();
            theImage.drawAt(g, boundsRect.x + boundsRect.width - width, boundsRect.y + (boundsRect.height - height) / 2);
        }
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.MenuItem", 1);
        info.addField(SUBMENU_KEY, (byte)18);
        info.addField(SUPERMENU_KEY, (byte)18);
        info.addField(COMMAND_KEY, (byte)16);
        info.addField(TITLE_KEY, (byte)16);
        info.addField(TARGET_KEY, (byte)18);
        info.addField(COMMANDKEY_KEY, (byte)2);
        info.addField(FONT_KEY, (byte)18);
        info.addField(CHECKEDIMAGE_KEY, (byte)18);
        info.addField(UNCHECKEDIMAGE_KEY, (byte)18);
        info.addField(IMAGE_KEY, (byte)18);
        info.addField(SELECTEDIMAGE_KEY, (byte)18);
        info.addField(SELECTEDCOLOR_KEY, (byte)18);
        info.addField(SELECTEDTEXTCOLOR_KEY, (byte)18);
        info.addField(TEXTCOLOR_KEY, (byte)18);
        info.addField(DISABLEDCOLOR_KEY, (byte)18);
        info.addField(SEPARATOR_KEY, (byte)0);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(STATE_KEY, (byte)0);
        info.addField(DATA_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(SUBMENU_KEY, this.submenu);
        encoder.encodeObject(SUPERMENU_KEY, this.supermenu);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeString(TITLE_KEY, this.title);
        encoder.encodeObject(TARGET_KEY, this.target);
        encoder.encodeChar(COMMANDKEY_KEY, this.commandKey);
        encoder.encodeObject(FONT_KEY, this.font);
        encoder.encodeObject(CHECKEDIMAGE_KEY, this.checkedImage);
        encoder.encodeObject(UNCHECKEDIMAGE_KEY, this.uncheckedImage);
        encoder.encodeObject(IMAGE_KEY, this.image);
        encoder.encodeObject(SELECTEDIMAGE_KEY, this.selectedImage);
        encoder.encodeObject(SELECTEDCOLOR_KEY, this.selectedColor);
        encoder.encodeObject(SELECTEDTEXTCOLOR_KEY, this.selectedTextColor);
        encoder.encodeObject(TEXTCOLOR_KEY, this.textColor);
        encoder.encodeObject(DISABLEDCOLOR_KEY, this.disabledColor);
        encoder.encodeBoolean(SEPARATOR_KEY, this.separator);
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeBoolean(STATE_KEY, this.state);
        encoder.encodeObject(DATA_KEY, this.data);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.submenu = (Menu)decoder.decodeObject(SUBMENU_KEY);
        this.supermenu = (Menu)decoder.decodeObject(SUPERMENU_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.title = decoder.decodeString(TITLE_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.commandKey = decoder.decodeChar(COMMANDKEY_KEY);
        this.font = (Font)decoder.decodeObject(FONT_KEY);
        this.checkedImage = (Image)decoder.decodeObject(CHECKEDIMAGE_KEY);
        this.uncheckedImage = (Image)decoder.decodeObject(UNCHECKEDIMAGE_KEY);
        this.image = (Image)decoder.decodeObject(IMAGE_KEY);
        this.selectedImage = (Image)decoder.decodeObject(SELECTEDIMAGE_KEY);
        this.selectedColor = (Color)decoder.decodeObject(SELECTEDCOLOR_KEY);
        this.selectedTextColor = (Color)decoder.decodeObject(SELECTEDTEXTCOLOR_KEY);
        this.textColor = (Color)decoder.decodeObject(TEXTCOLOR_KEY);
        this.disabledColor = (Color)decoder.decodeObject(DISABLEDCOLOR_KEY);
        this.separator = decoder.decodeBoolean(SEPARATOR_KEY);
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.state = decoder.decodeBoolean(STATE_KEY);
        this.data = decoder.decodeObject(DATA_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

