/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Range
implements Codable {
    private static Range nullRange;
    public int index;
    public int length;
    static final String INDEX_KEY = "index";
    static final String LENGTH_KEY = "length";

    public static Range nullRange() {
        if (nullRange == null) {
            nullRange = new Range(-1, 0);
        }
        return nullRange;
    }

    public static Range rangeFromIntersection(Range range1, Range range2) {
        Range newRange = new Range(range1);
        newRange.intersectWith(range2);
        return newRange;
    }

    public static Range rangeFromUnion(Range range1, Range range2) {
        Range newRange = new Range(range1);
        newRange.unionWith(range2);
        return newRange;
    }

    public static Range rangeFromIndices(int index1, int index2) {
        if (index1 < index2) {
            return new Range(index1, index2 - index1);
        }
        return new Range(index2, index1 - index2);
    }

    public Range() {
        this.index = Range.nullRange().index;
        this.length = Range.nullRange().length;
    }

    public Range(int index, int length) {
        this.index = index;
        this.length = length;
    }

    public Range(Range templateRange) {
        this.index = templateRange.index;
        this.length = templateRange.length;
    }

    public int index() {
        return this.index;
    }

    public int length() {
        return this.length;
    }

    public int lastIndex() {
        return this.index + this.length - 1;
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof Range)) {
            return false;
        }
        Range aRange = (Range)anObject;
        return aRange.index == this.index && aRange.length == this.length;
    }

    public void unionWith(Range aRange) {
        this.unionWith(aRange.index, aRange.length);
    }

    public void unionWith(int anIndex, int aLength) {
        if (this.index == Range.nullRange().index) {
            this.index = anIndex;
            this.length = aLength;
            return;
        }
        if (anIndex == Range.nullRange().index) {
            return;
        }
        int low = this.index < anIndex ? this.index : anIndex;
        int high = this.index + this.length > anIndex + aLength ? this.index + this.length : anIndex + aLength;
        this.index = low;
        this.length = high - low;
    }

    public void intersectWith(Range aRange) {
        this.intersectWith(aRange.index, aRange.length);
    }

    public void intersectWith(int anIndex, int aLength) {
        int highLength;
        int highIndex;
        int lowLength;
        int lowIndex;
        if (this.index < anIndex) {
            lowIndex = this.index;
            lowLength = this.length;
            highIndex = anIndex;
            highLength = aLength;
        } else {
            lowIndex = anIndex;
            lowLength = aLength;
            highIndex = this.index;
            highLength = this.length;
        }
        if (lowIndex + lowLength <= highIndex) {
            this.index = Range.nullRange().index;
            this.length = Range.nullRange().length;
            return;
        }
        this.index = highIndex;
        if (highIndex + highLength > lowIndex + lowLength) {
            this.length = lowIndex + lowLength - highIndex;
            return;
        }
        this.length = highLength;
    }

    public String toString() {
        if (this.isNullRange()) {
            return "Null range";
        }
        return "(" + this.index + ", " + this.length + ")";
    }

    public boolean intersects(Range aRange) {
        int oldIndex = this.index;
        int oldLength = this.length;
        this.intersectWith(aRange);
        boolean result = this.index != Range.nullRange().index;
        this.index = oldIndex;
        this.length = oldLength;
        return result;
    }

    public boolean intersects(int anIndex, int aLength) {
        int oldIndex = this.index;
        int oldLength = this.length;
        this.intersectWith(anIndex, aLength);
        boolean result = this.index != Range.nullRange().index;
        this.index = oldIndex;
        this.length = oldLength;
        return result;
    }

    public boolean isNullRange() {
        return this.index == Range.nullRange().index;
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean contains(int anIndex) {
        return anIndex >= this.index && anIndex < this.index + this.length;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Range", 1);
        info.addField(INDEX_KEY, (byte)8);
        info.addField(LENGTH_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(INDEX_KEY, this.index);
        encoder.encodeInt(LENGTH_KEY, this.length);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.index = decoder.decodeInt(INDEX_KEY);
        this.length = decoder.decodeInt(LENGTH_KEY);
    }

    public void finishDecoding() throws CodingException {
    }
}

