/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.DragDestination;
import netscape.application.DragSession;
import netscape.application.Graphics;
import netscape.application.MouseEvent;
import netscape.application.Point;
import netscape.application.Rect;
import netscape.application.Scrollable;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class ScrollView
extends View
implements Scrollable {
    View contentView;
    Color backgroundColor;
    Rect clipRect;
    Vector scrollBars = new Vector();
    boolean transparent = false;
    private boolean scrollBarUpdatesEnabled = true;
    static final String CONTENTVIEW_KEY = "contentView";
    static final String BACKGROUNDC_KEY = "backgroundColor";
    static final String SCROLLERS_KEY = "scrollBars";
    static final String SCROLLERUPDATES_KEY = "scrollBarUpdatesEnabed";
    static final String TRANSPARENT_KEY = "transparent";

    public ScrollView() {
        this(0, 0, 0, 0);
    }

    public ScrollView(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public ScrollView(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.backgroundColor = Color.lightGray;
        this.setHorizResizeInstruction(2);
        this.setVertResizeInstruction(16);
    }

    public void addSubview(View aView) {
        this.subviews().removeAllElements();
        super.addSubview(aView);
    }

    public void setContentView(View aView) {
        if (this.contentView != null) {
            this.contentView.removeFromSuperview();
        }
        this.contentView = aView;
        if (this.contentView != null) {
            this.contentView.moveTo(0, 0);
            this.addSubview(this.contentView);
        }
        this.updateScrollBars();
    }

    public View contentView() {
        return this.contentView;
    }

    public int cursorForPoint(int x, int y) {
        if (this.contentView == null) {
            return 0;
        }
        Point tmpPoint = Point.newPoint(x, y);
        this.convertPointToView(this.contentView, tmpPoint, tmpPoint);
        int cursor = this.contentView.cursorForPoint(tmpPoint.x, tmpPoint.y);
        Point.returnPoint(tmpPoint);
        return cursor;
    }

    public void setBackgroundColor(Color aColor) {
        if (aColor != null) {
            this.backgroundColor = aColor;
        }
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setTransparent(boolean flag) {
        this.transparent = flag;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public void addScrollBar(Target aScrollBar) {
        this.scrollBars.addElementIfAbsent(aScrollBar);
    }

    public void removeScrollBar(Target aScrollBar) {
        this.scrollBars.removeElement(aScrollBar);
    }

    public void setScrollBarUpdatesEnabled(boolean flag) {
        this.scrollBarUpdatesEnabled = flag;
    }

    public boolean scrollBarUpdatesEnabled() {
        return this.scrollBarUpdatesEnabled;
    }

    public void updateScrollBars() {
        if (!this.scrollBarUpdatesEnabled) {
            return;
        }
        int count = this.scrollBars.count();
        int i = 0;
        while (i < count) {
            Target nextScrollBar = (Target)this.scrollBars.elementAt(i);
            nextScrollBar.performCommand("updateScrollValue", this);
            ++i;
        }
    }

    View scrollingView() {
        return this;
    }

    public void scrollRectToVisible(Rect contentRect) {
        int dx = 0;
        int dy = 0;
        if (contentRect == null || this.contentView == null) {
            return;
        }
        dx = this.positionAdjustment(this.bounds.width, contentRect.width, contentRect.x);
        dy = this.positionAdjustment(this.bounds.height, contentRect.height, contentRect.y);
        if (dx != 0 || dy != 0) {
            this.scrollBy(dx, dy);
        }
    }

    private int positionAdjustment(int parentWidth, int childWidth, int childAt) {
        if (childAt >= 0 && childWidth + childAt <= parentWidth) {
            return 0;
        }
        if (childAt <= 0 && childWidth + childAt >= parentWidth) {
            return 0;
        }
        if (childAt > 0 && childWidth <= parentWidth) {
            return -childAt + parentWidth - childWidth;
        }
        if (childAt >= 0 && childWidth >= parentWidth) {
            return -childAt;
        }
        if (childAt <= 0 && childWidth <= parentWidth) {
            return -childAt;
        }
        if (childAt < 0 && childWidth >= parentWidth) {
            return -childAt + parentWidth - childWidth;
        }
        return 0;
    }

    public void scrollTo(int x, int y) {
        boolean canCopyBits;
        Rect tmpRect = null;
        if (this.contentView == null) {
            return;
        }
        this.setClipRect(null);
        if (x > 0 || this.bounds.width >= this.contentView.bounds.width) {
            x = 0;
        } else if (x < this.bounds.width - this.contentView.bounds.width) {
            x = this.bounds.width - this.contentView.bounds.width;
        }
        if (y > 0 || this.bounds.height >= this.contentView.bounds.height) {
            y = 0;
        } else if (y < this.bounds.height - this.contentView.bounds.height) {
            y = this.bounds.height - this.contentView.bounds.height;
        }
        int dx = x - this.contentView.bounds.x;
        int dy = y - this.contentView.bounds.y;
        if (dx == 0 && dy == 0) {
            this.updateScrollBars();
            return;
        }
        boolean bl = canCopyBits = this.isBuffered() && this.drawingBufferValid;
        if (canCopyBits) {
            if (dx != 0 && dy == 0 && Math.abs(dx) < this.bounds.width) {
                tmpRect = dx < 0 ? Rect.newRect(this.bounds.width + dx, 0, -dx, this.bounds.height) : Rect.newRect(0, 0, dx, this.bounds.height);
            } else if (dx == 0 && dy != 0 && Math.abs(dy) < this.bounds.height) {
                tmpRect = dy < 0 ? Rect.newRect(0, this.bounds.height + dy, this.bounds.width, -dy) : Rect.newRect(0, 0, this.bounds.width, dy);
            }
            if (tmpRect != null) {
                this.contentView.moveTo(x, y);
                this.setClipRect(tmpRect);
                Rect.returnRect(tmpRect);
            } else {
                this.contentView.moveTo(x, y);
            }
        } else {
            this.contentView.moveTo(x, y);
        }
        if (this.scrollBarUpdatesEnabled) {
            this.updateScrollBars();
        }
        this.setDirty(true);
    }

    public void scrollBy(int deltaX, int deltaY) {
        if (this.contentView != null) {
            this.scrollTo(this.contentView.bounds.x + deltaX, this.contentView.bounds.y + deltaY);
        }
    }

    public void subviewDidResize(View aSubview) {
        if (aSubview != this.contentView) {
            return;
        }
        this.scrollBy(0, 0);
        this.drawBackground();
    }

    public void didSizeBy(int deltaWidth, int deltaHeight) {
        super.didSizeBy(deltaWidth, deltaHeight);
        this.scrollBy(0, 0);
    }

    void setClipRect(Rect aRect) {
        if (this.clipRect != null) {
            Rect.returnRect(this.clipRect);
        }
        if (aRect != null) {
            this.clipRect = Rect.newRect(aRect);
            return;
        }
        this.clipRect = null;
    }

    void updateDrawingBuffer(Rect updateRect) {
        if (this.clipRect != null && this.isBuffered() && !this.isTransparent()) {
            Graphics bufferedGraphics = this.drawingBuffer.createGraphics();
            bufferedGraphics.setDebugOptions(this.shouldDebugGraphics());
            if (this.clipRect.height != this.bounds.height) {
                if (this.clipRect.y == 0) {
                    bufferedGraphics.copyArea(this.clipRect.x, this.clipRect.y, this.clipRect.width, this.bounds.height - this.clipRect.height, this.clipRect.x, this.clipRect.maxY());
                } else {
                    bufferedGraphics.copyArea(0, this.clipRect.height, this.clipRect.width, this.bounds.height - this.clipRect.height, 0, 0);
                }
            } else if (this.clipRect.x == 0) {
                bufferedGraphics.copyArea(this.clipRect.x, this.clipRect.y, this.bounds.width - this.clipRect.width, this.clipRect.height, this.clipRect.maxX(), this.clipRect.y);
            } else {
                bufferedGraphics.copyArea(this.clipRect.width, 0, this.bounds.width - this.clipRect.width, this.clipRect.height, 0, 0);
            }
            bufferedGraphics.dispose();
            bufferedGraphics = null;
            updateRect = new Rect(updateRect);
            Rect currentDirtyRect = new Rect(0, 0, 0, 0);
            this.contentView.getDirtyRect(currentDirtyRect);
            if (currentDirtyRect.isEmpty()) {
                updateRect.intersectWith(this.clipRect);
            } else {
                currentDirtyRect.unionWith(this.clipRect);
                updateRect.intersectWith(currentDirtyRect);
            }
            this.setClipRect(null);
        }
        super.updateDrawingBuffer(updateRect);
    }

    public void computeVisibleRect(Rect aRect) {
        super.computeVisibleRect(aRect);
        if (this.clipRect != null) {
            aRect.intersectWith(this.clipRect);
        }
    }

    public void drawView(Graphics g) {
        int height;
        int width;
        if (this.isTransparent()) {
            return;
        }
        if (this.contentView != null && this.contentView.isTransparent()) {
            g.setColor(this.backgroundColor);
            Rect graphicsClipRect = g.clipRect();
            g.fillRect(graphicsClipRect.x, graphicsClipRect.y, graphicsClipRect.width, graphicsClipRect.height);
            return;
        }
        if (this.contentView != null) {
            width = this.bounds.width - this.contentView.bounds.width;
            height = this.bounds.height - this.contentView.bounds.height;
        } else {
            width = this.bounds.width;
            height = this.bounds.height;
        }
        if (width > 0) {
            g.setColor(this.backgroundColor);
            g.fillRect(this.bounds.width - width, 0, width, this.bounds.height);
        }
        if (height > 0) {
            g.setColor(this.backgroundColor);
            g.fillRect(0, this.bounds.height - height, this.bounds.width, height);
        }
        if (this.clipRect != null && this.isBuffered()) {
            if (this.clipRect.y == this.bounds.y) {
                this.drawingBuffer.drawAt(g, this.clipRect.x, this.clipRect.maxY());
                return;
            }
            this.drawingBuffer.drawAt(g, this.clipRect.x, -this.clipRect.height);
        }
    }

    public void drawSubviews(Graphics g) {
        super.drawSubviews(g);
        this.setClipRect(null);
    }

    void drawBackground() {
        int height;
        int width;
        if (this.contentView != null) {
            width = this.bounds.width - this.contentView.bounds.width;
            height = this.bounds.height - this.contentView.bounds.height;
        } else {
            width = this.bounds.width;
            height = this.bounds.height;
        }
        Rect tmpRect = Rect.newRect();
        if (width > 0) {
            tmpRect.setBounds(this.bounds.width - width, 0, width, this.bounds.height);
            this.addDirtyRect(tmpRect);
        }
        if (height > 0) {
            tmpRect.setBounds(0, this.bounds.height - height, this.bounds.width, height);
            this.addDirtyRect(tmpRect);
        }
        Rect.returnRect(tmpRect);
    }

    public boolean mouseDown(MouseEvent event) {
        if (this.contentView != null) {
            boolean wantsEvents = this.contentView.mouseDown(this.convertEventToView(this.contentView, event));
            if (wantsEvents) {
                this.rootView().setMouseView(this.contentView);
                return true;
            }
            return false;
        }
        return false;
    }

    public DragDestination acceptsDrag(DragSession session, int x, int y) {
        if (this.contentView != null) {
            return this.contentView.acceptsDrag(session, x - this.contentView.bounds.x, y - this.contentView.bounds.y);
        }
        return null;
    }

    public int lengthOfScrollViewForAxis(int axis) {
        if (axis == 0) {
            return this.bounds.width;
        }
        return this.bounds.height;
    }

    public int lengthOfContentViewForAxis(int axis) {
        if (this.contentView == null) {
            return 0;
        }
        if (axis == 0) {
            return this.contentView.bounds.width;
        }
        return this.contentView.bounds.height;
    }

    public int positionOfContentViewForAxis(int axis) {
        if (this.contentView == null) {
            return 0;
        }
        if (axis == 0) {
            return this.contentView.bounds.x;
        }
        return this.contentView.bounds.y;
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.ScrollView", 1);
        info.addField(CONTENTVIEW_KEY, (byte)18);
        info.addField(BACKGROUNDC_KEY, (byte)18);
        info.addField(SCROLLERS_KEY, (byte)18);
        info.addField(SCROLLERUPDATES_KEY, (byte)0);
        info.addField(TRANSPARENT_KEY, (byte)0);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(CONTENTVIEW_KEY, this.contentView);
        encoder.encodeObject(BACKGROUNDC_KEY, this.backgroundColor);
        encoder.encodeObject(SCROLLERS_KEY, this.scrollBars);
        encoder.encodeBoolean(SCROLLERUPDATES_KEY, this.scrollBarUpdatesEnabled);
        encoder.encodeBoolean(TRANSPARENT_KEY, this.transparent);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.contentView = (View)decoder.decodeObject(CONTENTVIEW_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDC_KEY);
        this.scrollBars = (Vector)decoder.decodeObject(SCROLLERS_KEY);
        this.scrollBarUpdatesEnabled = decoder.decodeBoolean(SCROLLERUPDATES_KEY);
        this.transparent = decoder.decodeBoolean(TRANSPARENT_KEY);
    }
}

