/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Vector;

public class Size
implements Codable {
    public int width;
    public int height;
    private static Vector _sizeCache = new Vector();
    private static boolean _cacheSizes = true;
    static final String WIDTH_KEY = "width";
    static final String HEIGHT_KEY = "height";

    public Size() {
    }

    public Size(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Size(Size templateSize) {
        this.width = templateSize.width;
        this.height = templateSize.height;
    }

    public boolean isEmpty() {
        return this.width == 0 || this.height == 0;
    }

    public String toString() {
        return "(" + this.width + ", " + this.height + ")";
    }

    public void sizeTo(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void sizeBy(int deltaWidth, int deltaHeight) {
        this.sizeTo(this.width + deltaWidth, this.height + deltaHeight);
    }

    public void union(Size aSize) {
        if (this.width < aSize.width) {
            this.width = aSize.width;
        }
        if (this.height < aSize.height) {
            this.height = aSize.height;
        }
    }

    public boolean equals(Object anObject) {
        if (!(anObject instanceof Size)) {
            return false;
        }
        Size aSize = (Size)anObject;
        return aSize.width == this.width && aSize.height == this.height;
    }

    public int hashCode() {
        return this.width ^ this.height;
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.Size", 1);
        info.addField(WIDTH_KEY, (byte)8);
        info.addField(HEIGHT_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeInt(WIDTH_KEY, this.width);
        encoder.encodeInt(HEIGHT_KEY, this.height);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.width = decoder.decodeInt(WIDTH_KEY);
        this.height = decoder.decodeInt(HEIGHT_KEY);
    }

    public void finishDecoding() throws CodingException {
    }

    static Size newSize(int width, int height) {
        Size theSize;
        Vector vector = _sizeCache;
        synchronized (vector) {
            if (!_cacheSizes || _sizeCache.isEmpty()) {
                Size size = new Size(width, height);
                Object var5_4 = null;
                return size;
            }
            theSize = (Size)_sizeCache.removeLastElement();
        }
        theSize.sizeTo(width, height);
        return theSize;
    }

    static Size newSize(Size templateSize) {
        if (templateSize == null) {
            return Size.newSize(0, 0);
        }
        return Size.newSize(templateSize.width, templateSize.height);
    }

    static Size newSize() {
        return Size.newSize(0, 0);
    }

    static void returnSize(Size aSize) {
        if (!_cacheSizes) {
            return;
        }
        Vector vector = _sizeCache;
        synchronized (vector) {
            if (_sizeCache.count() < 30) {
                _sizeCache.addElement(aSize);
            }
            return;
        }
    }

    static void returnSizes(Vector sizes) {
        if (sizes == null || !_cacheSizes) {
            return;
        }
        int i = sizes.count();
        while (i-- > 0) {
            Size.returnSize((Size)sizes.elementAt(i));
        }
        sizes.removeAllElements();
    }

    static void setShouldCacheSizes(boolean flag) {
        Vector vector = _sizeCache;
        synchronized (vector) {
            _cacheSizes = flag;
            if (!_cacheSizes) {
                _sizeCache.removeAllElements();
            }
            return;
        }
    }
}

