/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.BezelBorder;
import netscape.application.Border;
import netscape.application.Color;
import netscape.application.EmptyBorder;
import netscape.application.FormElement;
import netscape.application.Graphics;
import netscape.application.Image;
import netscape.application.MouseEvent;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class Slider
extends View
implements Target,
FormElement {
    Target target;
    Border border = BezelBorder.loweredBezel();
    Image backgroundImage;
    Image knobImage;
    Color backgroundColor = Color.gray;
    String command;
    int value;
    int minValue = 0;
    int maxValue = 255;
    int sliderX;
    int knobHeight = 13;
    int grooveHeight = 8;
    int clickOffset;
    int imageDisplayStyle;
    boolean enabled = true;
    int incrementResolution;
    static Vector _fieldDescription;
    private static final int SLIDER_KNOB_WIDTH = 6;
    static final String TARGET_KEY = "target";
    static final String BACKGROUND_IMAGE_KEY = "backgroundImage";
    static final String KNOB_IMAGE_KEY = "knobImage";
    static final String BACKGROUNDC_KEY = "backgroundColor";
    static final String COMMAND_KEY = "command";
    static final String VALUE_KEY = "value";
    static final String MINVALUE_KEY = "minValue";
    static final String MAXVALUE_KEY = "maxValue";
    static final String KNOB_HEIGHT_KEY = "knobHeight";
    static final String GROOVE_HEIGHT_KEY = "grooveHeight";
    static final String BORDER_KEY = "border";
    static final String ENABLED_KEY = "enabled";
    static final String IMAGEDISP_KEY = "imageDisplayStyle";
    static final String INC_RES_KEY = "incrementResolution";
    public static final String INCREASE_VALUE = "increaseValue";
    public static final String DECREASE_VALUE = "decreaseValue";

    public Slider() {
        this(0, 0, 0, 0);
    }

    public Slider(Rect rect) {
        this(rect.x, rect.y, rect.width, rect.height);
    }

    public Slider(int x, int y, int width, int height) {
        super(x, y, width, height);
        this.setValue(0);
        this._setupKeyboard();
        this.incrementResolution = 20;
    }

    private static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public Size minSize() {
        if (this._minSize != null) {
            return new Size(this._minSize);
        }
        return new Size(this.knobWidth() + 2, this.knobHeight > this.grooveHeight ? this.knobHeight : this.grooveHeight);
    }

    public void setLimits(int minValue, int maxValue) {
        if (minValue >= maxValue) {
            return;
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        if (this.value < minValue) {
            this.value = minValue;
        } else if (this.value > maxValue) {
            this.value = maxValue;
        }
        int realValue = this.value;
        this.value = this.value > 0 ? --this.value : ++this.value;
        this.setValue(realValue);
    }

    public int minValue() {
        return this.minValue;
    }

    public int maxValue() {
        return this.maxValue;
    }

    public void setKnobImage(Image anImage) {
        if (anImage == this.knobImage) {
            return;
        }
        this.knobImage = anImage;
        if (anImage != null) {
            this.knobHeight = anImage.height();
        }
        this.setValue(this.value);
    }

    public Image knobImage() {
        return this.knobImage;
    }

    public void setBackgroundColor(Color aColor) {
        if (this.backgroundColor != null) {
            this.backgroundColor = aColor;
        }
    }

    public Color backgroundColor() {
        return this.backgroundColor;
    }

    public void setImage(Image anImage) {
        this.backgroundImage = anImage;
    }

    public Image image() {
        return this.backgroundImage;
    }

    public void setImageDisplayStyle(int aStyle) {
        if (aStyle != 0 && aStyle != 2 && aStyle != 1) {
            throw new InconsistencyException("Unknown image display style: " + aStyle);
        }
        this.imageDisplayStyle = aStyle;
        this.draw();
    }

    public int imageDisplayStyle() {
        return this.imageDisplayStyle;
    }

    public void setTarget(Target aTarget) {
        this.target = aTarget;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String command() {
        return this.command;
    }

    public void sendCommand() {
        if (this.target != null) {
            this.target.performCommand(this.command, this);
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled != this.enabled) {
            this.enabled = enabled;
            this.draw();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int knobWidth() {
        if (this.knobImage != null) {
            return this.knobImage.width();
        }
        return 6;
    }

    public void setKnobHeight(int anInt) {
        if (anInt > 0) {
            this.knobHeight = anInt;
        }
    }

    public int knobHeight() {
        return this.knobHeight;
    }

    public void setGrooveHeight(int anInt) {
        if (anInt > 0) {
            this.grooveHeight = anInt;
        }
    }

    public int grooveHeight() {
        return this.grooveHeight;
    }

    public void setBorder(Border newBorder) {
        if (newBorder == null) {
            newBorder = EmptyBorder.emptyBorder();
        }
        this.border = newBorder;
        this.setValue(this.value);
    }

    public Border border() {
        return this.border;
    }

    void redrawView(int oldSliderX) {
        if (this.sliderX == oldSliderX) {
            return;
        }
        Rect tmpRect = this.sliderX < oldSliderX ? Rect.newRect(this.sliderX, 0, oldSliderX - this.sliderX + this.knobWidth(), this.bounds.height) : Rect.newRect(oldSliderX, 0, this.sliderX - oldSliderX + this.knobWidth(), this.bounds.height);
        this.draw(tmpRect);
        Rect.returnRect(tmpRect);
    }

    void recomputeSliderPosition() {
        int normalizedValue = this.value - this.minValue;
        float normalizedMaxValue = this.maxValue - this.minValue;
        this.sliderX = (int)((float)normalizedValue / normalizedMaxValue * (float)(this.bounds.width - this.knobWidth()));
    }

    public void setValue(int aValue) {
        if (aValue < this.minValue || aValue > this.maxValue) {
            return;
        }
        if (this.value != aValue) {
            this.value = aValue;
            int oldX = this.sliderX;
            this.recomputeSliderPosition();
            this.redrawView(oldX);
        }
    }

    public int value() {
        return this.value;
    }

    public void drawViewGroove(Graphics g) {
        int yOffset = (this.bounds.height - this.grooveHeight) / 2;
        Rect tmpRect = Rect.newRect(0, yOffset, this.bounds.width, this.grooveHeight);
        this.border.drawInRect(g, tmpRect);
        this.border.computeInteriorRect(tmpRect, tmpRect);
        if (this.backgroundImage != null) {
            g.pushState();
            g.setClipRect(tmpRect);
            this.backgroundImage.drawWithStyle(g, tmpRect, this.imageDisplayStyle);
            g.popState();
        } else {
            if (!this.enabled) {
                g.setColor(Color.lightGray);
            } else {
                g.setColor(this.backgroundColor);
            }
            g.fillRect(tmpRect);
        }
        Rect.returnRect(tmpRect);
    }

    public Rect knobRect() {
        int y = this.knobImage != null ? (this.bounds.height - this.knobImage.height()) / 2 : (this.bounds.height - this.grooveHeight) / 2 - (this.knobHeight - this.grooveHeight) / 2;
        return Rect.newRect(this.sliderX, y, this.knobWidth(), this.knobHeight);
    }

    public void drawViewKnob(Graphics g) {
        Rect knobRect = this.knobRect();
        if (this.knobImage != null) {
            this.knobImage.drawAt(g, knobRect.x, knobRect.y);
        } else {
            BezelBorder.raisedButtonBezel().drawInRect(g, knobRect);
            g.setColor(Color.lightGray);
            g.fillRect(knobRect.x + 2, knobRect.y + 2, knobRect.width - 4, knobRect.height - 4);
        }
        Rect.returnRect(knobRect);
    }

    public void drawView(Graphics g) {
        this.drawViewGroove(g);
        this.drawViewKnob(g);
    }

    int _positionFromPoint(int point) {
        int knobWidth = this.knobWidth();
        if ((point -= knobWidth / 2) < 0) {
            point = 0;
        } else if (point > this.bounds.width - knobWidth) {
            point = this.bounds.width - knobWidth;
        }
        return point;
    }

    void _moveSliderTo(int point) {
        int oldX = this.sliderX;
        this.sliderX = this._positionFromPoint(point);
        this.value = (int)((double)(this.maxValue - this.minValue) / (double)(this.bounds.width - this.knobWidth()) * (double)this.sliderX) + this.minValue;
        this.redrawView(oldX);
    }

    public void didSizeBy(int deltaWidth, int deltaHeight) {
        this.recomputeSliderPosition();
        super.didSizeBy(deltaWidth, deltaHeight);
    }

    public boolean mouseDown(MouseEvent event) {
        if (!this.enabled) {
            return false;
        }
        Rect knobRect = this.knobRect();
        if (knobRect.contains(event.x, event.y)) {
            this.clickOffset = this._positionFromPoint(event.x) - this.sliderX;
        } else {
            this.clickOffset = 0;
            this._moveSliderTo(event.x);
        }
        this.sendCommand();
        return true;
    }

    public void mouseDragged(MouseEvent event) {
        this._moveSliderTo(event.x - this.clickOffset);
        this.sendCommand();
    }

    public void describeClassInfo(ClassInfo info) {
        super.describeClassInfo(info);
        info.addClass("netscape.application.Slider", 2);
        info.addField(TARGET_KEY, (byte)18);
        info.addField(BACKGROUND_IMAGE_KEY, (byte)18);
        info.addField(KNOB_IMAGE_KEY, (byte)18);
        info.addField(BACKGROUNDC_KEY, (byte)18);
        info.addField(BORDER_KEY, (byte)18);
        info.addField(COMMAND_KEY, (byte)16);
        info.addField(VALUE_KEY, (byte)8);
        info.addField(MINVALUE_KEY, (byte)8);
        info.addField(MAXVALUE_KEY, (byte)8);
        info.addField(KNOB_HEIGHT_KEY, (byte)8);
        info.addField(GROOVE_HEIGHT_KEY, (byte)8);
        info.addField(IMAGEDISP_KEY, (byte)8);
        info.addField(ENABLED_KEY, (byte)0);
        info.addField(INC_RES_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(TARGET_KEY, (Codable)((Object)this.target));
        encoder.encodeObject(BACKGROUND_IMAGE_KEY, this.backgroundImage);
        encoder.encodeObject(KNOB_IMAGE_KEY, this.knobImage);
        encoder.encodeObject(BACKGROUNDC_KEY, this.backgroundColor);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeInt(VALUE_KEY, this.value);
        encoder.encodeInt(MINVALUE_KEY, this.minValue);
        encoder.encodeInt(MAXVALUE_KEY, this.maxValue);
        encoder.encodeInt(KNOB_HEIGHT_KEY, this.knobHeight);
        encoder.encodeInt(GROOVE_HEIGHT_KEY, this.grooveHeight);
        if (this.border instanceof EmptyBorder) {
            encoder.encodeObject(BORDER_KEY, null);
        } else {
            encoder.encodeObject(BORDER_KEY, this.border);
        }
        encoder.encodeBoolean(ENABLED_KEY, this.enabled);
        encoder.encodeInt(IMAGEDISP_KEY, this.imageDisplayStyle);
        encoder.encodeInt(INC_RES_KEY, this.incrementResolution);
    }

    public void decode(Decoder decoder) throws CodingException {
        int version = decoder.versionForClassName("netscape.application.Slider");
        super.decode(decoder);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.backgroundImage = (Image)decoder.decodeObject(BACKGROUND_IMAGE_KEY);
        this.knobImage = (Image)decoder.decodeObject(KNOB_IMAGE_KEY);
        this.backgroundColor = (Color)decoder.decodeObject(BACKGROUNDC_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.value = decoder.decodeInt(VALUE_KEY);
        this.minValue = decoder.decodeInt(MINVALUE_KEY);
        this.maxValue = decoder.decodeInt(MAXVALUE_KEY);
        this.knobHeight = decoder.decodeInt(KNOB_HEIGHT_KEY);
        this.grooveHeight = decoder.decodeInt(GROOVE_HEIGHT_KEY);
        this.setBorder((Border)decoder.decodeObject(BORDER_KEY));
        this.enabled = decoder.decodeBoolean(ENABLED_KEY);
        this.imageDisplayStyle = decoder.decodeInt(IMAGEDISP_KEY);
        if (version > 1) {
            this.incrementResolution = decoder.decodeInt(INC_RES_KEY);
            return;
        }
        this.incrementResolution = 20;
    }

    void _setupKeyboard() {
        this.removeAllCommandsForKeys();
        this.setCommandForKey(INCREASE_VALUE, 1007, 0);
        this.setCommandForKey(DECREASE_VALUE, 1006, 0);
        this.setCommandForKey(INCREASE_VALUE, 43, 0);
        this.setCommandForKey(DECREASE_VALUE, 45, 0);
    }

    public boolean canBecomeSelectedView() {
        return true;
    }

    public void performCommand(String command, Object data) {
        if (INCREASE_VALUE.equals(command)) {
            int newValue = this.value() + (int)Math.rint((double)(this.maxValue - this.minValue) / (double)this.incrementResolution);
            if (newValue > this.maxValue) {
                newValue = this.maxValue;
            }
            this.setValue(newValue);
            this.sendCommand();
            return;
        }
        if (DECREASE_VALUE.equals(command)) {
            int newValue = this.value() - (int)Math.rint((double)(this.maxValue - this.minValue) / (double)this.incrementResolution);
            if (newValue < this.minValue) {
                newValue = this.minValue;
            }
            this.setValue(newValue);
            this.sendCommand();
        }
    }

    public int incrementResolution() {
        return this.incrementResolution;
    }

    public void setIncrementResolution(int aValue) {
        this.incrementResolution = aValue;
    }

    public String formElementText() {
        return Integer.toString(this.value());
    }
}

