/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.FastStringBuffer;
import netscape.application.Graphics;
import netscape.application.Range;
import netscape.application.Rect;
import netscape.application.TextParagraphFormat;
import netscape.application.TextPositionInfo;
import netscape.application.TextStyleRun;
import netscape.application.TextView;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Hashtable;
import netscape.util.InconsistencyException;
import netscape.util.Vector;

public class TextParagraph
implements Cloneable,
Codable {
    TextView _owner;
    TextParagraphFormat _format;
    Vector _runVector;
    int _y;
    int _height;
    int[] _lineBreaks;
    int _breakCount;
    int[] _lineHeights;
    int _heightCount;
    int[] _baselines;
    int _baselineCount;
    int[] _lineRemainders;
    int _remainderCount;
    int _charCount;
    int _startChar;
    static final String FORMAT_KEY = "format";
    static final String RUNVECTOR_KEY = "runVector";

    public TextParagraph() {
    }

    TextParagraph(TextView owner) {
        this();
        this.init(owner);
    }

    TextParagraph(TextView owner, TextParagraphFormat format) {
        this();
        this.init(owner, format);
    }

    void init(TextView owner, TextParagraphFormat format) {
        this._owner = owner;
        this._runVector = new Vector();
        this.setFormat(format);
    }

    void init(TextView owner) {
        this.init(owner, null);
    }

    Object objectAt(Vector vector, int index) {
        if (index < 0 || index >= vector.count()) {
            return null;
        }
        return vector.elementAt(index);
    }

    public Object clone() {
        Object clone = null;
        this.collectEmptyRuns();
        try {
            clone = super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InconsistencyException(String.valueOf(this) + ": clone() not supported :" + e);
        }
        if (clone != null) {
            TextParagraph cloneParagraph = (TextParagraph)clone;
            cloneParagraph._owner = null;
            cloneParagraph._format = this._format != null ? (TextParagraphFormat)this._format.clone() : null;
            cloneParagraph._runVector = new Vector();
            int count = this._runVector.count();
            int i = 0;
            while (i < count) {
                TextStyleRun nextRun = (TextStyleRun)this._runVector.elementAt(i);
                cloneParagraph.addRun(nextRun.createEmptyRun());
                ++i;
            }
            cloneParagraph._lineBreaks = null;
            cloneParagraph._lineHeights = null;
            cloneParagraph._baselines = null;
            cloneParagraph._lineRemainders = null;
        }
        return clone;
    }

    void setOwner(TextView owner) {
        this._owner = owner;
    }

    TextView owner() {
        return this._owner;
    }

    void setY(int y) {
        this._y = y;
    }

    void setStartChar(int absPosition) {
        this._startChar = absPosition;
    }

    void setFormat(TextParagraphFormat format) {
        if (format == null && this._format == null) {
            return;
        }
        this._format = format != null ? (TextParagraphFormat)format.clone() : null;
        if (this._charCount > 0) {
            this.computeLineBreaksAndHeights(this._owner.bounds.width);
        }
    }

    TextParagraphFormat format() {
        return this._format;
    }

    TextParagraphFormat currentParagraphFormat() {
        if (this._format != null) {
            return this._format;
        }
        TextParagraphFormat f = null;
        if (this._owner != null) {
            f = (TextParagraphFormat)this._owner.defaultAttributes().get("ParagraphFormatKey");
        }
        if (f != null) {
            return f;
        }
        return new TextParagraphFormat();
    }

    Vector runVector() {
        return this._runVector;
    }

    TextStyleRun firstRun() {
        return (TextStyleRun)this._runVector.firstElement();
    }

    TextStyleRun lastRun() {
        return (TextStyleRun)this._runVector.lastElement();
    }

    void addRun(TextStyleRun aRun) {
        if (aRun != null) {
            aRun.setParagraph(this);
            this._runVector.addElement(aRun);
        }
    }

    void collectEmptyRuns() {
        int i = 1;
        int c = this._runVector.count();
        while (i < c) {
            TextStyleRun run = (TextStyleRun)this._runVector.elementAt(i);
            if (run.charCount() == 0 && (run._attributes == null || run._attributes.get("LinkDestinationKey") == null)) {
                this._runVector.removeElementAt(i);
                --i;
                --c;
            }
            ++i;
        }
    }

    void addRuns(Vector runVector) {
        if (runVector != null) {
            int count = runVector.count();
            int i = 0;
            while (i < count) {
                this.addRun((TextStyleRun)runVector.elementAt(i));
                ++i;
            }
        }
    }

    void insertRunAt(TextStyleRun aRun, int index) {
        if (aRun != null && index >= 0) {
            aRun.setParagraph(this);
            this._runVector.insertElementAt(aRun, index);
        }
    }

    TextStyleRun runBefore(TextStyleRun aRun) {
        if (aRun == null) {
            return null;
        }
        int index = this._runVector.indexOfIdentical(aRun);
        if (index < 1) {
            return null;
        }
        return (TextStyleRun)this._runVector.elementAt(index - 1);
    }

    TextStyleRun runAfter(TextStyleRun aRun) {
        if (aRun == null) {
            return null;
        }
        int index = this._runVector.indexOfIdentical(aRun);
        if (index == this._runVector.count() - 1) {
            return null;
        }
        return (TextStyleRun)this._runVector.elementAt(index + 1);
    }

    Vector runsBefore(TextStyleRun aRun) {
        Vector runVector = TextView.newVector();
        if (aRun == null) {
            return runVector;
        }
        int index = this._runVector.indexOfIdentical(aRun);
        if (index == -1) {
            return runVector;
        }
        int i = 0;
        while (i < index) {
            runVector.addElement(this._runVector.elementAt(i));
            ++i;
        }
        return runVector;
    }

    Vector runsAfter(TextStyleRun aRun) {
        Vector runVector = TextView.newVector();
        if (aRun == null) {
            return runVector;
        }
        int i = this._runVector.indexOfIdentical(aRun);
        if (i == -1) {
            return runVector;
        }
        int count = this._runVector.count();
        while (i < count) {
            runVector.addElement(this._runVector.elementAt(i));
            ++i;
        }
        return runVector;
    }

    /*
     * Unable to fully structure code
     */
    Vector runsFromTo(TextStyleRun startRun, TextStyleRun endRun) {
        runVector = TextView.newVector();
        if (startRun == endRun && startRun != null) {
            runVector.addElement(startRun);
            return runVector;
        }
        i = startRun == null ? 0 : this._runVector.indexOfIdentical(startRun);
        end = endRun == null ? this._runVector.count() - 1 : this._runVector.indexOfIdentical(endRun);
        if (i >= 0 && end >= 0) ** GOTO lbl11
        return runVector;
lbl-1000:
        // 1 sources

        {
            runVector.addElement(this._runVector.elementAt(i));
            ++i;
lbl11:
            // 2 sources

            ** while (i <= end)
        }
lbl12:
        // 1 sources

        return runVector;
    }

    void removeRun(TextStyleRun aRun) {
        if (aRun != null) {
            this._runVector.removeElement(aRun);
        }
    }

    void removeRuns(Vector runVector) {
        if (runVector == null) {
            return;
        }
        int i = runVector.count();
        while (i-- > 0) {
            this._runVector.removeElement(runVector.elementAt(i));
        }
    }

    void removeRunAt(int index) {
        this._runVector.removeElementAt(index);
    }

    boolean isEmpty() {
        int count = 0;
        int i = this._runVector.count();
        while (i-- > 0 && count == 0) {
            TextStyleRun nextRun = (TextStyleRun)this._runVector.elementAt(i);
            count += nextRun.charCount();
        }
        return count == 0;
    }

    int[] _growArrayTo(int[] anArray, int newSize) {
        int i;
        if (newSize < 1) {
            return anArray;
        }
        if (anArray != null && anArray.length >= newSize) {
            return anArray;
        }
        int[] oldArray = anArray;
        if (anArray != null) {
            i = anArray.length;
            while (i < newSize) {
                i *= 2;
            }
        } else {
            i = 20;
        }
        anArray = new int[i];
        if (oldArray == null) {
            return anArray;
        }
        System.arraycopy(oldArray, 0, anArray, 0, oldArray.length);
        return anArray;
    }

    void _addLineBreak(int position) {
        if (position < 0) {
            return;
        }
        this._lineBreaks = this._growArrayTo(this._lineBreaks, this._breakCount + 1);
        this._lineBreaks[this._breakCount] = position;
        ++this._breakCount;
    }

    void _addLineHeightAndBaseline(int height, int baseline) {
        if (height < 0 || baseline < 0) {
            return;
        }
        this._lineHeights = this._growArrayTo(this._lineHeights, this._heightCount + 1);
        this._lineHeights[this._heightCount] = height;
        ++this._heightCount;
        this._baselines = this._growArrayTo(this._baselines, this._baselineCount + 1);
        this._baselines[this._baselineCount] = baseline;
        ++this._baselineCount;
    }

    void _addLineRemainder(int width) {
        if (width < 0) {
            width = 0;
        }
        this._lineRemainders = this._growArrayTo(this._lineRemainders, this._remainderCount + 1);
        this._lineRemainders[this._remainderCount] = width;
        ++this._remainderCount;
    }

    int addWidthOfInitialTabs(int offsetX) {
        int tabCount = 0;
        int[] tabPositions = this.currentParagraphFormat().tabPositions();
        int i = 0;
        int c = this._runVector.count();
        while (i < c) {
            TextStyleRun run = (TextStyleRun)this._runVector.elementAt(i);
            FastStringBuffer rString = run._contents;
            if (rString == null || rString.length() == 0) break;
            int j = 0;
            int d = rString.length();
            while (j < d && rString.charAt(j) == '\t') {
                ++tabCount;
                ++j;
            }
            if (j < d) break;
            ++i;
        }
        if (tabCount == 0) {
            return offsetX;
        }
        i = 0;
        c = tabPositions.length;
        while (i < c) {
            if (tabPositions[i] >= offsetX) break;
            ++i;
        }
        if (i == c) {
            return offsetX;
        }
        if ((i += tabCount) >= tabPositions.length) {
            return tabPositions[tabPositions.length - 1];
        }
        return tabPositions[i - 1];
    }

    void computeLineBreaksAndHeights(int maxWidth) {
        this.computeLineBreaksAndHeights(maxWidth, 0);
    }

    /*
     * Unable to fully structure code
     */
    void computeLineBreaksAndHeights(int maxWidth, int fromLine) {
        format = this.currentParagraphFormat();
        if (fromLine > 0) {
            --fromLine;
        }
        this._breakCount = fromLine;
        this._heightCount = fromLine;
        this._baselineCount = fromLine;
        this._remainderCount = fromLine;
        if (format._justification == 0 && fromLine == 0) {
            this._lineRemainders = null;
        }
        if ((maxWidth -= format._leftMargin + format._rightMargin) < 1) {
            maxWidth = 1;
        }
        if (fromLine == 0) {
            remainingWidth = maxWidth - format._leftIndent;
            if (remainingWidth < 1) {
                remainingWidth = 1;
            }
            startingWidth = remainingWidth;
            this._height = 0;
            this._charCount = 0;
        } else {
            remainingWidth = maxWidth;
            startingWidth = maxWidth;
            this._height = 0;
            i = 0;
            while (i < fromLine) {
                this._height += this._lineHeights[i];
                ++i;
            }
            this._charCount = this._lineBreaks[fromLine - 1];
        }
        count = this._runVector.count();
        currentCharNumber = this._charCount;
        currentLineHeight = 0;
        currentLineBaseline = 0;
        descenderHeight = 0;
        ascenderHeight = 0;
        initialCurrentX = currentX = format._leftMargin;
        if (fromLine == 0) {
            currentX += format._leftIndent;
        }
        if (format.wrapsUnderFirstCharacter()) {
            initialCurrentX = this.addWidthOfInitialTabs(format._leftMargin + format._leftIndent);
            remainingWidth = maxWidth -= initialCurrentX - currentX;
        }
        if (fromLine == 0) {
            i = 0;
            nextRun = null;
            totalCharsInRun = 0;
            runCharsUsed = 0;
        } else {
            nextRun = this.runForCharPosition(this._startChar + this._charCount);
            i = this._runVector.indexOfIdentical(nextRun) + 1;
            totalCharsInRun = nextRun.charCount();
            runCharsUsed = this._startChar + this._charCount - nextRun.rangeIndex();
            this._charCount += nextRun.rangeIndex() + totalCharsInRun - (this._startChar + this._charCount);
        }
        block1: while (true) {
            if (nextRun == null || runCharsUsed >= totalCharsInRun) {
                if (i == this._runVector.count()) break;
                if ((nextRun = (TextStyleRun)this._runVector.elementAt(i++)).charCount() == 0) continue;
                runCharsUsed = 0;
                totalCharsInRun = nextRun.charCount();
                this._charCount += totalCharsInRun;
            }
            while (true) {
                if (runCharsUsed < totalCharsInRun) ** break;
                continue block1;
                charactersAddedToLine = nextRun.charsForWidth(runCharsUsed, currentX, remainingWidth, startingWidth, format._tabStops);
                if (charactersAddedToLine > 0) {
                    runCharsUsed += charactersAddedToLine;
                    currentCharNumber += charactersAddedToLine;
                    newAscenderHeight = nextRun.baseline();
                    newDescenderHeight = nextRun.height() - nextRun.baseline();
                    if (ascenderHeight < newAscenderHeight) {
                        ascenderHeight = newAscenderHeight;
                    }
                    if (descenderHeight < newDescenderHeight) {
                        descenderHeight = newDescenderHeight;
                    }
                    if (ascenderHeight + descenderHeight > currentLineHeight) {
                        currentLineHeight = ascenderHeight + descenderHeight;
                    }
                    if (ascenderHeight > currentLineBaseline) {
                        currentLineBaseline = ascenderHeight;
                    }
                    currentX += remainingWidth - nextRun._remainder;
                    remainingWidth = nextRun._remainder;
                }
                if (runCharsUsed >= totalCharsInRun) continue;
                this._addLineBreak(currentCharNumber);
                this._addLineHeightAndBaseline(currentLineHeight + format._lineSpacing, currentLineBaseline);
                this._height += currentLineHeight + format._lineSpacing;
                this._addLineRemainder(remainingWidth);
                remainingWidth = startingWidth = maxWidth;
                currentLineBaseline = 0;
                currentLineHeight = 0;
                descenderHeight = 0;
                ascenderHeight = 0;
                currentX = initialCurrentX;
            }
            break;
        }
        this._addLineBreak(currentCharNumber);
        if (currentLineHeight == 0) {
            nextRun = (TextStyleRun)this._runVector.firstElement();
            currentLineHeight = nextRun.height() + format._lineSpacing;
            currentLineBaseline = nextRun.baseline();
        } else {
            currentLineHeight += format._lineSpacing;
        }
        this._addLineHeightAndBaseline(currentLineHeight, currentLineBaseline);
        this._height += currentLineHeight;
        this._addLineRemainder(remainingWidth);
        ++this._charCount;
    }

    int characterStartingLine(int lineNumber) {
        if (lineNumber == 0) {
            return this._startChar;
        }
        if (lineNumber < this._breakCount) {
            return this._startChar + this._lineBreaks[lineNumber - 1];
        }
        return -1;
    }

    Rect rectForLine(int lineNumber) {
        TextParagraphFormat f = this.currentParagraphFormat();
        if (lineNumber >= this._breakCount) {
            return null;
        }
        int currentY = this._y;
        int i = 0;
        while (i < lineNumber) {
            currentY += this._lineHeights[i];
            ++i;
        }
        return TextView.newRect(f._leftMargin, currentY, this._owner.bounds.width - f._rightMargin, this._lineHeights[i]);
    }

    Range rangeForLine(int lineNumber) {
        if (lineNumber >= this._breakCount) {
            return new Range(this._startChar + this._charCount, 0);
        }
        if (lineNumber == 0) {
            return new Range(this._startChar, this._lineBreaks[lineNumber]);
        }
        return new Range(this._startChar + this._lineBreaks[lineNumber - 1], this._lineBreaks[lineNumber] - this._lineBreaks[lineNumber - 1]);
    }

    int runIndexForCharPosition(int absPosition) {
        int position = absPosition - this._startChar;
        int count = this._runVector.count();
        int i = 0;
        while (i < count) {
            TextStyleRun nextRun = (TextStyleRun)this._runVector.elementAt(i);
            if (nextRun.charCount() <= position) {
                position -= nextRun.charCount();
            } else {
                return i;
            }
            ++i;
        }
        return this._runVector.count() - 1;
    }

    TextStyleRun runForCharPosition(int absPosition) {
        int index = this.runIndexForCharPosition(absPosition);
        if (index >= 0) {
            return (TextStyleRun)this._runVector.elementAt(index);
        }
        return null;
    }

    char characterAt(int absPosition) {
        if (this._charCount < 2) {
            return '\n';
        }
        int position = absPosition - this._startChar;
        int count = this._runVector.count();
        int i = 0;
        while (i < count) {
            TextStyleRun nextRun = (TextStyleRun)this._runVector.elementAt(i);
            if (nextRun.charCount() <= position) {
                position -= nextRun.charCount();
            } else {
                char theChar = nextRun.charAt(position);
                return theChar;
            }
            ++i;
        }
        if (position < 2) {
            return '\n';
        }
        return '\u0000';
    }

    int lineForPosition(int absPosition) {
        int position = absPosition - this._startChar;
        if (this._breakCount > 0 && position == this._lineBreaks[this._breakCount - 1]) {
            return this._breakCount - 1;
        }
        int i = 0;
        while (i < this._breakCount && position >= this._lineBreaks[i]) {
            ++i;
        }
        if (i >= this._breakCount) {
            return -1;
        }
        return i;
    }

    /*
     * Unable to fully structure code
     */
    TextPositionInfo positionForPoint(int x, int y, boolean absolute) {
        nextRun = null;
        runStartChar = 0;
        format = this.currentParagraphFormat();
        currentY = this._y;
        i = 0;
        while (i < this._breakCount) {
            if (y >= currentY && y <= currentY + this._lineHeights[i]) break;
            currentY += this._lineHeights[i];
            ++i;
        }
        firstChar = (lineNumber = i) == 0 ? this._startChar : this._startChar + this._lineBreaks[lineNumber - 1];
        lastChar = this._startChar + this._lineBreaks[lineNumber];
        count = this._runVector.count();
        charCount = this._startChar;
        i = 0;
        while (i < count) {
            nextRun = (TextStyleRun)this._runVector.elementAt(i);
            if (charCount + nextRun.charCount() > firstChar) {
                runStartChar = firstChar - charCount;
                break;
            }
            charCount += nextRun.charCount();
            ++i;
        }
        if (nextRun == null) {
            return null;
        }
        runIndex = i;
        currentX = format._justification == 0 ? format._leftMargin : (format._justification == 2 ? format._leftMargin + this._lineRemainders[lineNumber] : format._leftMargin + this._lineRemainders[lineNumber] / 2);
        availableWidth = this._owner.bounds.width - format._leftMargin - format._rightMargin;
        if (lineNumber == 0) {
            currentX += format._leftIndent;
            availableWidth -= format._leftIndent;
        } else if (format.wrapsUnderFirstCharacter()) {
            oldCurrentX = currentX;
            currentX = this.addWidthOfInitialTabs(currentX + format._leftIndent);
            availableWidth -= currentX - oldCurrentX;
        }
        if (availableWidth < 1) {
            availableWidth = 1;
        }
        if (x > currentX + availableWidth - this._lineRemainders[lineNumber]) {
            endPosition = this.infoForPosition(lastChar, -1);
            endPosition.setAtEndOfLine(true);
            return endPosition;
        }
        if (x <= currentX) {
            return this.infoForPosition(firstChar, y);
        }
        ++runIndex;
        while (nextRun != null && nextRun.charCount() == 0) {
            nextRun = this.runAfter(nextRun);
            ++runIndex;
        }
        if (nextRun != null) ** GOTO lbl70
        return this.infoForPosition(firstChar + charCount, y);
lbl-1000:
        // 1 sources

        {
            deltaX = nextRun.widthOfContents(runStartChar, 1, currentX, format._tabStops);
            if (x >= currentX && x <= currentX + deltaX) {
                if (absolute) {
                    return this.infoForPosition(firstChar, y);
                }
                if (x >= currentX + (deltaX /= 2)) {
                    return this.infoForPosition(firstChar + 1, y);
                }
                return this.infoForPosition(firstChar, y);
            }
            if (++runStartChar >= nextRun.charCount()) {
                nextRun = (TextStyleRun)this.objectAt(this._runVector, runIndex++);
                while (nextRun != null && nextRun.charCount() == 0) {
                    nextRun = this.runAfter(nextRun);
                    ++runIndex;
                }
                if (nextRun == null) {
                    return this.infoForPosition(firstChar + charCount, y);
                }
                runStartChar = 0;
            }
            ++firstChar;
            currentX += deltaX;
lbl70:
            // 2 sources

            ** while (firstChar <= lastChar)
        }
lbl71:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    TextPositionInfo _infoForPosition(int absPosition) {
        i = 0;
        charCount = 0;
        runNumber = 1;
        currentX = 0;
        deltaX = 0;
        format = this.currentParagraphFormat();
        initialPosition = position = absPosition - this._startChar;
        if (position >= this._charCount) {
            position = this._charCount;
        }
        maxWidth = this._owner.bounds.width - format._leftMargin - format._rightMargin;
        currentY = this._y;
        i = 0;
        while (i < this._breakCount - 1) {
            if (this._lineBreaks[i] >= position) break;
            currentY += this._lineHeights[i];
            ++i;
        }
        if (i > 0) {
            runNumber = this.runIndexForCharPosition(this._startChar + this._lineBreaks[i - 1]);
            nextRun = (TextStyleRun)this._runVector.elementAt(runNumber++);
            runStartChar = this._lineBreaks[i - 1] + this._startChar - nextRun.rangeIndex();
            position -= this._lineBreaks[i - 1];
        } else {
            runNumber = 1;
            nextRun = (TextStyleRun)this._runVector.firstElement();
            runStartChar = 0;
        }
        while (i < this._breakCount) {
            charCount = i == 0 ? this._lineBreaks[i] : this._lineBreaks[i] - this._lineBreaks[i - 1];
            if (charCount > position) {
                charCount = position;
            }
            currentX = format._justification == 0 ? format._leftMargin : (format._justification == 2 ? format._leftMargin + this._lineRemainders[i] : format._leftMargin + this._lineRemainders[i] / 2);
            availableWidth = maxWidth;
            if (i == 0) {
                currentX += format._leftIndent;
                availableWidth -= format._leftIndent;
            } else if (format.wrapsUnderFirstCharacter()) {
                newCurrentX = this.addWidthOfInitialTabs(currentX + format._leftIndent);
                availableWidth -= newCurrentX - currentX;
                currentX = newCurrentX;
            }
            if (availableWidth < 1) {
                availableWidth = 1;
            }
            if (charCount != 0) ** GOTO lbl74
            return new TextPositionInfo(nextRun, currentX, currentY, i, this._lineHeights[i], runStartChar, absPosition);
lbl-1000:
            // 1 sources

            {
                runChars = nextRun.charCount() - runStartChar;
                if (charCount >= runChars) {
                    if (charCount <= position) {
                        deltaX = nextRun.widthOfContents(runStartChar, charCount, currentX, format._tabStops);
                    }
                    charCount -= runChars;
                    position -= runChars;
                    nextRun = (TextStyleRun)this.objectAt(this._runVector, runNumber++);
                    while (nextRun != null && nextRun.charCount() == 0) {
                        nextRun = (TextStyleRun)this.objectAt(this._runVector, runNumber++);
                    }
                    runStartChar = 0;
                } else {
                    if (charCount <= position) {
                        deltaX = nextRun.widthOfContents(runStartChar, charCount, currentX, format._tabStops);
                    }
                    runStartChar += charCount;
                    position -= charCount;
                    charCount = 0;
                }
                currentX += deltaX;
                availableWidth -= deltaX;
                if (position != 0 && (nextRun != null || position != 1)) continue;
                if (nextRun == null) {
                    nextRun = (TextStyleRun)this._runVector.lastElement();
                    runStartChar = nextRun.charCount();
                }
                result = new TextPositionInfo(nextRun, currentX, currentY, i, this._lineHeights[i], runStartChar, absPosition);
                if (initialPosition == this._lineBreaks[i]) {
                    result.setAtEndOfLine(true);
                    if (i == this._breakCount - 1) {
                        result.setAtEndOfParagraph(true);
                    }
                }
                return result;
lbl74:
                // 2 sources

                ** while (charCount > 0)
            }
lbl75:
            // 1 sources

            currentY += this._lineHeights[i];
            ++i;
        }
        return null;
    }

    TextPositionInfo infoForPosition(int absPosition, int yCoord) {
        TextParagraphFormat format = this.currentParagraphFormat();
        TextPositionInfo positionInfo = this._infoForPosition(absPosition);
        if (positionInfo == null) {
            positionInfo = this._infoForPosition(this._startChar + this._charCount);
            return positionInfo;
        }
        if (yCoord < positionInfo.maxY()) {
            return positionInfo;
        }
        TextPositionInfo nextInfo = this._infoForPosition(absPosition + 1);
        if (nextInfo == null || nextInfo._lineNumber == positionInfo._lineNumber) {
            return positionInfo;
        }
        int lineNumber = nextInfo._lineNumber;
        int currentX = format._justification == 0 ? format._leftMargin : (format._justification == 2 ? format._leftMargin + this._lineRemainders[lineNumber] : format._leftMargin + this._lineRemainders[lineNumber] / 2);
        positionInfo = new TextPositionInfo(positionInfo._textRun, currentX, nextInfo._y, nextInfo._lineNumber, nextInfo._lineHeight, positionInfo._positionInRun, positionInfo._absPosition);
        positionInfo.setNextLine(true);
        return positionInfo;
    }

    TextPositionInfo insertCharOrStringAt(char aChar, String aString, int absPosition) {
        int charCount;
        TextStyleRun nextRun = null;
        if (aString == null && aChar == '\u0000') {
            return null;
        }
        int position = absPosition - this._startChar;
        int count = this._runVector.count();
        int i = 0;
        while (i < count) {
            nextRun = (TextStyleRun)this.objectAt(this._runVector, i);
            if (nextRun == null) break;
            if (nextRun.charCount() < position) {
                position -= nextRun.charCount();
            } else {
                if (!nextRun.containsATextAttachment()) break;
                if (position == 0) {
                    TextStyleRun newRun = nextRun.createEmptyRun();
                    this.insertRunAt(newRun, this._runVector.indexOfIdentical(nextRun));
                    nextRun = newRun;
                } else {
                    TextStyleRun previousRun = null;
                    if (i > 0) {
                        previousRun = (TextStyleRun)this.objectAt(this._runVector, i - 1);
                        TextStyleRun newRun = previousRun.createEmptyRun(TextView.attributesByRemovingStaticAttributes(previousRun.attributes()));
                        this.insertRunAt(newRun, this._runVector.indexOfIdentical(nextRun) + 1);
                        nextRun = newRun;
                    } else {
                        nextRun = (TextStyleRun)this.objectAt(this._runVector, 0);
                        TextStyleRun newRun = nextRun.createEmptyRun(TextView.attributesByRemovingStaticAttributes(nextRun.attributes()));
                        this.insertRunAt(newRun, 1);
                        nextRun = newRun;
                    }
                    if (nextRun == null) {
                        nextRun = new TextStyleRun(this, "", null);
                        this.addRun(nextRun);
                    }
                }
                position = 0;
                break;
            }
            ++i;
        }
        if ((i >= count || nextRun == null) && position == 1) {
            nextRun = (TextStyleRun)this._runVector.lastElement();
            position = nextRun.charCount();
        } else if (nextRun == null) {
            return null;
        }
        int currentLine = this.lineForPosition(absPosition - 1);
        int lastCharNumber = this._lineBreaks[currentLine] + this._startChar;
        TextPositionInfo lastCharPosition = this.infoForPosition(lastCharNumber, -1);
        int oldHeight = this._height;
        if (aString != null) {
            nextRun.insertStringAt(aString, position);
            charCount = aString.length();
        } else {
            nextRun.insertCharAt(aChar, position);
            charCount = 1;
        }
        this.computeLineBreaksAndHeights(this._owner.bounds.width, currentLine);
        TextPositionInfo newPosition = this.infoForPosition(absPosition + charCount, -1);
        if (oldHeight != this._height) {
            newPosition.setRedrawCurrentParagraphOnly(false);
            newPosition.setRedrawCurrentLineOnly(false);
            return newPosition;
        }
        newPosition.setRedrawCurrentParagraphOnly(true);
        if (newPosition._lineNumber != lastCharPosition._lineNumber) {
            newPosition.setRedrawCurrentParagraphOnly(false);
            if (lastCharPosition._lineNumber < newPosition._lineNumber) {
                newPosition.setUpdateLine(lastCharPosition._lineNumber);
            } else {
                newPosition.setUpdateLine(newPosition._lineNumber);
            }
            return newPosition;
        }
        newPosition.setRedrawCurrentParagraphOnly(true);
        TextPositionInfo newLastCharPosition = this.infoForPosition(lastCharNumber + 1, -1);
        if (newLastCharPosition != null && lastCharPosition != null && newLastCharPosition._lineNumber == lastCharPosition._lineNumber) {
            if (this.currentParagraphFormat().wrapsUnderFirstCharacter()) {
                newPosition.setRedrawCurrentLineOnly(false);
            } else {
                newPosition.setRedrawCurrentLineOnly(true);
            }
        } else {
            newPosition.setRedrawCurrentLineOnly(false);
        }
        return newPosition;
    }

    TextPositionInfo removeCharAt(int absPosition) {
        TextStyleRun nextRun = null;
        if (absPosition <= this._startChar) {
            return null;
        }
        int position = --absPosition - this._startChar;
        int count = this._runVector.count();
        int i = 0;
        while (i < count) {
            nextRun = (TextStyleRun)this._runVector.elementAt(i);
            if (nextRun.charCount() > position) break;
            position -= nextRun.charCount();
            ++i;
        }
        if ((i >= count || nextRun == null) && position == 0) {
            nextRun = (TextStyleRun)this._runVector.lastElement();
            position = nextRun.charCount() - 1;
        } else if (nextRun == null) {
            return null;
        }
        int currentLine = this.lineForPosition(absPosition - 1);
        int firstCharNumber = currentLine == 0 ? this._startChar + 1 : this._lineBreaks[currentLine - 1] + this._startChar + 1;
        int firstNextLineCharNumber = this._lineBreaks[currentLine] + this._startChar + 1;
        if (firstNextLineCharNumber > this._startChar + this._charCount) {
            firstNextLineCharNumber = this._startChar + this._charCount;
        }
        TextPositionInfo firstNextLineCharPosition = this.infoForPosition(firstNextLineCharNumber, -1);
        TextPositionInfo firstCharPosition = this.infoForPosition(firstCharNumber, -1);
        int oldHeight = this._height;
        nextRun.removeCharAt(position);
        if (nextRun.charCount() == 0 && this._runVector.count() > 1) {
            this._runVector.removeElement(nextRun);
        }
        this.computeLineBreaksAndHeights(this._owner.bounds.width);
        TextPositionInfo newPosition = this.infoForPosition(absPosition, -1);
        if (oldHeight == this._height) {
            newPosition.setRedrawCurrentParagraphOnly(true);
        }
        if (newPosition._lineNumber != firstCharPosition._lineNumber) {
            if (firstCharPosition._lineNumber < newPosition._lineNumber) {
                newPosition.setUpdateLine(firstCharPosition._lineNumber);
            } else {
                newPosition.setUpdateLine(newPosition._lineNumber);
            }
            return newPosition;
        }
        TextPositionInfo newNextLineFirstCharPosition = this.infoForPosition(firstNextLineCharNumber - 1, -1);
        if (firstNextLineCharPosition._lineNumber != newNextLineFirstCharPosition._lineNumber) {
            if (firstNextLineCharPosition._lineNumber < newNextLineFirstCharPosition._lineNumber) {
                newPosition.setUpdateLine(firstNextLineCharPosition._lineNumber);
            } else {
                newPosition.setUpdateLine(newNextLineFirstCharPosition._lineNumber);
            }
            return newPosition;
        }
        TextPositionInfo newFirstCharPosition = this.infoForPosition(firstCharNumber, -1);
        if (oldHeight == this._height && newFirstCharPosition != null && firstCharPosition != null && newFirstCharPosition._lineNumber == firstCharPosition._lineNumber) {
            if (this.currentParagraphFormat().wrapsUnderFirstCharacter()) {
                newPosition.setRedrawCurrentLineOnly(false);
            } else {
                newPosition.setRedrawCurrentLineOnly(true);
            }
        }
        return newPosition;
    }

    TextStyleRun createNewRunAt(int absPosition) {
        TextPositionInfo breakPosition = this.infoForPosition(absPosition, -1);
        if (breakPosition == null) {
            return null;
        }
        int position = this._runVector.indexOfIdentical(breakPosition._textRun);
        TextStyleRun newRun = breakPosition._textRun.breakAt(breakPosition._positionInRun);
        this.insertRunAt(newRun, position + 1);
        return newRun;
    }

    TextParagraph createNewParagraphAt(int absPosition) {
        int i;
        TextStyleRun newRun = null;
        TextParagraphFormat format = this.currentParagraphFormat();
        this.collectEmptyRuns();
        TextStyleRun run = this.runForCharPosition(absPosition);
        int positionInRun = absPosition - run.rangeIndex();
        TextParagraph newParagraph = new TextParagraph(this._owner, format);
        if (positionInRun == 0) {
            i = this._runVector.indexOfIdentical(run);
            Hashtable attr = TextView.attributesByRemovingStaticAttributes(run.attributes());
            if (i == 0) {
                newRun = run.createEmptyRun(attr);
                this._runVector.insertElementAt(newRun, 0);
            } else {
                --i;
            }
            newParagraph.addRun(new TextStyleRun(this, "", attr));
        } else if (run.containsATextAttachment()) {
            i = this._runVector.indexOfIdentical(run);
            int k = i - 1;
            TextStyleRun previousRun = null;
            while (k > 0) {
                previousRun = (TextStyleRun)this.objectAt(this._runVector, k);
                if (previousRun == null || !previousRun.containsATextAttachment()) break;
                --k;
            }
            if (previousRun == null) {
                newRun = new TextStyleRun(this, "", null);
                newParagraph.addRun(newRun);
            } else {
                newRun = new TextStyleRun(this, "", TextView.attributesByRemovingStaticAttributes(previousRun.attributes()));
                newParagraph.addRun(newRun);
            }
        } else {
            TextStyleRun firstRun;
            newRun = firstRun = run.breakAt(positionInRun);
            newParagraph.addRun(firstRun);
            i = this._runVector.indexOfIdentical(run);
        }
        if (i < 0) {
            return newParagraph;
        }
        ++i;
        int count = this._runVector.count();
        int runCount = 0;
        while (i < count) {
            newParagraph.addRun((TextStyleRun)this._runVector.elementAt(i));
            ++i;
            ++runCount;
        }
        while (runCount-- > 0) {
            this._runVector.removeLastElement();
        }
        return newParagraph;
    }

    void drawBackgroundForLine(Graphics g, int lineNumber, int currentX, int currentY) {
        Rect nonSelectionRect;
        Rect nonSelectionRect2;
        Rect selectionRect = null;
        TextParagraphFormat format = this.currentParagraphFormat();
        TextParagraphFormat defaultFormat = (TextParagraphFormat)this._owner.defaultAttributes().get("ParagraphFormatKey");
        int maxWidth = this._owner.bounds.width - format._leftMargin - format._rightMargin;
        int defaultMaxWidth = this._owner.bounds.width - defaultFormat._leftMargin - defaultFormat._rightMargin;
        if (lineNumber == 0) {
            maxWidth -= format._leftIndent;
        }
        if (lineNumber < 0 || lineNumber >= this._breakCount || !this._owner.hasSelectionRange() && !this._owner.insertionPointVisible) {
            if (!this._owner.isTransparent()) {
                g.setColor(this._owner._backgroundColor);
                g.fillRect(defaultFormat._leftMargin, currentY, defaultMaxWidth, this._lineHeights[lineNumber]);
            }
            return;
        }
        int selectionStart = this._owner.selectionStart();
        int selectionEnd = this._owner.selectionEnd();
        TextPositionInfo startInfo = this._owner.selectionStartInfo();
        TextPositionInfo endInfo = this._owner.selectionEndInfo();
        int lineStartCharNumber = lineNumber == 0 ? this._startChar : this._startChar + this._lineBreaks[lineNumber - 1];
        int lineEndCharNumber = this._startChar + this._lineBreaks[lineNumber];
        if (lineNumber == this._breakCount - 1) {
            ++lineEndCharNumber;
        }
        if (selectionStart == selectionEnd || selectionStart > lineEndCharNumber || selectionEnd < lineStartCharNumber) {
            if (!this._owner.isTransparent()) {
                g.setColor(this._owner._backgroundColor);
                g.fillRect(defaultFormat._leftMargin, currentY, defaultMaxWidth, this._lineHeights[lineNumber]);
            }
            return;
        }
        if (lineStartCharNumber >= selectionStart && lineEndCharNumber <= selectionEnd) {
            selectionRect = TextView.newRect(defaultFormat._leftMargin, currentY, defaultMaxWidth, this._lineHeights[lineNumber]);
            nonSelectionRect2 = null;
            nonSelectionRect = null;
        } else if (lineStartCharNumber >= selectionStart && lineEndCharNumber > selectionEnd && lineStartCharNumber < selectionEnd) {
            selectionRect = selectionStart == lineStartCharNumber ? TextView.newRect(currentX, currentY, endInfo._x - currentX, this._lineHeights[lineNumber]) : TextView.newRect(defaultFormat._leftMargin, currentY, endInfo._x - defaultFormat._leftMargin, this._lineHeights[lineNumber]);
            nonSelectionRect = TextView.newRect(selectionRect.maxX(), currentY, defaultMaxWidth - selectionRect.width, this._lineHeights[lineNumber]);
            nonSelectionRect2 = null;
        } else if (lineStartCharNumber < selectionStart && selectionStart < lineEndCharNumber && lineEndCharNumber <= selectionEnd) {
            if (startInfo._textRun._paragraph != this || startInfo._lineNumber > lineNumber) {
                nonSelectionRect = TextView.newRect(defaultFormat._leftMargin, currentY, defaultMaxWidth, this._lineHeights[lineNumber]);
            } else {
                selectionRect = TextView.newRect(startInfo._x, currentY, this._owner.bounds.width - defaultFormat._rightMargin - startInfo._x, this._lineHeights[lineNumber]);
                nonSelectionRect = TextView.newRect(defaultFormat._leftMargin, currentY, selectionRect.x - defaultFormat._leftMargin, this._lineHeights[lineNumber]);
            }
            nonSelectionRect2 = null;
        } else if (lineStartCharNumber < selectionStart && lineEndCharNumber > selectionEnd) {
            selectionRect = TextView.newRect(startInfo._x, currentY, endInfo._x - startInfo._x, this._lineHeights[lineNumber]);
            nonSelectionRect = TextView.newRect(selectionRect.maxX(), currentY, defaultMaxWidth - selectionRect.width, this._lineHeights[lineNumber]);
            nonSelectionRect2 = TextView.newRect(defaultFormat._leftMargin, currentY, selectionRect.x - defaultFormat._leftMargin, this._lineHeights[lineNumber]);
        } else {
            nonSelectionRect = TextView.newRect(defaultFormat._leftMargin, currentY, defaultMaxWidth, this._lineHeights[lineNumber]);
            nonSelectionRect2 = null;
        }
        if (!this._owner.isTransparent()) {
            g.setColor(this._owner._backgroundColor);
            if (nonSelectionRect != null) {
                g.fillRect(nonSelectionRect);
                TextView.returnRect(nonSelectionRect);
            }
            if (nonSelectionRect2 != null) {
                g.fillRect(nonSelectionRect2);
                TextView.returnRect(nonSelectionRect2);
            }
        }
        if (this._owner.hasSelectionRange() && selectionRect != null && this._owner.isSelectable()) {
            if (selectionRect.width == 0 && selectionRect.x == currentX) {
                selectionRect.sizeTo(4, selectionRect.height);
            }
            if (!this._owner.isEditing()) {
                if (!this._owner.isTransparent()) {
                    g.setColor(this._owner._backgroundColor);
                    g.fillRect(selectionRect);
                }
            } else {
                g.setColor(this._owner._selectionColor);
                g.fillRect(selectionRect);
            }
            TextView.returnRect(selectionRect);
        }
    }

    void drawLine(Graphics g, int lineNumber) {
        int charCount = 0;
        int runNumber = 1;
        int deltaX = 0;
        TextParagraphFormat format = this.currentParagraphFormat();
        if (lineNumber >= this._breakCount) {
            return;
        }
        int maxWidth = this._owner.bounds.width - format._leftMargin - format._rightMargin;
        int currentY = this._y;
        if (!this._owner.isTransparent()) {
            g.setColor(this._owner._backgroundColor);
            g.fillRect(0, currentY, format._leftMargin, this._height);
            g.fillRect(this._owner.bounds.width - format._rightMargin, currentY, format._rightMargin + 1, this._height);
        }
        TextStyleRun nextRun = (TextStyleRun)this._runVector.firstElement();
        int runStartChar = 0;
        int i = 0;
        while (i <= lineNumber) {
            int currentX = format._justification == 0 ? format._leftMargin : (format._justification == 2 ? format._leftMargin + this._lineRemainders[i] : format._leftMargin + this._lineRemainders[i] / 2);
            int availableWidth = maxWidth;
            if (i == 0) {
                currentX += format._leftIndent;
                availableWidth -= format._leftIndent;
            } else if (format.wrapsUnderFirstCharacter()) {
                int newCurrentX = this.addWidthOfInitialTabs(currentX + format._leftIndent);
                availableWidth -= newCurrentX - currentX;
                currentX = newCurrentX;
            }
            charCount = i == 0 ? this._lineBreaks[i] : this._lineBreaks[i] - this._lineBreaks[i - 1];
            if (i == lineNumber) {
                this.drawBackgroundForLine(g, i, currentX, currentY);
            }
            while (charCount > 0) {
                int runChars = nextRun.charCount() - runStartChar;
                if (charCount >= runChars) {
                    if (i == lineNumber) {
                        deltaX = nextRun.drawCharacters(g, runStartChar, runChars, currentX, currentY + this._baselines[i], format._tabStops);
                    }
                    charCount -= runChars;
                    nextRun = (TextStyleRun)this.objectAt(this._runVector, runNumber++);
                    while (nextRun != null && nextRun.charCount() == 0) {
                        nextRun = (TextStyleRun)this.objectAt(this._runVector, runNumber++);
                    }
                    runStartChar = 0;
                } else {
                    if (i == lineNumber) {
                        deltaX = nextRun.drawCharacters(g, runStartChar, charCount, currentX, currentY + this._baselines[i], format._tabStops);
                    }
                    runStartChar += charCount;
                    charCount = 0;
                }
                currentX += deltaX;
                availableWidth -= deltaX;
            }
            currentY += this._lineHeights[i];
            ++i;
        }
    }

    void drawView(Graphics g, Rect textBounds) {
        int charCount = 0;
        int runNumber = 1;
        TextParagraphFormat format = this.currentParagraphFormat();
        TextParagraphFormat defaultFormat = (TextParagraphFormat)this._owner.defaultAttributes().get("ParagraphFormatKey");
        int maxWidth = this._owner.bounds.width - format._leftMargin - format._rightMargin;
        int currentY = this._y;
        if (!this._owner.isTransparent()) {
            g.setColor(this._owner._backgroundColor);
            g.fillRect(textBounds.maxX() - defaultFormat._rightMargin, currentY, defaultFormat._rightMargin + 1, this._height);
        }
        TextStyleRun nextRun = (TextStyleRun)this._runVector.firstElement();
        int runStartChar = 0;
        Rect lineRect = TextView.newRect();
        Rect clipRect = g.clipRect();
        int i = 0;
        while (i < this._breakCount) {
            int currentX = format._justification == 0 ? textBounds.x + format._leftMargin : (format._justification == 2 ? textBounds.x + format._leftMargin + this._lineRemainders[i] : textBounds.x + format._leftMargin + this._lineRemainders[i] / 2);
            int availableWidth = maxWidth;
            if (i == 0) {
                currentX += format._leftIndent;
                availableWidth -= format._leftIndent;
            } else if (format.wrapsUnderFirstCharacter()) {
                int newCurrentX = this.addWidthOfInitialTabs(currentX + format._leftIndent);
                availableWidth -= newCurrentX - currentX;
                currentX = newCurrentX;
            }
            charCount = i == 0 ? this._lineBreaks[i] : this._lineBreaks[i] - this._lineBreaks[i - 1];
            lineRect.setBounds(0, currentY, this._owner.bounds.width, this._lineHeights[i]);
            boolean canDraw = clipRect.intersects(lineRect);
            if (!this._owner.isTransparent()) {
                g.setColor(this._owner.backgroundColor());
                g.fillRect(textBounds.x, currentY, currentX - textBounds.x, this._lineHeights[i]);
            }
            if (canDraw) {
                this.drawBackgroundForLine(g, i, currentX, currentY);
            }
            while (charCount > 0) {
                int deltaX;
                int runChars = nextRun.charCount() - runStartChar;
                if (charCount >= runChars) {
                    deltaX = canDraw ? nextRun.drawCharacters(g, runStartChar, runChars, currentX, currentY + this._baselines[i], format._tabStops) : 0;
                    charCount -= runChars;
                    nextRun = (TextStyleRun)this.objectAt(this._runVector, runNumber++);
                    while (nextRun != null && nextRun.charCount() == 0) {
                        nextRun = (TextStyleRun)this.objectAt(this._runVector, runNumber++);
                    }
                    runStartChar = 0;
                } else {
                    deltaX = canDraw ? nextRun.drawCharacters(g, runStartChar, charCount, currentX, currentY + this._baselines[i], format._tabStops) : 0;
                    runStartChar += charCount;
                    charCount = 0;
                }
                currentX += deltaX;
                availableWidth -= deltaX;
            }
            currentY += this._lineHeights[i];
            ++i;
        }
        TextView.returnRect(lineRect);
    }

    void draw() {
        if (this._owner != null) {
            Rect tmpRect = TextView.newRect(0, this._y, this._owner.bounds.width, this._height);
            this._owner.draw(tmpRect);
            TextView.returnRect(tmpRect);
        }
    }

    void subsumeParagraph(TextParagraph aParagraph) {
        if (aParagraph == null) {
            return;
        }
        int count = aParagraph._runVector.count();
        int i = 0;
        while (i < count) {
            TextStyleRun nextRun = (TextStyleRun)aParagraph._runVector.elementAt(i);
            if (nextRun.charCount() > 0 || this._runVector.isEmpty() && i + 1 == count) {
                this.addRun(nextRun);
            }
            ++i;
        }
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("[");
        int count = this._runVector.count();
        int i = 0;
        while (i < count) {
            TextStyleRun nextRun = (TextStyleRun)this._runVector.elementAt(i);
            buffer.append(nextRun.toString());
            ++i;
        }
        buffer.append("]\n");
        return buffer.toString();
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.application.TextParagraph", 1);
        info.addField(FORMAT_KEY, (byte)18);
        info.addField(RUNVECTOR_KEY, (byte)18);
    }

    public void encode(Encoder encoder) throws CodingException {
        encoder.encodeObject(FORMAT_KEY, this._format);
        encoder.encodeObject(RUNVECTOR_KEY, this._runVector);
    }

    public void decode(Decoder decoder) throws CodingException {
        this._format = (TextParagraphFormat)decoder.decodeObject(FORMAT_KEY);
        this._runVector = (Vector)decoder.decodeObject(RUNVECTOR_KEY);
        int i = this._runVector.count();
        while (i-- > 0) {
            TextStyleRun nextRun = (TextStyleRun)this._runVector.elementAt(i);
            nextRun.setParagraph(this);
        }
    }

    public void finishDecoding() throws CodingException {
    }

    String stringForRange(Range absoluteRange) {
        StringBuffer sb = new StringBuffer();
        int runIndex = this._startChar;
        Range intersection = TextView.allocateRange();
        int i = 0;
        int c = this._runVector.count();
        while (i < c) {
            TextStyleRun run = (TextStyleRun)this._runVector.elementAt(i);
            intersection.index = runIndex;
            intersection.length = run.charCount();
            intersection.intersectWith(absoluteRange);
            if (intersection.index != Range.nullRange().index) {
                String s = run.text().substring(intersection.index - runIndex, intersection.index - runIndex + intersection.length);
                sb.append(s);
            }
            runIndex += run.charCount();
            ++i;
        }
        if (absoluteRange.index + absoluteRange.length - 1 == this._startChar + this._charCount - 1) {
            sb.append("\n");
        }
        TextView.recycleRange(intersection);
        return sb.toString();
    }

    Range range() {
        return TextView.allocateRange(this._startChar, this._charCount);
    }

    int lineCount() {
        return this._breakCount;
    }
}

