/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.Archiver;
import netscape.util.ClassTable;
import netscape.util.Unarchiver;

final class ArchivingStack {
    int depth;
    int maxDepth;
    Object[] objArray;
    int[] intArray;

    ArchivingStack() {
    }

    private void growArrays() {
        this.maxDepth = this.maxDepth == 0 ? 8 : 2 * this.maxDepth;
        Object[] newObjArray = new Object[2 * this.maxDepth];
        int[] newIntArray = new int[4 * this.maxDepth];
        if (this.objArray != null && this.intArray != null) {
            System.arraycopy(this.objArray, 0, newObjArray, 0, this.objArray.length);
            System.arraycopy(this.intArray, 0, newIntArray, 0, this.intArray.length);
        }
        this.objArray = newObjArray;
        this.intArray = newIntArray;
    }

    void pushArchiver(Archiver archiver) {
        ++this.depth;
        int i = this.depth;
        if (this.depth >= this.maxDepth) {
            this.growArrays();
        }
        this.objArray[2 * i] = archiver.currentObject;
        this.objArray[2 * i + 1] = archiver.currentTable;
        this.intArray[4 * i] = archiver.currentId;
        this.intArray[4 * i + 1] = archiver.currentColumnCount;
        this.intArray[4 * i + 2] = archiver.currentRow;
        this.intArray[4 * i + 3] = archiver.currentColumn;
    }

    void pushUnarchiver(Unarchiver unarchiver) {
        ++this.depth;
        int i = this.depth;
        if (this.depth >= this.maxDepth) {
            this.growArrays();
        }
        this.objArray[2 * i] = unarchiver.currentObject;
        this.objArray[2 * i + 1] = unarchiver.currentTable;
        this.intArray[4 * i] = unarchiver.currentId;
        this.intArray[4 * i + 1] = unarchiver.currentColumnCount;
        this.intArray[4 * i + 2] = unarchiver.currentRow;
        this.intArray[4 * i + 3] = unarchiver.currentColumn;
    }

    void popArchiver(Archiver archiver) {
        int i = this.depth--;
        archiver.currentObject = this.objArray[2 * i];
        this.objArray[2 * i] = null;
        archiver.currentTable = (ClassTable)this.objArray[2 * i + 1];
        this.objArray[2 * i + 1] = null;
        archiver.currentId = this.intArray[4 * i];
        archiver.currentColumnCount = this.intArray[4 * i + 1];
        archiver.currentRow = this.intArray[4 * i + 2];
        archiver.currentColumn = this.intArray[4 * i + 3];
    }

    void popUnarchiver(Unarchiver unarchiver) {
        int i = this.depth--;
        unarchiver.currentObject = this.objArray[2 * i];
        this.objArray[2 * i] = null;
        unarchiver.currentTable = (ClassTable)this.objArray[2 * i + 1];
        this.objArray[2 * i + 1] = null;
        unarchiver.currentId = this.intArray[4 * i];
        unarchiver.currentColumnCount = this.intArray[4 * i + 1];
        unarchiver.currentRow = this.intArray[4 * i + 2];
        unarchiver.currentColumn = this.intArray[4 * i + 3];
    }
}

