/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;
import netscape.util.Enumeration;
import netscape.util.FormattingSerializer;
import netscape.util.Sort;
import netscape.util.VectorEnumerator;

public class Vector
implements Cloneable,
Codable {
    Object[] array;
    int count;
    static final String ARRAY_KEY = "array";

    public Vector() {
        this.count = 0;
    }

    public Vector(int initialCapacity) {
        this.array = new Object[initialCapacity];
        this.count = 0;
    }

    public Object clone() {
        Vector newVect;
        try {
            newVect = (Vector)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Error in clone(). This shouldn't happen.");
        }
        if (this.count == 0) {
            newVect.array = null;
            return newVect;
        }
        newVect.array = new Object[this.count];
        System.arraycopy(this.array, 0, newVect.array, 0, this.count);
        return newVect;
    }

    public int count() {
        return this.count;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public void addElementIfAbsent(Object element) {
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (element != null && !this.contains(element)) {
            this.addElement(element);
        }
    }

    public boolean insertElementBefore(Object element, Object existingElement) {
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (existingElement == null) {
            return false;
        }
        int index = this.indexOf(existingElement);
        if (index == -1) {
            return false;
        }
        this.insertElementAt(element, index);
        return true;
    }

    public boolean insertElementAfter(Object element, Object existingElement) {
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (existingElement == null) {
            return false;
        }
        int index = this.indexOf(existingElement);
        if (index == -1) {
            return false;
        }
        if (index >= this.count - 1) {
            this.addElement(element);
        } else {
            this.insertElementAt(element, index + 1);
        }
        return true;
    }

    public void addElementsIfAbsent(Vector aVector) {
        if (aVector == null) {
            return;
        }
        int addCount = aVector.count();
        int i = 0;
        while (i < addCount) {
            Object nextObject = aVector.elementAt(i);
            if (!this.contains(nextObject)) {
                this.addElement(nextObject);
            }
            ++i;
        }
    }

    public void addElements(Vector aVector) {
        if (aVector == null) {
            return;
        }
        int addCount = aVector.count();
        if (this.array == null || this.count + addCount >= this.array.length) {
            this.ensureCapacity(this.count + addCount);
        }
        int i = 0;
        while (i < addCount) {
            this.addElement(aVector.elementAt(i));
            ++i;
        }
    }

    public void removeAll(Object element) {
        int i = this.count();
        while (i-- > 0) {
            if (!this.elementAt(i).equals(element)) continue;
            this.removeElementAt(i);
        }
    }

    public Object removeFirstElement() {
        if (this.count == 0) {
            return null;
        }
        return this.removeElementAt(0);
    }

    public Object removeLastElement() {
        if (this.count == 0) {
            return null;
        }
        return this.removeElementAt(this.count - 1);
    }

    public Object replaceElementAt(int index, Object element) {
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.count);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " < 0");
        }
        Object oldObject = this.elementAt(index);
        this.array[index] = element;
        return oldObject;
    }

    public Object[] elementArray() {
        Object[] newArray = new Object[this.count];
        if (this.count > 0) {
            System.arraycopy(this.array, 0, newArray, 0, this.count);
        }
        return newArray;
    }

    public void copyInto(Object[] anArray) {
        if (this.count > 0) {
            System.arraycopy(this.array, 0, anArray, 0, this.count);
        }
    }

    public void trimToSize() {
        if (this.count == 0) {
            this.array = null;
            return;
        }
        if (this.count != this.array.length) {
            this.array = this.elementArray();
        }
    }

    public void ensureCapacity(int minCapacity) {
        if (this.array == null) {
            this.array = new Object[8];
        }
        if (minCapacity < this.array.length) {
            return;
        }
        int newLength = this.array.length < 8 ? 8 : this.array.length;
        while (newLength < minCapacity) {
            newLength = 2 * newLength;
        }
        Object[] newArray = new Object[newLength];
        System.arraycopy(this.array, 0, newArray, 0, this.count);
        this.array = newArray;
    }

    public int capacity() {
        if (this.array == null) {
            return 0;
        }
        return this.array.length;
    }

    public Enumeration elements() {
        return new VectorEnumerator(this);
    }

    public Enumeration elements(int index) {
        return new VectorEnumerator(this, index);
    }

    public boolean contains(Object element) {
        return this.indexOf(element, 0) != -1;
    }

    public boolean containsIdentical(Object element) {
        return this.indexOfIdentical(element, 0) != -1;
    }

    public int indexOf(Object element) {
        return this.indexOf(element, 0);
    }

    public int indexOf(Object element, int index) {
        int i = index;
        while (i < this.count) {
            if (this.array[i].equals(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfIdentical(Object element, int index) {
        int i = index;
        while (i < this.count) {
            if (this.array[i] == element) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfIdentical(Object element) {
        return this.indexOfIdentical(element, 0);
    }

    public int lastIndexOf(Object element) {
        return this.lastIndexOf(element, this.count);
    }

    public int lastIndexOf(Object element, int index) {
        if (index > this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " > " + this.count);
        }
        int i = index - 1;
        while (i >= 0) {
            if (this.array[i].equals(element)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public Object elementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.count);
        }
        return this.array[index];
    }

    public Object firstElement() {
        if (this.count == 0) {
            return null;
        }
        return this.array[0];
    }

    public Object lastElement() {
        if (this.count == 0) {
            return null;
        }
        return this.array[this.count - 1];
    }

    public void setElementAt(Object element, int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.count);
        }
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        this.array[index] = element;
    }

    public Object removeElementAt(int index) {
        if (index >= this.count) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.count);
        }
        Object object = this.array[index];
        int copyCount = this.count - index - 1;
        if (copyCount > 0) {
            System.arraycopy(this.array, index + 1, this.array, index, copyCount);
        }
        --this.count;
        this.array[this.count] = null;
        return object;
    }

    public void insertElementAt(Object element, int index) {
        if (index >= this.count + 1) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(index) + " >= " + this.count);
        }
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (this.array == null || this.count >= this.array.length) {
            this.ensureCapacity(this.count + 1);
        }
        System.arraycopy(this.array, index, this.array, index + 1, this.count - index);
        this.array[index] = element;
        ++this.count;
    }

    public void addElement(Object element) {
        if (element == null) {
            throw new NullPointerException("It is illegal to store nulls in Vectors.");
        }
        if (this.array == null || this.count >= this.array.length) {
            this.ensureCapacity(this.count + 1);
        }
        this.array[this.count] = element;
        ++this.count;
    }

    public boolean removeElement(Object element) {
        int i = this.indexOf(element);
        if (i < 0) {
            return false;
        }
        this.removeElementAt(i);
        return true;
    }

    public boolean removeElementIdentical(Object element) {
        int i = this.indexOfIdentical(element, 0);
        if (i < 0) {
            return false;
        }
        this.removeElementAt(i);
        return true;
    }

    public void removeAllElements() {
        int i = 0;
        while (i < this.count) {
            this.array[i] = null;
            ++i;
        }
        this.count = 0;
    }

    public void sort(boolean ascending) {
        Sort.sort(this.array, null, 0, this.count, ascending);
    }

    public void sortStrings(boolean ascending, boolean ignoreCase) {
        Sort.sortStrings(this.array, 0, this.count, ascending, ignoreCase);
    }

    public String toString() {
        return FormattingSerializer.serializeObject(this);
    }

    public void describeClassInfo(ClassInfo info) {
        info.addClass("netscape.util.Vector", 1);
        info.addField(ARRAY_KEY, (byte)19);
    }

    public void encode(Encoder encoder) throws CodingException {
        if (this.count == 0) {
            return;
        }
        encoder.encodeObjectArray(ARRAY_KEY, this.array, 0, this.count);
    }

    public void decode(Decoder decoder) throws CodingException {
        this.array = decoder.decodeObjectArray(ARRAY_KEY);
        if (this.array == null) {
            this.count = 0;
            return;
        }
        this.count = this.array.length;
    }

    public void finishDecoding() throws CodingException {
    }
}

