/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import netscape.ldap.LDAPControl;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BERInteger;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPVirtualListResponse
extends LDAPControl {
    public static final String VIRTUALLISTRESPONSE = "2.16.840.1.113730.3.4.10";
    private int m_firstPosition;
    private int m_contentCount;
    private int m_resultCode = -1;

    LDAPVirtualListResponse() {
        super(VIRTUALLISTRESPONSE, true, null);
    }

    public LDAPVirtualListResponse(byte[] value) {
        super(VIRTUALLISTRESPONSE, true, null);
        this.m_value = value;
        this.parseResponse();
    }

    public int getContentCount() {
        return this.m_contentCount;
    }

    public int getFirstPosition() {
        return this.m_firstPosition;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    private void parseResponse() {
        ByteArrayInputStream inStream = new ByteArrayInputStream(this.getValue());
        new BERSequence();
        JDAPBERTagDecoder decoder = new JDAPBERTagDecoder();
        int[] nRead = new int[]{0};
        try {
            BERSequence seq = (BERSequence)BERElement.getElement(decoder, inStream, nRead);
            this.m_firstPosition = ((BERInteger)seq.elementAt(0)).getValue();
            this.m_contentCount = ((BERInteger)seq.elementAt(1)).getValue();
            BEREnumerated bEREnumerated = (BEREnumerated)seq.elementAt(2);
            this.m_resultCode = bEREnumerated.getValue();
            return;
        }
        catch (Throwable throwable) {
            this.m_resultCode = -1;
            this.m_contentCount = -1;
            this.m_firstPosition = -1;
            return;
        }
    }

    public static LDAPVirtualListResponse parseResponse(LDAPControl[] controls) {
        LDAPVirtualListResponse con = null;
        int i = 0;
        while (controls != null && i < controls.length) {
            if (controls[i].getID().equals(VIRTUALLISTRESPONSE)) {
                con = new LDAPVirtualListResponse(controls[i].getValue());
                con.parseResponse();
                break;
            }
            ++i;
        }
        if (con != null) {
            super.parseResponse();
        }
        return con;
    }
}

