/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPModification;
import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.LDIFAddContent;
import netscape.ldap.util.LDIFAttributeContent;
import netscape.ldap.util.LDIFContent;
import netscape.ldap.util.LDIFDeleteContent;
import netscape.ldap.util.LDIFModDNContent;
import netscape.ldap.util.LDIFModifyContent;
import netscape.ldap.util.LDIFRecord;
import netscape.ldap.util.MimeBase64Decoder;

public class LDIF {
    private static final char COMMENT = '#';
    private int m_version = 1;
    private boolean m_done = false;
    private LineReader m_reader;
    private String m_source;
    private MimeBase64Decoder m_decoder;

    public LDIF() throws IOException {
        DataInputStream ds = new DataInputStream(System.in);
        BufferedReader d = new BufferedReader(new InputStreamReader(ds));
        this.m_reader = new LineReader(d);
        this.m_source = "System.in";
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIF(String file) throws IOException {
        FileInputStream fs = new FileInputStream(file);
        DataInputStream ds = new DataInputStream(fs);
        BufferedReader d = new BufferedReader(new InputStreamReader(ds));
        this.m_reader = new LineReader(d);
        this.m_source = file;
        this.m_decoder = new MimeBase64Decoder();
    }

    public LDIF(DataInputStream ds) throws IOException {
        BufferedReader d = new BufferedReader(new InputStreamReader(ds));
        this.m_reader = new LineReader(d);
        this.m_source = ds.toString();
    }

    public LDIFRecord nextRecord() throws IOException {
        if (this.m_done) {
            return null;
        }
        return this.parse_ldif_record(this.m_reader);
    }

    private LDIFRecord parse_ldif_record(LineReader d) throws IOException {
        String line = null;
        String dn = null;
        new Vector();
        LDIFRecord rec = null;
        line = d.readLine();
        if (line == null) {
            return null;
        }
        if (!line.startsWith("dn:")) {
            throw new IOException("no dn found in <" + line + ">");
        }
        dn = line.substring(3).trim();
        LDIFContent content = this.parse_ldif_content(d);
        rec = new LDIFRecord(dn, content);
        return rec;
    }

    private LDIFContent parse_ldif_content(LineReader d) throws IOException {
        int len;
        String line = d.readLine();
        if (line == null) {
            return null;
        }
        if (line.startsWith("changetype:")) {
            String changetype = line.substring(11).trim();
            if (changetype.equals("modify")) {
                LDIFModifyContent mc = this.parse_mod_spec(d);
                return mc;
            }
            if (changetype.equals("add")) {
                LDIFAddContent ac = this.parse_add_spec(d);
                return ac;
            }
            if (changetype.equals("delete")) {
                LDIFDeleteContent dc = this.parse_delete_spec(d);
                return dc;
            }
            if (changetype.equals("moddn") || changetype.equals("modrdn")) {
                LDIFModDNContent mdnc = this.parse_moddn_spec(d);
                return mdnc;
            }
            throw new IOException("change type not supported");
        }
        Hashtable<String, LDAPAttribute> ht = new Hashtable<String, LDAPAttribute>();
        LDAPAttribute newAttr = null;
        while ((len = line.length()) >= 1) {
            int idx = line.indexOf(58);
            if (idx == -1) {
                throw new IOException("no ':' found in <" + line + ">");
            }
            String newtype = line.substring(0, idx).toLowerCase();
            Object val = "";
            if (len > ++idx) {
                if (line.charAt(idx) == ':') {
                    ByteBuf inBuf = new ByteBuf(line.substring(++idx).trim());
                    ByteBuf decodedBuf = new ByteBuf();
                    this.m_decoder.translate(inBuf, decodedBuf);
                    byte[] bytes = decodedBuf.toBytes();
                    if (decodedBuf.length() == bytes.length) {
                        val = bytes;
                    } else {
                        val = new byte[decodedBuf.length()];
                        System.arraycopy(bytes, 0, val, 0, decodedBuf.length());
                        bytes = null;
                    }
                } else {
                    val = line.substring(idx).trim();
                }
            }
            if ((newAttr = (LDAPAttribute)ht.get(newtype)) == null) {
                newAttr = new LDAPAttribute(newtype);
            }
            if (val instanceof String) {
                newAttr.addValue((String)val);
            } else {
                newAttr.addValue((byte[])val);
            }
            ht.put(newtype, newAttr);
            line = d.readLine();
            if (line != null && line.length() >= 1 && !line.equals("-")) continue;
        }
        Enumeration en = ht.elements();
        LDIFAttributeContent ac = new LDIFAttributeContent();
        while (en.hasMoreElements()) {
            ac.addElement((LDAPAttribute)en.nextElement());
        }
        ht.clear();
        ht = null;
        return ac;
    }

    private LDIFAddContent parse_add_spec(LineReader d) throws IOException {
        LDIFAttributeContent ac = (LDIFAttributeContent)this.parse_ldif_content(d);
        LDAPAttribute[] attrs = ac.getAttributes();
        LDIFAddContent rc = new LDIFAddContent(attrs);
        return rc;
    }

    private LDIFDeleteContent parse_delete_spec(LineReader d) throws IOException {
        String line = d.readLine();
        if (line == null || line.equals("")) {
            LDIFDeleteContent dc = new LDIFDeleteContent();
            return dc;
        }
        throw new IOException("invalid SEP");
    }

    private LDIFModifyContent parse_mod_spec(LineReader d) throws IOException {
        String line = null;
        line = d.readLine();
        LDIFModifyContent mc = new LDIFModifyContent();
        do {
            int oper = -1;
            if (line.startsWith("add:")) {
                oper = 0;
            } else if (line.startsWith("delete:")) {
                oper = 1;
            } else if (line.startsWith("replace:")) {
                oper = 2;
            } else {
                throw new IOException("unknown modify type");
            }
            LDIFAttributeContent ac = (LDIFAttributeContent)this.parse_ldif_content(d);
            LDAPAttribute[] attrs = ac.getAttributes();
            int i = 0;
            while (i < attrs.length) {
                LDAPModification mod = new LDAPModification(oper, attrs[i]);
                mc.addElement(mod);
                ++i;
            }
        } while ((line = d.readLine()) != null && !line.equals(""));
        return mc;
    }

    private LDIFModDNContent parse_moddn_spec(LineReader d) throws IOException {
        String line = null;
        line = d.readLine();
        LDIFModDNContent mc = new LDIFModDNContent();
        do {
            if (line.startsWith("newrdn:") && line.length() > "newrdn:".length() + 1) {
                mc.setRDN(line.substring("newrdn:".length()).trim());
                continue;
            }
            if (line.startsWith("deleteoldrdn:") && line.length() > "deleteoldrdn:".length() + 1) {
                String str = line.substring("deleteoldrdn:".length()).trim();
                if (str.equals("0")) {
                    mc.setDeleteOldRDN(false);
                    continue;
                }
                if (str.equals("1")) {
                    mc.setDeleteOldRDN(true);
                    continue;
                }
                throw new IOException("Incorrect input for deleteOldRdn ");
            }
            if (!line.startsWith("newsuperior:") || line.length() <= "newsuperior:".length() + 1) continue;
            mc.setNewParent(line.substring("newsuperior:".length()).trim());
        } while ((line = d.readLine()) != null && !line.equals(""));
        return mc;
    }

    public int getVersion() {
        return this.m_version;
    }

    public String toString() {
        return "LDIF {" + this.m_source + "}";
    }

    class LineReader {
        private BufferedReader _d;
        String _next;

        LineReader(BufferedReader d) {
            LDIF.this = LDIF.this;
            this._d = d;
        }

        String readLine() throws IOException {
            String line = null;
            String result = null;
            while (true) {
                if (this._next != null) {
                    line = this._next;
                    this._next = null;
                } else {
                    line = this._d.readLine();
                }
                if (line == null) break;
                if (line.length() < 1) {
                    if (result == null) {
                        result = line;
                        continue;
                    }
                    this._next = line;
                    break;
                }
                if (line.charAt(0) == '#') continue;
                if (line.charAt(0) != ' ') {
                    if (result == null) {
                        result = line;
                        continue;
                    }
                    this._next = line;
                    break;
                }
                if (result == null) {
                    throw new IOException("continuation out of nowhere <" + line + ">");
                }
                result = String.valueOf(result) + line.substring(1);
            }
            if (line == null) {
                LDIF.this.m_done = true;
            }
            return result;
        }
    }
}

