/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.AWTCompatibility;
import netscape.application.Font;
import netscape.application.Size;

public class FontMetrics {
    Font _font;
    java.awt.FontMetrics _awtMetrics;
    static final String LEADING = "Leading";
    static final String ASCENT = "Ascent";
    static final String DESCENT = "Descent";
    static final String TOTAL_HEIGHT = "Total Height";
    static final String MAX_ASCENT = "Maximum Ascent";
    static final String MAX_DESCENT = "Maximum Descent";
    static final String MAX_ADVANCE = "Maximum Advance";

    public FontMetrics() {
    }

    public FontMetrics(Font aFont) {
        this();
        this._font = aFont;
        if (!this._font.wasDownloaded()) {
            this._awtMetrics = AWTCompatibility.awtToolkit().getFontMetrics(this._font._awtFont);
        }
    }

    FontMetrics(java.awt.FontMetrics awtMetrics) {
        this();
        this._font = AWTCompatibility.fontForAWTFont(awtMetrics.getFont());
        this._awtMetrics = awtMetrics;
    }

    public Font font() {
        return this._font;
    }

    public int leading() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getLeading();
        }
        return this._font._intValueFromDescription(LEADING);
    }

    public int ascent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getAscent();
        }
        return this._font._intValueFromDescription(ASCENT);
    }

    public int descent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getDescent();
        }
        return this._font._intValueFromDescription(DESCENT);
    }

    public int height() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getHeight();
        }
        return this._font._intValueFromDescription(TOTAL_HEIGHT);
    }

    public int charHeight() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getAscent() + this._awtMetrics.getDescent();
        }
        return this._font._intValueFromDescription(ASCENT) + this._font._intValueFromDescription(DESCENT);
    }

    public int maxAscent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getMaxAscent();
        }
        return this._font._intValueFromDescription(MAX_ASCENT);
    }

    public int maxDescent() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getMaxDecent();
        }
        return this._font._intValueFromDescription(MAX_DESCENT);
    }

    public int maxAdvance() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getMaxAdvance();
        }
        return this._font._intValueFromDescription(MAX_ADVANCE);
    }

    public int charWidth(int aChar) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.charWidth(aChar);
        }
        return 0;
    }

    public int charWidth(char aChar) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.charWidth(aChar);
        }
        return 0;
    }

    public int stringWidth(String aString) {
        if (aString == null) {
            return 0;
        }
        if (this._awtMetrics != null) {
            return this._awtMetrics.stringWidth(aString);
        }
        int length = 0;
        int i = 0;
        while (i < aString.length()) {
            char index = aString.charAt(i);
            if (index >= '\u0000' && index < this._font._widthsArray.length) {
                length += this._font._widthsArray[index];
            }
            ++i;
        }
        return length;
    }

    public int stringHeight() {
        return this.ascent() + this.descent();
    }

    public Size stringSize(String aString) {
        return new Size(this.stringWidth(aString), this.stringHeight());
    }

    public int charsWidth(char[] data, int offset, int length) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.charsWidth(data, offset, length);
        }
        return 0;
    }

    public int bytesWidth(byte[] data, int offset, int length) {
        if (this._awtMetrics != null) {
            return this._awtMetrics.bytesWidth(data, offset, length);
        }
        return 0;
    }

    public int[] widthsArray() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.getWidths();
        }
        return this._font._widthsArray;
    }

    public int widthsArrayBase() {
        return this._font._widthsArrayBase;
    }

    public String toString() {
        if (this._awtMetrics != null) {
            return this._awtMetrics.toString();
        }
        return "";
    }
}

