
/**
 * This is the non-generated part of nsCSSProps
 */

#include "nsCSSProps.h"
#include "nsCSSKeywordIDs.h"
#include "nsStyleConsts.h"
#include "nsCSSKeywords.h"


// Keyword id tables for variant/enum parsing
const PRInt32 nsCSSProps::kAzimuthKTable[] = {
  KEYWORD_LEFT_SIDE,    NS_STYLE_AZIMUTH_LEFT_SIDE,
  KEYWORD_FAR_LEFT,     NS_STYLE_AZIMUTH_FAR_LEFT,
  KEYWORD_LEFT,         NS_STYLE_AZIMUTH_LEFT,
  KEYWORD_CENTER_LEFT,  NS_STYLE_AZIMUTH_CENTER_LEFT,
  KEYWORD_CENTER,       NS_STYLE_AZIMUTH_CENTER,
  KEYWORD_CENTER_RIGHT, NS_STYLE_AZIMUTH_CENTER_RIGHT,
  KEYWORD_RIGHT,        NS_STYLE_AZIMUTH_RIGHT,
  KEYWORD_FAR_RIGHT,    NS_STYLE_AZIMUTH_FAR_RIGHT,
  KEYWORD_RIGHT_SIDE,   NS_STYLE_AZIMUTH_RIGHT_SIDE,
  KEYWORD_BEHIND,       NS_STYLE_AZIMUTH_BEHIND,
  KEYWORD_LEFTWARDS,    NS_STYLE_AZIMUTH_LEFTWARDS,
  KEYWORD_RIGHTWARDS,   NS_STYLE_AZIMUTH_RIGHTWARDS,
  -1,-1
};

const PRInt32 nsCSSProps::kBackgroundAttachmentKTable[] = {
  KEYWORD_FIXED, NS_STYLE_BG_ATTACHMENT_FIXED,
  KEYWORD_SCROLL, NS_STYLE_BG_ATTACHMENT_SCROLL,
  -1,-1
};

const PRInt32 nsCSSProps::kBackgroundColorKTable[] = {
  KEYWORD_TRANSPARENT, NS_STYLE_BG_COLOR_TRANSPARENT,
  -1,-1
};

const PRInt32 nsCSSProps::kBackgroundRepeatKTable[] = {
  KEYWORD_NO_REPEAT,  NS_STYLE_BG_REPEAT_OFF,
  KEYWORD_REPEAT,     NS_STYLE_BG_REPEAT_XY,
  KEYWORD_REPEAT_X,   NS_STYLE_BG_REPEAT_X,
  KEYWORD_REPEAT_Y,   NS_STYLE_BG_REPEAT_Y,
  -1,-1
};

const PRInt32 nsCSSProps::kBorderCollapseKTable[] = {
  KEYWORD_COLLAPSE,  NS_STYLE_BORDER_COLLAPSE,
  KEYWORD_SEPARATE,  NS_STYLE_BORDER_SEPARATE,
  -1,-1
};

const PRInt32 nsCSSProps::kBorderColorKTable[] = {
  KEYWORD_TRANSPARENT, NS_STYLE_COLOR_TRANSPARENT,
  -1,-1
};

const PRInt32 nsCSSProps::kBorderStyleKTable[] = {
  KEYWORD_HIDDEN, NS_STYLE_BORDER_STYLE_HIDDEN,
  KEYWORD_DOTTED, NS_STYLE_BORDER_STYLE_DOTTED,
  KEYWORD_DASHED, NS_STYLE_BORDER_STYLE_DASHED,
  KEYWORD_SOLID,  NS_STYLE_BORDER_STYLE_SOLID,
  KEYWORD_DOUBLE, NS_STYLE_BORDER_STYLE_DOUBLE,
  KEYWORD_GROOVE, NS_STYLE_BORDER_STYLE_GROOVE,
  KEYWORD_RIDGE,  NS_STYLE_BORDER_STYLE_RIDGE,
  KEYWORD_INSET,  NS_STYLE_BORDER_STYLE_INSET,
  KEYWORD_OUTSET, NS_STYLE_BORDER_STYLE_OUTSET,
  KEYWORD__MOZ_BG_INSET,  NS_STYLE_BORDER_STYLE_BG_INSET,
  KEYWORD__MOZ_BG_OUTSET, NS_STYLE_BORDER_STYLE_BG_OUTSET,
  -1,-1
};

const PRInt32 nsCSSProps::kBorderWidthKTable[] = {
  KEYWORD_THIN, NS_STYLE_BORDER_WIDTH_THIN,
  KEYWORD_MEDIUM, NS_STYLE_BORDER_WIDTH_MEDIUM,
  KEYWORD_THICK, NS_STYLE_BORDER_WIDTH_THICK,
  -1,-1
};

const PRInt32 nsCSSProps::kCaptionSideKTable[] = {
  KEYWORD_TOP,    NS_SIDE_TOP,
  KEYWORD_RIGHT,  NS_SIDE_RIGHT,
  KEYWORD_BOTTOM, NS_SIDE_BOTTOM,
  KEYWORD_LEFT,   NS_SIDE_LEFT,
  -1,-1
};

const PRInt32 nsCSSProps::kClearKTable[] = {
  KEYWORD_LEFT, NS_STYLE_CLEAR_LEFT,
  KEYWORD_RIGHT, NS_STYLE_CLEAR_RIGHT,
  KEYWORD_BOTH, NS_STYLE_CLEAR_LEFT_AND_RIGHT,
  -1,-1
};

const PRInt32 nsCSSProps::kContentKTable[] = {
  KEYWORD_OPEN_QUOTE, NS_STYLE_CONTENT_OPEN_QUOTE,
  KEYWORD_CLOSE_QUOTE, NS_STYLE_CONTENT_CLOSE_QUOTE,
  KEYWORD_NO_OPEN_QUOTE, NS_STYLE_CONTENT_NO_OPEN_QUOTE,
  KEYWORD_NO_CLOSE_QUOTE, NS_STYLE_CONTENT_NO_CLOSE_QUOTE,
  -1,-1
};

const PRInt32 nsCSSProps::kCursorKTable[] = {
  KEYWORD_CROSSHAIR, NS_STYLE_CURSOR_CROSSHAIR,
  KEYWORD_DEFAULT, NS_STYLE_CURSOR_DEFAULT,
  KEYWORD_POINTER, NS_STYLE_CURSOR_POINTER,
  KEYWORD_MOVE, NS_STYLE_CURSOR_MOVE,
  KEYWORD_E_RESIZE, NS_STYLE_CURSOR_E_RESIZE,
  KEYWORD_NE_RESIZE, NS_STYLE_CURSOR_NE_RESIZE,
  KEYWORD_NW_RESIZE, NS_STYLE_CURSOR_NW_RESIZE,
  KEYWORD_N_RESIZE, NS_STYLE_CURSOR_N_RESIZE,
  KEYWORD_SE_RESIZE, NS_STYLE_CURSOR_SE_RESIZE,
  KEYWORD_SW_RESIZE, NS_STYLE_CURSOR_SW_RESIZE,
  KEYWORD_S_RESIZE, NS_STYLE_CURSOR_S_RESIZE,
  KEYWORD_W_RESIZE, NS_STYLE_CURSOR_W_RESIZE,
  KEYWORD_TEXT, NS_STYLE_CURSOR_TEXT,
  KEYWORD_WAIT, NS_STYLE_CURSOR_WAIT,
  KEYWORD_HELP, NS_STYLE_CURSOR_HELP,
  -1,-1
};

const PRInt32 nsCSSProps::kDirectionKTable[] = {
  KEYWORD_LTR,      NS_STYLE_DIRECTION_LTR,
  KEYWORD_RTL,      NS_STYLE_DIRECTION_RTL,
  -1,-1
};

const PRInt32 nsCSSProps::kDisplayKTable[] = {
  KEYWORD_INLINE,             NS_STYLE_DISPLAY_INLINE,
  KEYWORD_BLOCK,              NS_STYLE_DISPLAY_BLOCK,
  KEYWORD_LIST_ITEM,          NS_STYLE_DISPLAY_LIST_ITEM,
  KEYWORD_RUN_IN,             NS_STYLE_DISPLAY_RUN_IN,
  KEYWORD_COMPACT,            NS_STYLE_DISPLAY_COMPACT,
  KEYWORD_MARKER,             NS_STYLE_DISPLAY_MARKER,
  KEYWORD_TABLE,              NS_STYLE_DISPLAY_TABLE,
  KEYWORD_INLINE_TABLE,       NS_STYLE_DISPLAY_INLINE_TABLE,
  KEYWORD_TABLE_ROW_GROUP,    NS_STYLE_DISPLAY_TABLE_ROW_GROUP,
  KEYWORD_TABLE_HEADER_GROUP, NS_STYLE_DISPLAY_TABLE_HEADER_GROUP,
  KEYWORD_TABLE_FOOTER_GROUP, NS_STYLE_DISPLAY_TABLE_FOOTER_GROUP,
  KEYWORD_TABLE_ROW,          NS_STYLE_DISPLAY_TABLE_ROW,
  KEYWORD_TABLE_COLUMN_GROUP, NS_STYLE_DISPLAY_TABLE_COLUMN_GROUP,
  KEYWORD_TABLE_COLUMN,       NS_STYLE_DISPLAY_TABLE_COLUMN,
  KEYWORD_TABLE_CELL,         NS_STYLE_DISPLAY_TABLE_CELL,
  KEYWORD_TABLE_CAPTION,      NS_STYLE_DISPLAY_TABLE_CAPTION,
  -1,-1
};

const PRInt32 nsCSSProps::kElevationKTable[] = {
  KEYWORD_BELOW,  NS_STYLE_ELEVATION_BELOW,
  KEYWORD_LEVEL,  NS_STYLE_ELEVATION_LEVEL,
  KEYWORD_ABOVE,  NS_STYLE_ELEVATION_ABOVE,
  KEYWORD_HIGHER, NS_STYLE_ELEVATION_HIGHER,
  KEYWORD_LOWER,  NS_STYLE_ELEVATION_LOWER,
  -1,-1
};

const PRInt32 nsCSSProps::kEmptyCellsKTable[] = {
  KEYWORD_SHOW,  NS_STYLE_TABLE_EMPTY_CELLS_SHOW,
  KEYWORD_HIDE,  NS_STYLE_TABLE_EMPTY_CELLS_HIDE,
  -1,-1
};

const PRInt32 nsCSSProps::kFloatKTable[] = {
  KEYWORD_LEFT,  NS_STYLE_FLOAT_LEFT,
  KEYWORD_RIGHT, NS_STYLE_FLOAT_RIGHT,
  -1,-1
};

const PRInt32 nsCSSProps::kFontKTable[] = {
  KEYWORD_CAPTION, NS_STYLE_FONT_CAPTION,
  KEYWORD_ICON, NS_STYLE_FONT_ICON,
  KEYWORD_MENU, NS_STYLE_FONT_MENU,
  KEYWORD_MESSAGE_BOX, NS_STYLE_FONT_MESSAGE_BOX,
  KEYWORD_SMALL_CAPTION, NS_STYLE_FONT_SMALL_CAPTION,
  KEYWORD_STATUS_BAR, NS_STYLE_FONT_STATUS_BAR,
  -1,-1
};

const PRInt32 nsCSSProps::kFontSizeKTable[] = {
  KEYWORD_XX_SMALL, NS_STYLE_FONT_SIZE_XXSMALL,
  KEYWORD_X_SMALL, NS_STYLE_FONT_SIZE_XSMALL,
  KEYWORD_SMALL, NS_STYLE_FONT_SIZE_SMALL,
  KEYWORD_MEDIUM, NS_STYLE_FONT_SIZE_MEDIUM,
  KEYWORD_LARGE, NS_STYLE_FONT_SIZE_LARGE,
  KEYWORD_X_LARGE, NS_STYLE_FONT_SIZE_XLARGE,
  KEYWORD_XX_LARGE, NS_STYLE_FONT_SIZE_XXLARGE,
  KEYWORD_LARGER, NS_STYLE_FONT_SIZE_LARGER,
  KEYWORD_SMALLER, NS_STYLE_FONT_SIZE_SMALLER,
  -1,-1
};

const PRInt32 nsCSSProps::kFontStretchKTable[] = {
  KEYWORD_WIDER, NS_STYLE_FONT_STRETCH_WIDER,
  KEYWORD_NARROWER, NS_STYLE_FONT_STRETCH_NARROWER,
  KEYWORD_ULTRA_CONDENSED, NS_STYLE_FONT_STRETCH_ULTRA_CONDENSED,
  KEYWORD_EXTRA_CONDENSED, NS_STYLE_FONT_STRETCH_EXTRA_CONDENSED,
  KEYWORD_CONDENSED, NS_STYLE_FONT_STRETCH_CONDENSED,
  KEYWORD_SEMI_CONDENSED, NS_STYLE_FONT_STRETCH_SEMI_CONDENSED,
  KEYWORD_SEMI_EXPANDED, NS_STYLE_FONT_STRETCH_SEMI_EXPANDED,
  KEYWORD_EXPANDED, NS_STYLE_FONT_STRETCH_EXPANDED,
  KEYWORD_EXTRA_EXPANDED, NS_STYLE_FONT_STRETCH_EXTRA_EXPANDED,
  KEYWORD_ULTRA_EXPANDED, NS_STYLE_FONT_STRETCH_ULTRA_EXPANDED,
  -1,-1
};

const PRInt32 nsCSSProps::kFontStyleKTable[] = {
  KEYWORD_ITALIC, NS_STYLE_FONT_STYLE_ITALIC,
  KEYWORD_OBLIQUE, NS_STYLE_FONT_STYLE_OBLIQUE,
  -1,-1
};

const PRInt32 nsCSSProps::kFontVariantKTable[] = {
  KEYWORD_SMALL_CAPS, NS_STYLE_FONT_VARIANT_SMALL_CAPS,
  -1,-1
};

const PRInt32 nsCSSProps::kFontWeightKTable[] = {
    KEYWORD_BOLD, NS_STYLE_FONT_WEIGHT_BOLD,
    KEYWORD_BOLDER, NS_STYLE_FONT_WEIGHT_BOLDER,
    KEYWORD_LIGHTER, NS_STYLE_FONT_WEIGHT_LIGHTER,
    -1,-1
};

const PRInt32 nsCSSProps::kListStylePositionKTable[] = {
  KEYWORD_INSIDE, NS_STYLE_LIST_STYLE_POSITION_INSIDE,
  KEYWORD_OUTSIDE, NS_STYLE_LIST_STYLE_POSITION_OUTSIDE,
  -1,-1
};

const PRInt32 nsCSSProps::kListStyleKTable[] = {
  KEYWORD_DISC, NS_STYLE_LIST_STYLE_DISC,
  KEYWORD_CIRCLE, NS_STYLE_LIST_STYLE_CIRCLE,
  KEYWORD_SQUARE, NS_STYLE_LIST_STYLE_SQUARE,
  KEYWORD_DECIMAL, NS_STYLE_LIST_STYLE_DECIMAL,
  KEYWORD_DECIMAL_LEADING_ZERO, NS_STYLE_LIST_STYLE_DECIMAL_LEADING_ZERO,
  KEYWORD_LOWER_ROMAN, NS_STYLE_LIST_STYLE_LOWER_ROMAN,
  KEYWORD_UPPER_ROMAN, NS_STYLE_LIST_STYLE_UPPER_ROMAN,
  KEYWORD_LOWER_GREEK, NS_STYLE_LIST_STYLE_LOWER_GREEK,
  KEYWORD_LOWER_ALPHA, NS_STYLE_LIST_STYLE_LOWER_ALPHA,
  KEYWORD_LOWER_LATIN, NS_STYLE_LIST_STYLE_LOWER_LATIN,
  KEYWORD_UPPER_ALPHA, NS_STYLE_LIST_STYLE_UPPER_ALPHA,
  KEYWORD_UPPER_LATIN, NS_STYLE_LIST_STYLE_UPPER_LATIN,
  KEYWORD_HEBREW, NS_STYLE_LIST_STYLE_HEBREW,
  KEYWORD_ARMENIAN, NS_STYLE_LIST_STYLE_ARMENIAN,
  KEYWORD_GEORGIAN, NS_STYLE_LIST_STYLE_GEORGIAN,
  KEYWORD_CJK_IDEOGRAPHIC, NS_STYLE_LIST_STYLE_CJK_IDEOGRAPHIC,
  KEYWORD_HIRAGANA, NS_STYLE_LIST_STYLE_HIRAGANA,
  KEYWORD_KATAKANA, NS_STYLE_LIST_STYLE_KATAKANA,
  KEYWORD_HIRAGANA_IROHA, NS_STYLE_LIST_STYLE_HIRAGANA_IROHA,
  KEYWORD_KATAKANA_IROHA, NS_STYLE_LIST_STYLE_KATAKANA_IROHA,
  -1,-1
};

const PRInt32 nsCSSProps::kOutlineColorKTable[] = {
  KEYWORD_INVERT, NS_STYLE_COLOR_INVERT,
  -1,-1
};

const PRInt32 nsCSSProps::kOverflowKTable[] = {
  KEYWORD_VISIBLE, NS_STYLE_OVERFLOW_VISIBLE,
  KEYWORD_HIDDEN, NS_STYLE_OVERFLOW_HIDDEN,
  KEYWORD_SCROLL, NS_STYLE_OVERFLOW_SCROLL,
  -1,-1
};

const PRInt32 nsCSSProps::kPageBreakKTable[] = {
  KEYWORD_ALWAYS, NS_STYLE_PAGE_BREAK_ALWAYS,
  KEYWORD_AVOID, NS_STYLE_PAGE_BREAK_AVOID,
  KEYWORD_LEFT, NS_STYLE_PAGE_BREAK_LEFT,
  KEYWORD_RIGHT, NS_STYLE_PAGE_BREAK_RIGHT,
  -1,-1
};

const PRInt32 nsCSSProps::kPageBreakInsideKTable[] = {
  KEYWORD_AVOID, NS_STYLE_PAGE_BREAK_AVOID,
  -1,-1
};

const PRInt32 nsCSSProps::kPageMarksKTable[] = {
  KEYWORD_CROP, NS_STYLE_PAGE_MARKS_CROP,
  KEYWORD_CROSS, NS_STYLE_PAGE_MARKS_REGISTER,
  -1,-1
};

const PRInt32 nsCSSProps::kPageSizeKTable[] = {
  KEYWORD_LANDSCAPE, NS_STYLE_PAGE_SIZE_LANDSCAPE,
  KEYWORD_PORTRAIT, NS_STYLE_PAGE_SIZE_PORTRAIT,
  -1,-1
};

const PRInt32 nsCSSProps::kPitchKTable[] = {
  KEYWORD_X_LOW, NS_STYLE_PITCH_X_LOW,
  KEYWORD_LOW, NS_STYLE_PITCH_LOW,
  KEYWORD_MEDIUM, NS_STYLE_PITCH_MEDIUM,
  KEYWORD_HIGH, NS_STYLE_PITCH_HIGH,
  KEYWORD_X_HIGH, NS_STYLE_PITCH_X_HIGH,
  -1,-1
};

const PRInt32 nsCSSProps::kPlayDuringKTable[] = {
  KEYWORD_MIX, NS_STYLE_PLAY_DURING_MIX,
  KEYWORD_REPEAT, NS_STYLE_PLAY_DURING_REPEAT,
  -1,-1
};

const PRInt32 nsCSSProps::kPositionKTable[] = {
  KEYWORD_STATIC, NS_STYLE_POSITION_NORMAL,
  KEYWORD_RELATIVE, NS_STYLE_POSITION_RELATIVE,
  KEYWORD_ABSOLUTE, NS_STYLE_POSITION_ABSOLUTE,
  KEYWORD_FIXED, NS_STYLE_POSITION_FIXED,
  -1,-1
};

const PRInt32 nsCSSProps::kSpeakKTable[] = {
  KEYWORD_SPELL_OUT, NS_STYLE_SPEAK_SPELL_OUT,
  -1,-1
};

const PRInt32 nsCSSProps::kSpeakHeaderKTable[] = {
  KEYWORD_ONCE, NS_STYLE_SPEAK_HEADER_ONCE,
  KEYWORD_ALWAYS, NS_STYLE_SPEAK_HEADER_ALWAYS,
  -1,-1
};

const PRInt32 nsCSSProps::kSpeakNumeralKTable[] = {
  KEYWORD_DIGITS, NS_STYLE_SPEAK_NUMERAL_DIGITS,
  KEYWORD_CONTINUOUS, NS_STYLE_SPEAK_NUMERAL_CONTINUOUS,
  -1,-1
};

const PRInt32 nsCSSProps::kSpeakPunctuationKTable[] = {
  KEYWORD_CODE, NS_STYLE_SPEAK_PUNCTUATION_CODE,
  -1,-1
};

const PRInt32 nsCSSProps::kSpeechRateKTable[] = {
  KEYWORD_X_SLOW, NS_STYLE_SPEECH_RATE_X_SLOW,
  KEYWORD_SLOW, NS_STYLE_SPEECH_RATE_SLOW,
  KEYWORD_MEDIUM, NS_STYLE_SPEECH_RATE_MEDIUM,
  KEYWORD_FAST, NS_STYLE_SPEECH_RATE_FAST,
  KEYWORD_X_FAST, NS_STYLE_SPEECH_RATE_X_FAST,
  KEYWORD_FASTER, NS_STYLE_SPEECH_RATE_FASTER,
  KEYWORD_SLOWER, NS_STYLE_SPEECH_RATE_SLOWER,
  -1,-1
};

const PRInt32 nsCSSProps::kTableLayoutKTable[] = {
  KEYWORD_FIXED, NS_STYLE_TABLE_LAYOUT_FIXED,
  -1,-1
};

const PRInt32 nsCSSProps::kTextAlignKTable[] = {
  KEYWORD_LEFT, NS_STYLE_TEXT_ALIGN_LEFT,
  KEYWORD_RIGHT, NS_STYLE_TEXT_ALIGN_RIGHT,
  KEYWORD_CENTER, NS_STYLE_TEXT_ALIGN_CENTER,
  KEYWORD_JUSTIFY, NS_STYLE_TEXT_ALIGN_JUSTIFY,
  KEYWORD__MOZ_CENTER, NS_STYLE_TEXT_ALIGN_MOZ_CENTER,
  KEYWORD__MOZ_RIGHT, NS_STYLE_TEXT_ALIGN_MOZ_RIGHT,
  -1,-1
};

const PRInt32 nsCSSProps::kTextDecorationKTable[] = {
  KEYWORD_UNDERLINE, NS_STYLE_TEXT_DECORATION_UNDERLINE,
  KEYWORD_OVERLINE, NS_STYLE_TEXT_DECORATION_OVERLINE,
  KEYWORD_LINE_THROUGH, NS_STYLE_TEXT_DECORATION_LINE_THROUGH,
  KEYWORD_BLINK, NS_STYLE_TEXT_DECORATION_BLINK,
  -1,-1
};

const PRInt32 nsCSSProps::kTextTransformKTable[] = {
  KEYWORD_CAPITALIZE, NS_STYLE_TEXT_TRANSFORM_CAPITALIZE,
  KEYWORD_LOWERCASE, NS_STYLE_TEXT_TRANSFORM_LOWERCASE,
  KEYWORD_UPPERCASE, NS_STYLE_TEXT_TRANSFORM_UPPERCASE,
  -1,-1
};

const PRInt32 nsCSSProps::kUnicodeBidiKTable[] = {
  KEYWORD_EMBED, NS_STYLE_UNICODE_BIDI_EMBED,
  KEYWORD_BIDI_OVERRIDE, NS_STYLE_UNICODE_BIDI_OVERRIDE,
  -1,-1
};

const PRInt32 nsCSSProps::kVerticalAlignKTable[] = {
  KEYWORD_BASELINE, NS_STYLE_VERTICAL_ALIGN_BASELINE,
  KEYWORD_SUB, NS_STYLE_VERTICAL_ALIGN_SUB,
  KEYWORD_SUPER, NS_STYLE_VERTICAL_ALIGN_SUPER,
  KEYWORD_TOP, NS_STYLE_VERTICAL_ALIGN_TOP,
  KEYWORD_TEXT_TOP, NS_STYLE_VERTICAL_ALIGN_TEXT_TOP,
  KEYWORD_MIDDLE, NS_STYLE_VERTICAL_ALIGN_MIDDLE,
  KEYWORD_BOTTOM, NS_STYLE_VERTICAL_ALIGN_BOTTOM,
  KEYWORD_TEXT_BOTTOM, NS_STYLE_VERTICAL_ALIGN_TEXT_BOTTOM,
  -1,-1
};

const PRInt32 nsCSSProps::kVisibilityKTable[] = {
  KEYWORD_VISIBLE, NS_STYLE_VISIBILITY_VISIBLE,
  KEYWORD_HIDDEN, NS_STYLE_VISIBILITY_HIDDEN,
  KEYWORD_COLLAPSE, NS_STYLE_VISIBILITY_COLLAPSE,
  -1,-1
};

const PRInt32 nsCSSProps::kVolumeKTable[] = {
  KEYWORD_SILENT, NS_STYLE_VOLUME_SILENT,
  KEYWORD_X_SOFT, NS_STYLE_VOLUME_X_SOFT,
  KEYWORD_SOFT, NS_STYLE_VOLUME_SOFT,
  KEYWORD_MEDIUM, NS_STYLE_VOLUME_MEDIUM,
  KEYWORD_LOUD, NS_STYLE_VOLUME_LOUD,
  KEYWORD_X_LOUD, NS_STYLE_VOLUME_X_LOUD,
  -1,-1
};

const PRInt32 nsCSSProps::kWhitespaceKTable[] = {
  KEYWORD_PRE, NS_STYLE_WHITESPACE_PRE,
  KEYWORD_NOWRAP, NS_STYLE_WHITESPACE_NOWRAP,
  KEYWORD__MOZ_PRE_WRAP, NS_STYLE_WHITESPACE_MOZ_PRE_WRAP,
  -1,-1
};

static const char* SearchKeywordTable(PRInt32 aID, const PRInt32 aTable[])
{
  PRInt32 i = 1;
  if (aID >= 0)
  {
    for (;;) {
      if (aTable[i] < 0) {
        break;
      }
      if (aID == aTable[i]) {
        return nsCSSKeywords::kNameTable[aTable[i-1]].name;
      }
      i += 2;
    }
  }
  return nsnull;
}



const char* nsCSSProps::LookupProperty(PRInt32 aProp, PRInt32 aIndex)
{
static const PRInt32 kBackgroundXPositionKTable[] = {
  KEYWORD_LEFT,   0,
  KEYWORD_CENTER, 50,
  KEYWORD_RIGHT,  100,
  -1,-1
};

static const PRInt32 kBackgroundYPositionKTable[] = {
  KEYWORD_TOP,    0,
  KEYWORD_CENTER, 50,
  KEYWORD_BOTTOM, 100,
  -1,-1
};

  switch (aProp)  {
  
  case PROP_AZIMUTH:
    return SearchKeywordTable(aIndex, kAzimuthKTable);

  case PROP_BACKGROUND:
    break;
  
  case PROP_BACKGROUND_ATTACHMENT:
    return SearchKeywordTable(aIndex, kBackgroundAttachmentKTable);

  case PROP_BACKGROUND_COLOR:
    return SearchKeywordTable(aIndex, kBackgroundColorKTable);
  
  case PROP_BACKGROUND_FILTER:
    break;
    
  case PROP_BACKGROUND_IMAGE:
    break;

  case PROP_BACKGROUND_POSITION:
    break;

  case PROP_BACKGROUND_REPEAT:
    return SearchKeywordTable(aIndex, kBackgroundRepeatKTable);

  case PROP_BACKGROUND_X_POSITION:
    return SearchKeywordTable(aIndex, kBackgroundXPositionKTable);

  case PROP_BACKGROUND_Y_POSITION:
    return SearchKeywordTable(aIndex, kBackgroundYPositionKTable);

  case PROP_BORDER:
    break;

  case PROP_BORDER_COLLAPSE:
    return SearchKeywordTable(aIndex, kBorderCollapseKTable);

  case PROP_BORDER_COLOR:
  case PROP_BORDER_SPACING:
  case PROP_BORDER_STYLE:
  case PROP_BORDER_BOTTOM:
  case PROP_BORDER_LEFT:
  case PROP_BORDER_RIGHT:
  case PROP_BORDER_TOP:
    break;

  case PROP_BORDER_BOTTOM_COLOR:
  case PROP_BORDER_LEFT_COLOR:
  case PROP_BORDER_RIGHT_COLOR:
  case PROP_BORDER_TOP_COLOR:
    return SearchKeywordTable(aIndex, kBorderColorKTable);

  case PROP_BORDER_BOTTOM_STYLE:
  case PROP_BORDER_LEFT_STYLE:
  case PROP_BORDER_RIGHT_STYLE:
  case PROP_BORDER_TOP_STYLE:
    return SearchKeywordTable(aIndex, kBorderStyleKTable);

  case PROP_BORDER_BOTTOM_WIDTH:
  case PROP_BORDER_LEFT_WIDTH:
  case PROP_BORDER_RIGHT_WIDTH:
  case PROP_BORDER_TOP_WIDTH:
    return SearchKeywordTable(aIndex, kBorderWidthKTable);
  
  case PROP_BORDER_WIDTH:
  case PROP_BORDER_X_SPACING:
  case PROP_BORDER_Y_SPACING:
  case PROP_BOTTOM:
    break;

  case PROP_CAPTION_SIDE:
    return SearchKeywordTable(aIndex, kCaptionSideKTable);  

  case PROP_CLEAR:
    return SearchKeywordTable(aIndex, kClearKTable);  
    
  case PROP_CLIP:
  case PROP_CLIP_BOTTOM:
  case PROP_CLIP_LEFT:
  case PROP_CLIP_RIGHT:
  case PROP_CLIP_TOP:
  case PROP_COLOR:
    break;

  case PROP_CONTENT:
    return SearchKeywordTable(aIndex, kContentKTable);  

  case PROP_COUNTER_INCREMENT:
  case PROP_COUNTER_RESET:
  case PROP_CUE:
  case PROP_CUE_AFTER:
  case PROP_CUE_BEFORE:
    break;

  case PROP_CURSOR:
    return SearchKeywordTable(aIndex, kCursorKTable);  

  case PROP_DIRECTION:
    return SearchKeywordTable(aIndex, kDirectionKTable);  
  
  case PROP_DISPLAY:
    return SearchKeywordTable(aIndex, kDisplayKTable);  

  case PROP_ELEVATION:
    return SearchKeywordTable(aIndex, kElevationKTable);  

  case PROP_EMPTY_CELLS:
    return SearchKeywordTable(aIndex, kEmptyCellsKTable);  

  case PROP_FILTER:
    break;
  
  case PROP_FLOAT:
    return SearchKeywordTable(aIndex, kFloatKTable);  

  case PROP_FONT:
    break;

  case PROP_FONT_FAMILY:
    return SearchKeywordTable(aIndex, kFontKTable);  
    
  case PROP_FONT_SIZE:
    return SearchKeywordTable(aIndex, kFontSizeKTable);  

  case PROP_FONT_SIZE_ADJUST:
    break;

  case PROP_FONT_STRETCH:
    return SearchKeywordTable(aIndex, kFontStretchKTable);  

  case PROP_FONT_STYLE:
    return SearchKeywordTable(aIndex, kFontStyleKTable);  

  case PROP_FONT_VARIANT:
    return SearchKeywordTable(aIndex, kFontVariantKTable);  
  
  case PROP_FONT_WEIGHT:
    return SearchKeywordTable(aIndex, kFontWeightKTable);  

  case PROP_HEIGHT:
  case PROP_LEFT:
  case PROP_LETTER_SPACING:
  case PROP_LINE_HEIGHT:
  case PROP_LIST_STYLE:
  case PROP_LIST_STYLE_IMAGE:
    break;

  case PROP_LIST_STYLE_POSITION:
    return SearchKeywordTable(aIndex, kListStylePositionKTable);  
  
  case PROP_LIST_STYLE_TYPE:
    return SearchKeywordTable(aIndex, kListStyleKTable);

  case PROP_MARGIN:
  case PROP_MARGIN_BOTTOM:
  case PROP_MARGIN_LEFT:
  case PROP_MARGIN_RIGHT:
  case PROP_MARGIN_TOP:
  case PROP_MARKER_OFFSET:
    break;

  case PROP_MARKS:
    return SearchKeywordTable(aIndex, kPageMarksKTable);

  case PROP_MAX_HEIGHT:
  case PROP_MAX_WIDTH:
  case PROP_MIN_HEIGHT:
  case PROP_MIN_WIDTH:
  case PROP_OPACITY:
  case PROP_ORPHANS:
  case PROP_OUTLINE:
    break;

  case PROP_OUTLINE_COLOR:
    return SearchKeywordTable(aIndex, kOutlineColorKTable);

  case PROP_OUTLINE_STYLE:
    return SearchKeywordTable(aIndex, kBorderStyleKTable);

  case PROP_OUTLINE_WIDTH:
    return SearchKeywordTable(aIndex, kBorderWidthKTable);

  case PROP_OVERFLOW:
    return SearchKeywordTable(aIndex, kOverflowKTable);
  
  case PROP_PADDING:
  case PROP_PADDING_BOTTOM:
  case PROP_PADDING_LEFT:
  case PROP_PADDING_RIGHT:
  case PROP_PADDING_TOP:
  case PROP_PAGE:
    break;

  case PROP_PAGE_BREAK_BEFORE:
  case PROP_PAGE_BREAK_AFTER:
    return SearchKeywordTable(aIndex, kPageBreakKTable);

  case PROP_PAGE_BREAK_INSIDE:
    return SearchKeywordTable(aIndex, kPageBreakInsideKTable);
  
  case PROP_PAUSE:
  case PROP_PAUSE_AFTER:
  case PROP_PAUSE_BEFORE:
    break;

  case PROP_PITCH:
    return SearchKeywordTable(aIndex, kPitchKTable);

  case PROP_PITCH_RANGE:
  case PROP_PLAY_DURING:
    break;

  case PROP_PLAY_DURING_FLAGS:
    return SearchKeywordTable(aIndex, kPlayDuringKTable);

  case PROP_POSITION:
    return SearchKeywordTable(aIndex, kPositionKTable);
  
  case PROP_QUOTES:
  case PROP_QUOTES_CLOSE:
  case PROP_QUOTES_OPEN:
  case PROP_RICHNESS:
  case PROP_RIGHT:
  case PROP_SIZE:
    break;

  case PROP_SIZE_HEIGHT:
  case PROP_SIZE_WIDTH:
    return SearchKeywordTable(aIndex, kPageSizeKTable);

  case PROP_SPEAK:
    return SearchKeywordTable(aIndex, kSpeakKTable);

  case PROP_SPEAK_HEADER:
    return SearchKeywordTable(aIndex, kSpeakHeaderKTable);

  case PROP_SPEAK_NUMERAL:
    return SearchKeywordTable(aIndex, kSpeakNumeralKTable);

  case PROP_SPEAK_PUNCTUATION:
    return SearchKeywordTable(aIndex, kSpeakPunctuationKTable);

  case PROP_SPEECH_RATE:
    return SearchKeywordTable(aIndex, kSpeechRateKTable);

  case PROP_STRESS:
    break;

  case PROP_TABLE_LAYOUT:
    return SearchKeywordTable(aIndex, kTableLayoutKTable);

  case PROP_TEXT_ALIGN:
    return SearchKeywordTable(aIndex, kTextAlignKTable);
  
  case PROP_TEXT_DECORATION:
    return SearchKeywordTable(aIndex, kTextDecorationKTable);

  case PROP_TEXT_INDENT:
  case PROP_TEXT_SHADOW:
  case PROP_TEXT_SHADOW_COLOR:
  case PROP_TEXT_SHADOW_RADIUS:
  case PROP_TEXT_SHADOW_X:
  case PROP_TEXT_SHADOW_Y:
    break;
  
  case PROP_TEXT_TRANSFORM:
    return SearchKeywordTable(aIndex, kTextTransformKTable);
  
  case PROP_TOP:
    break;

  case PROP_UNICODE_BIDI:
    return SearchKeywordTable(aIndex, kUnicodeBidiKTable);

  case PROP_VERTICAL_ALIGN:
    return SearchKeywordTable(aIndex, kVerticalAlignKTable);
  
  case PROP_VISIBILITY:
    return SearchKeywordTable(aIndex, kVisibilityKTable);

  case PROP_VOICE_FAMILY:
    break;

  case PROP_VOLUME:
    return SearchKeywordTable(aIndex, kVolumeKTable);
    
  case PROP_WHITE_SPACE:
    return SearchKeywordTable(aIndex, kWhitespaceKTable);

  case PROP_WIDOWS:
  case PROP_WIDTH:
  case PROP_WORD_SPACING:
  case PROP_Z_INDEX:
    break;

  default:
    NS_ERROR("unsupported property");
    break;
  }
  return nsnull;
}


const PRInt32 nsCSSProps::kHintTable[PROP_MAX] = {
  NS_STYLE_HINT_VISUAL, // PROP__MOZ_BORDER_RADIUS
  NS_STYLE_HINT_AURAL,  // PROP_AZIMUTH
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_ATTACHMENT 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_COLOR 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_FILTER 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_IMAGE 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_POSITION 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_REPEAT 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_X_POSITION 
  NS_STYLE_HINT_VISUAL, // PROP_BACKGROUND_Y_POSITION 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_BOTTOM 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_BOTTOM_COLOR 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_BOTTOM_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_BOTTOM_WIDTH 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_COLLAPSE
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_COLOR 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_LEFT 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_LEFT_COLOR 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_LEFT_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_LEFT_WIDTH 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_RIGHT 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_RIGHT_COLOR 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_RIGHT_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_RIGHT_WIDTH
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_SPACING
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_TOP 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_TOP_COLOR 
  NS_STYLE_HINT_VISUAL, // PROP_BORDER_TOP_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_TOP_WIDTH 
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_WIDTH 

  NS_STYLE_HINT_REFLOW, // PROP_BORDER_X_SPACING XXX
  NS_STYLE_HINT_REFLOW, // PROP_BORDER_Y_SPACING XXX

  NS_STYLE_HINT_REFLOW, // PROP_BOTTOM
  NS_STYLE_HINT_REFLOW, // PROP_CAPTION_SIDE
  NS_STYLE_HINT_REFLOW, // PROP_CLEAR 
  NS_STYLE_HINT_VISUAL, // PROP_CLIP 
  NS_STYLE_HINT_VISUAL, // PROP_CLIP_BOTTOM 
  NS_STYLE_HINT_VISUAL, // PROP_CLIP_LEFT 
  NS_STYLE_HINT_VISUAL, // PROP_CLIP_RIGHT 
  NS_STYLE_HINT_VISUAL, // PROP_CLIP_TOP 
  NS_STYLE_HINT_VISUAL, // PROP_COLOR 
  NS_STYLE_HINT_FRAMECHANGE, // PROP_CONTENT
  NS_STYLE_HINT_REFLOW, // PROP_COUNTER_INCREMENT
  NS_STYLE_HINT_REFLOW, // PROP_COUNTER_RESET
  NS_STYLE_HINT_AURAL,  // PROP_CUE
  NS_STYLE_HINT_AURAL,  // PROP_CUE_AFTER
  NS_STYLE_HINT_AURAL,  // PROP_CUE_BEFORE
  NS_STYLE_HINT_VISUAL, // PROP_CURSOR 
  NS_STYLE_HINT_REFLOW, // PROP_DIRECTION 
  NS_STYLE_HINT_FRAMECHANGE, // PROP_DISPLAY 
  NS_STYLE_HINT_AURAL,  // PROP_ELEVATION
  NS_STYLE_HINT_VISUAL, // PROP_EMPTY_CELLS
  NS_STYLE_HINT_VISUAL, // PROP_FILTER 
  NS_STYLE_HINT_FRAMECHANGE, // PROP_FLOAT 
  NS_STYLE_HINT_REFLOW, // PROP_FONT 
  NS_STYLE_HINT_REFLOW, // PROP_FONT_FAMILY 
  NS_STYLE_HINT_REFLOW, // PROP_FONT_SIZE 
  NS_STYLE_HINT_REFLOW, // PROP_FONT_SIZE_ADJUST
  NS_STYLE_HINT_REFLOW, // PROP_FONT_STRETCH
  NS_STYLE_HINT_REFLOW, // PROP_FONT_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_FONT_VARIANT 
  NS_STYLE_HINT_REFLOW, // PROP_FONT_WEIGHT 
  NS_STYLE_HINT_REFLOW, // PROP_HEIGHT 
  NS_STYLE_HINT_REFLOW, // PROP_LEFT 
  NS_STYLE_HINT_REFLOW, // PROP_LETTER_SPACING 
  NS_STYLE_HINT_REFLOW, // PROP_LINE_HEIGHT 
  NS_STYLE_HINT_REFLOW, // PROP_LIST_STYLE 
  NS_STYLE_HINT_REFLOW, // PROP_LIST_STYLE_IMAGE 
  NS_STYLE_HINT_REFLOW, // PROP_LIST_STYLE_POSITION 
  NS_STYLE_HINT_REFLOW, // PROP_LIST_STYLE_TYPE 
  NS_STYLE_HINT_REFLOW, // PROP_MARGIN 
  NS_STYLE_HINT_REFLOW, // PROP_MARGIN_BOTTOM 
  NS_STYLE_HINT_REFLOW, // PROP_MARGIN_LEFT 
  NS_STYLE_HINT_REFLOW, // PROP_MARGIN_RIGHT 
  NS_STYLE_HINT_REFLOW, // PROP_MARGIN_TOP 
  NS_STYLE_HINT_REFLOW, // PROP_MARKER_OFFSET
  NS_STYLE_HINT_VISUAL, // PROP_MARKS
  NS_STYLE_HINT_REFLOW, // PROP_MAX_HEIGHT
  NS_STYLE_HINT_REFLOW, // PROP_MAX_WIDTH
  NS_STYLE_HINT_REFLOW, // PROP_MIN_HEIGHT
  NS_STYLE_HINT_REFLOW, // PROP_MIN_WIDTH
  NS_STYLE_HINT_VISUAL, // PROP_OPACITY 
  NS_STYLE_HINT_REFLOW, // PROP_ORPHANS
  NS_STYLE_HINT_VISUAL, // PROP_OUTLINE
  NS_STYLE_HINT_VISUAL, // PROP_OUTLINE_COLOR
  NS_STYLE_HINT_VISUAL, // PROP_OUTLINE_STYLE
  NS_STYLE_HINT_VISUAL, // PROP_OUTLINE_WIDTH
  NS_STYLE_HINT_FRAMECHANGE, // PROP_OVERFLOW 
  NS_STYLE_HINT_REFLOW, // PROP_PADDING 
  NS_STYLE_HINT_REFLOW, // PROP_PADDING_BOTTOM 
  NS_STYLE_HINT_REFLOW, // PROP_PADDING_LEFT 
  NS_STYLE_HINT_REFLOW, // PROP_PADDING_RIGHT
  NS_STYLE_HINT_REFLOW, // PROP_PADDING_TOP 
  NS_STYLE_HINT_REFLOW, // PROP_PAGE
  NS_STYLE_HINT_REFLOW, // PROP_PAGE_BREAK_AFTER
  NS_STYLE_HINT_REFLOW, // PROP_PAGE_BREAK_BEFORE
  NS_STYLE_HINT_REFLOW, // PROP_PAGE_BREAK_INSIDE
  NS_STYLE_HINT_AURAL,  // PROP_PAUSE
  NS_STYLE_HINT_AURAL,  // PROP_PAUSE_AFTER
  NS_STYLE_HINT_AURAL,  // PROP_PAUSE_BEFORE
  NS_STYLE_HINT_AURAL,  // PROP_PITCH
  NS_STYLE_HINT_AURAL,  // PROP_PITCH_RANGE
  NS_STYLE_HINT_AURAL,  // PROP_PLAY_DURING
  NS_STYLE_HINT_AURAL,  // PROP_PLAY_DURING_FLAGS
  NS_STYLE_HINT_FRAMECHANGE, // PROP_POSITION 
  NS_STYLE_HINT_REFLOW, // PROP_QUOTES
  NS_STYLE_HINT_REFLOW, // PROP_QUOTES_CLOSE
  NS_STYLE_HINT_REFLOW, // PROP_QUOTES_OPEN
  NS_STYLE_HINT_AURAL,  // PROP_RICHNESS
  NS_STYLE_HINT_REFLOW, // PROP_RIGHT
  NS_STYLE_HINT_REFLOW, // PROP_SIZE
  NS_STYLE_HINT_REFLOW, // PROP_SIZE_HEIGHT
  NS_STYLE_HINT_REFLOW, // PROP_SIZE_WIDTH
  NS_STYLE_HINT_AURAL,  // PROP_SPEAK
  NS_STYLE_HINT_AURAL,  // PROP_SPEAK_HEADER
  NS_STYLE_HINT_AURAL,  // PROP_SPEAK_NUMERAL
  NS_STYLE_HINT_AURAL,  // PROP_SPEAK_PUNCTUATION
  NS_STYLE_HINT_AURAL,  // PROP_SPEECH_RATE
  NS_STYLE_HINT_AURAL,  // PROP_STRESS
  NS_STYLE_HINT_REFLOW, // PROP_TABLE_LAYOUT
  NS_STYLE_HINT_REFLOW, // PROP_TEXT_ALIGN 
  NS_STYLE_HINT_VISUAL, // PROP_TEXT_DECORATION 
  NS_STYLE_HINT_REFLOW, // PROP_TEXT_INDENT 
  NS_STYLE_HINT_VISUAL, // PROP_TEXT_SHADOW
  NS_STYLE_HINT_VISUAL, // PROP_TEXT_SHADOW_COLOR
  NS_STYLE_HINT_VISUAL, // PROP_TEXT_SHADOW_RADIUS
  NS_STYLE_HINT_VISUAL, // PROP_TEXT_SHADOW_X
  NS_STYLE_HINT_VISUAL, // PROP_TEXT_SHADOW_Y
  NS_STYLE_HINT_REFLOW, // PROP_TEXT_TRANSFORM 
  NS_STYLE_HINT_REFLOW, // PROP_TOP 
  NS_STYLE_HINT_REFLOW, // PROP_UNICODE_BIDI
  NS_STYLE_HINT_REFLOW, // PROP_VERTICAL_ALIGN 
  NS_STYLE_HINT_REFLOW, // PROP_VISIBILITY (for collapse)
  NS_STYLE_HINT_AURAL,  // PROP_VOICE_FAMILY
  NS_STYLE_HINT_AURAL,  // PROP_VOLUME
  NS_STYLE_HINT_REFLOW, // PROP_WHITE_SPACE 
  NS_STYLE_HINT_REFLOW, // PROP_WIDOWS
  NS_STYLE_HINT_REFLOW, // PROP_WIDTH 
  NS_STYLE_HINT_REFLOW, // PROP_WORD_SPACING 
  NS_STYLE_HINT_REFLOW  // PROP_Z_INDEX (XXX visual?)
};

