/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;

public class LDAPMatchingRuleSchema
extends LDAPAttributeSchema {
    private String[] attributes;

    public LDAPMatchingRuleSchema(String name, String oid, String description, String[] attributes, int syntax) {
        super(name, oid, description, syntax, true);
        this.attrName = "matchingrule";
        this.attributes = new String[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            this.attributes[i] = new String(attributes[i]);
            ++i;
        }
    }

    public LDAPMatchingRuleSchema(String raw, String use) {
        this.attrName = "matchingrule";
        this.oid = this.processRule(raw);
        String o = this.processRule(use);
        if (o != this.oid && o != null && this.oid != null) {
            System.err.println("Rule oid " + this.oid + " differs from use oid " + o);
        }
        if (this.oid == null) {
            this.oid = o;
        }
    }

    private String processRule(String raw) {
        if (raw == null) {
            return null;
        }
        raw.trim();
        int l = raw.length();
        raw = raw.substring(2, l - 1);
        l = raw.length();
        int ind = raw.indexOf(32);
        String o = raw.substring(0, ind);
        char[] ch = new char[l];
        raw = raw.substring(ind + 1, l);
        l = raw.length();
        raw.getChars(0, l, ch, 0);
        ind = 0;
        l = ch.length;
        while (ind < l) {
            String s = "";
            while (ch[ind] == ' ') {
                ++ind;
            }
            int last = ind + 1;
            while (last < l && ch[last] != ' ') {
                ++last;
            }
            if (ind < l && last < l) {
                s = new String(ch, ind, last - ind);
                ind = last;
            } else {
                ind = l;
            }
            while (ind < l && ch[ind] != '\'') {
                ++ind;
            }
            last = ind + 1;
            while (last < l && ch[last] != '\'') {
                ++last;
            }
            if (ind >= last || last >= l) continue;
            String val = new String(ch, ind + 1, last - ind - 1);
            ind = last + 1;
            if (s.equalsIgnoreCase("NAME")) {
                this.name = val;
                continue;
            }
            if (s.equalsIgnoreCase("DESC")) {
                this.description = val;
                continue;
            }
            if (s.equalsIgnoreCase("SYNTAX")) {
                this.syntax = this.syntaxCheck(val);
                continue;
            }
            if (!s.equalsIgnoreCase("APPLIES")) continue;
            Vector<String> v = new Vector<String>();
            while (last < l && ch[last] != ')') {
                ++last;
            }
            if (ind < last && last < l) {
                val = new String(ch, ind + 1, last - ind - 1);
                StringTokenizer st = new StringTokenizer(val, " ");
                while (st.hasMoreTokens()) {
                    String tok = st.nextToken();
                    if (tok.equals("$")) continue;
                    v.addElement(tok);
                }
            }
            this.attributes = new String[v.size()];
            int i = 0;
            while (i < v.size()) {
                this.attributes[i] = (String)v.elementAt(i);
                ++i;
            }
            v = null;
        }
        return o;
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    public String getValue() {
        String s = "( " + this.oid + " NAME '" + this.name + "' DESC '" + this.description + "' SYNTAX '";
        s = String.valueOf(s) + this.internalSyntaxToString();
        s = String.valueOf(s) + "' )";
        return s;
    }

    public String getUseValue() {
        String s = "( " + this.oid;
        s = String.valueOf(s) + " APPLIES ( ";
        int i = 0;
        while (i < this.attributes.length) {
            if (i > 0) {
                s = String.valueOf(s) + " $ ";
            }
            s = String.valueOf(s) + this.attributes[i];
            ++i;
        }
        s = String.valueOf(s) + ") )";
        return s;
    }

    protected void update(LDAPConnection ld, int op, String name) throws LDAPException {
        LDAPAttribute[] attrs = new LDAPAttribute[]{new LDAPAttribute("matchingRule", this.getValue()), new LDAPAttribute("matchingRuleUse", this.getUseValue())};
        this.update(ld, op, attrs);
    }

    public String toString() {
        String s = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        s = String.valueOf(s) + this.syntaxToString();
        s = String.valueOf(s) + "; Description: " + this.description + "; Applies to: ";
        int i = 0;
        while (i < this.attributes.length) {
            if (i > 0) {
                s = String.valueOf(s) + ", ";
            }
            s = String.valueOf(s) + this.attributes[i];
            ++i;
        }
        return s;
    }
}

