/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import netscape.util.DeserializationException;
import netscape.util.Hashtable;
import netscape.util.TokenGenerator;
import netscape.util.Vector;

public class Deserializer
extends FilterInputStream {
    private TokenGenerator tokenGenerator;

    public static Object readObject(InputStream inputStream) {
        Object object;
        try {
            Deserializer deserializer = new Deserializer(inputStream);
            object = deserializer.readObject();
        }
        catch (IOException iOException) {
            object = null;
        }
        catch (DeserializationException deserializationException) {
            object = null;
        }
        return object;
    }

    public Deserializer(InputStream inputStream) {
        super(inputStream);
        this.tokenGenerator = new TokenGenerator(inputStream);
    }

    public static Object deserializeObject(String serialization) {
        if (serialization == null) {
            return null;
        }
        StringBufferInputStream in = new StringBufferInputStream(serialization);
        return Deserializer.readObject(in);
    }

    public Object readObject() throws IOException, DeserializationException {
        return this.readObjectInternal();
    }

    private final Object readObjectInternal() throws IOException, DeserializationException {
        if (!this.tokenGenerator.hasMoreTokens()) {
            return null;
        }
        int token = this.tokenGenerator.nextToken();
        switch (token) {
            case 1: {
                return this.stringForToken();
            }
            case 2: {
                return this.readArray();
            }
            case 4: {
                return this.readVector();
            }
            case 6: {
                return this.readHashtable();
            }
        }
        this.syntaxError();
        return null;
    }

    private final void readKeyValuePair(Hashtable result) throws IOException, DeserializationException {
        Object value;
        int token;
        Object key = this.readObjectInternal();
        if (key == null) {
            this.unterminatedExpression();
        }
        if (!this.tokenGenerator.hasMoreTokens()) {
            this.unterminatedExpression();
        }
        if ((token = this.tokenGenerator.nextToken()) != 7) {
            this.syntaxError();
        }
        if (!this.tokenGenerator.hasMoreTokens()) {
            this.unterminatedExpression();
        }
        if ((value = this.readObjectInternal()) == null) {
            this.unterminatedExpression();
        }
        result.put(key, value);
        if (!this.tokenGenerator.hasMoreTokens()) {
            this.unterminatedExpression();
        }
        if ((token = this.tokenGenerator.peekNextToken()) == 8 || token == 10) {
            this.tokenGenerator.nextToken();
        }
    }

    private final Hashtable readHashtable() throws IOException, DeserializationException {
        Hashtable result = new Hashtable();
        while (true) {
            int token;
            if (!this.tokenGenerator.hasMoreTokens()) {
                this.unterminatedExpression();
            }
            if ((token = this.tokenGenerator.peekNextToken()) == 9) {
                this.tokenGenerator.nextToken();
                return result;
            }
            this.readKeyValuePair(result);
        }
    }

    private final Vector readVector() throws IOException, DeserializationException {
        Vector result = new Vector();
        boolean justAddedObject = false;
        while (true) {
            Object object;
            int token;
            if (!this.tokenGenerator.hasMoreTokens()) {
                this.unterminatedExpression();
            }
            if ((token = this.tokenGenerator.peekNextToken()) == 5) {
                this.tokenGenerator.nextToken();
                return result;
            }
            if (token == 10) {
                this.tokenGenerator.nextToken();
                if (justAddedObject) {
                    justAddedObject = false;
                } else {
                    this.syntaxError();
                }
            } else if (justAddedObject) {
                this.syntaxError();
            }
            if ((object = this.readObjectInternal()) == null) continue;
            result.addElement(object);
            justAddedObject = true;
        }
    }

    private final Object[] readArray() throws IOException, DeserializationException {
        Object[] buf = new Object[16];
        int bufIndex = 0;
        boolean justAddedObject = false;
        while (true) {
            Object obj;
            int nextToken;
            if (!this.tokenGenerator.hasMoreTokens()) {
                this.unterminatedExpression();
            }
            if ((nextToken = this.tokenGenerator.peekNextToken()) == 3) {
                this.tokenGenerator.nextToken();
                Object[] result = new Object[bufIndex];
                System.arraycopy(buf, 0, result, 0, bufIndex);
                return result;
            }
            if (nextToken == 10) {
                this.tokenGenerator.nextToken();
                if (justAddedObject) {
                    justAddedObject = false;
                } else {
                    this.syntaxError();
                }
            } else if (justAddedObject) {
                this.syntaxError();
            }
            nextToken = this.tokenGenerator.peekNextToken();
            if (nextToken == 11) {
                this.tokenGenerator.nextToken();
                obj = null;
            } else {
                obj = this.readObjectInternal();
            }
            buf[bufIndex++] = obj;
            if (bufIndex == buf.length) {
                Object[] newBuf = new Object[buf.length * 2];
                System.arraycopy(buf, 0, newBuf, 0, buf.length);
                buf = newBuf;
            }
            justAddedObject = true;
        }
    }

    private final String stringForToken() throws DeserializationException {
        byte[] str = this.tokenGenerator.bytesForLastToken();
        if (str == null || str.length == 0) {
            this.internalInconsistency("empty string");
        }
        if (str[0] == 34) {
            char[] charBuf = new char[32];
            int charBufIndex = 0;
            int i = 1;
            int c = str.length - 1;
            while (i < c) {
                byte b = str[i];
                if (b == 92) {
                    byte nextByte = 0;
                    int nextChar = 0;
                    if (++i < c) {
                        nextByte = str[i];
                    } else {
                        this.malformedString();
                    }
                    switch (nextByte) {
                        case 34: {
                            nextChar = (char)nextByte;
                            break;
                        }
                        case 116: {
                            nextChar = 9;
                            break;
                        }
                        case 110: {
                            nextChar = 10;
                            break;
                        }
                        case 114: {
                            nextChar = 13;
                            break;
                        }
                        case 92: {
                            nextChar = 92;
                            break;
                        }
                        case 117: {
                            byte one = 0;
                            byte two = 0;
                            byte three = 0;
                            byte four = 0;
                            if (++i < c) {
                                one = str[i];
                            } else {
                                this.malformedString();
                            }
                            if (++i < c) {
                                two = str[i];
                            } else {
                                this.malformedString();
                            }
                            if (++i < c) {
                                three = str[i];
                            } else {
                                this.malformedString();
                            }
                            if (++i < c) {
                                four = str[i];
                            } else {
                                this.malformedString();
                            }
                            if (this.isHexa(one) && this.isHexa(two) && this.isHexa(three) && this.isHexa(four)) {
                                nextChar = (char)(this.asciiToFourBits(one) << 12 | this.asciiToFourBits(two) << 8 | this.asciiToFourBits(three) << 4 | this.asciiToFourBits(four));
                                break;
                            }
                            this.malformedString();
                            break;
                        }
                        default: {
                            byte up = 0;
                            byte middle = 0;
                            byte low = 0;
                            up = nextByte;
                            if (++i < c) {
                                middle = str[i];
                            } else {
                                --i;
                            }
                            if (++i < c) {
                                low = str[i];
                            } else {
                                --i;
                            }
                            if (up >= 48 && up <= 55 && middle >= 48 && middle <= 55 && low >= 48 && low <= 55) {
                                nextChar = (char)(up - 48 << 6 | middle - 48 << 3 | low - 48);
                                break;
                            }
                            this.malformedString();
                        }
                    }
                    charBuf[charBufIndex++] = nextChar;
                    if (charBufIndex == charBuf.length) {
                        char[] newCharBuf = new char[charBuf.length * 2];
                        System.arraycopy(charBuf, 0, newCharBuf, 0, charBuf.length);
                        charBuf = newCharBuf;
                    }
                } else {
                    charBuf[charBufIndex++] = (char)b;
                    if (charBufIndex == charBuf.length) {
                        char[] newCharBuf = new char[charBuf.length * 2];
                        System.arraycopy(charBuf, 0, newCharBuf, 0, charBuf.length);
                        charBuf = newCharBuf;
                    }
                }
                ++i;
            }
            return new String(charBuf, 0, charBufIndex);
        }
        return new String(str, 0);
    }

    private final boolean isHexa(byte b) {
        return b >= 48 && b <= 57 || b >= 97 && b <= 102 || b >= 65 && b <= 70;
    }

    private final byte asciiToFourBits(byte b) {
        if (b >= 48 && b <= 57) {
            return (byte)(b - 48);
        }
        if (b >= 97 && b <= 102) {
            return (byte)(b - 97 + 10);
        }
        return (byte)(b - 65 + 10);
    }

    private void malformedString() throws DeserializationException {
        int line = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Malformed string at line " + line + ":" + new String(this.tokenGenerator.bytesForLastToken(), 0), line);
    }

    private void syntaxError() throws DeserializationException {
        int line = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Syntax error at line " + line, line);
    }

    private void internalInconsistency(String type) throws DeserializationException {
        int line = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Internal inconsistency exception. Please report this problem. " + type + " " + line, line);
    }

    private void unterminatedExpression() throws DeserializationException {
        int line = this.tokenGenerator.lineForLastToken();
        throw new DeserializationException("Unterminated expression at line " + line, line);
    }
}

