/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: NPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Netscape Public License
 * Version 1.1 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/NPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 1998
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   David Epstein <depstein@netscape.com>
 *   Dharma Sirnapalli <dsirnapalli@netscape.com>
 *	 Ashish Bhatt <ashishbhatt@netscape.com>
 *
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the NPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the NPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// File Overview....
//
// These are QA test case implementations
//

#include "stdafx.h"
#include "TestEmbed.h"
#include "BrowserImpl.h"
#include "BrowserFrm.h"
#include "UrlDialog.h"
#include "ProfileMgr.h"
#include "ProfilesDlg.h"
#include "Tests.h"
#include "nsihistory.h"
#include "nsiwebnav.h"
#include "nsirequest.h"
#include "nsidirserv.h"
#include "domwindow.h"
#include "selection.h"
#include "nsProfile.h"
#include "nsIClipboardCmd.h"
#include "nsIObserServ.h"
#include "nsIFile.h"
#include "nsIWebBrow.h"
#include "nsIWebProg.h"
#include "nsIWebBrowFind.h"
#include "QaUtils.h"
#include <stdio.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

nsresult rv;

// Register message for FindDialog communication
static UINT WM_FINDMSG = ::RegisterWindowMessage(FINDMSGSTRING);

BEGIN_MESSAGE_MAP(CTests, CWnd)
	//{{AFX_MSG_MAP(CTests)
	ON_COMMAND(ID_TESTS_CHANGEURL, OnTestsChangeUrl)
	ON_COMMAND(ID_TESTS_GLOBALHISTORY, OnTestsGlobalHistory)
	ON_COMMAND(ID_TESTS_CREATEFILE, OnTestsCreateFile)
	ON_COMMAND(ID_TESTS_CREATEPROFILE, OnTestsCreateprofile)
	ON_COMMAND(ID_TESTS_ADDWEBPROGLISTENER, OnTestsAddWebProgListener)
	ON_COMMAND(ID_TESTS_ADDHISTORYLISTENER, OnTestsAddHistoryListener)
	ON_COMMAND(ID_TESTS_REMOVEHISTORYLISTENER, OnTestsRemovehistorylistener)

	ON_COMMAND(ID_TOOLS_REMOVEGHPAGE, OnToolsRemoveGHPage)
	ON_COMMAND(ID_TOOLS_REMOVEALLGH, OnToolsRemoveAllGH)
	ON_COMMAND(ID_TOOLS_TESTYOURMETHOD, OnToolsTestYourMethod)
	ON_COMMAND(ID_TOOLS_TESTYOURMETHOD2, OnToolsTestYourMethod2)

	ON_COMMAND(ID_VERIFYBUGS_70228, OnVerifybugs70228)
	ON_COMMAND(ID_VERIFYBUGS_90195, OnVerifybugs90195)

	ON_COMMAND(ID_INTERFACES_NSIDIRECTORYSERVICE_INIT, OnInterfacesNsidirectoryservice)
	ON_COMMAND(ID_INTERFACES_NSIDIRECTORYSERVICE_REGISTERPROVIDER, OnInterfacesNsidirectoryservice)
	ON_COMMAND(ID_INTERFACES_NSIDIRECTORYSERVICE_RUNALLTESTS, OnInterfacesNsidirectoryservice)
	ON_COMMAND(ID_INTERFACES_NSIDIRECTORYSERVICE_UNREGISTERPROVIDER, OnInterfacesNsidirectoryservice)

	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_RUNALLTESTS, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETDOMDOCUMENT, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETFRAMES, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETNAME, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETPARENT, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETSCROLLBARS, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETSCROLLY, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETSCSOLLX, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETSELECTION, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_SCROLLBY, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_SCROLLBYLINES, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_SCROLLBYPAGES, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_SCROLLTO, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_SIZETOCONTENT, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_GETTEXTZOOM, OnInterfacesNsidomwindow)
	ON_COMMAND(ID_INTERFACES_NSIDOMWINDOW_SETTEXTZOOM, OnInterfacesNsidomwindow)

	ON_COMMAND(ID_INTERFACES_NSISELECTION_RUNALLTESTS, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETANCHORNODE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_ADDRANGE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_COLLAPSE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_COLLAPSETOEND, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_COLLAPSETOSTART, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_CONTAINSNODE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_DELETEFROMDOCUMENT, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_EXTEND, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETANCHOROFFSET, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETFOCUSNODE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETFOCUSOFFSET, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETISCOLLAPSED, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETRANGEAT, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_GETRANGECOUNT, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_REMOVEALLRANGES, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_REMOVERANGE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_SELECTALLCHILDREN, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_SELECTIONLANGUAGECHANGE, OnInterfacesNsiselection)
	ON_COMMAND(ID_INTERFACES_NSISELECTION_TOSTRING, OnInterfacesNsiselection)

	ON_COMMAND(ID_INTERFACES_NSIPROFILE_RUNALLTESTS, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_CLONEPROFILE, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_CREATENEWPROFILE, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_DELETEPROFILE, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_GETCURRENTPROFILE, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_GETPROFILECOUNT, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_GETPROFILELIST, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_PROFILEEXISTS, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_RENAMEPROFILE, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_SETCURRENTPROFILE, OnInterfacesNsiprofile)
	ON_COMMAND(ID_INTERFACES_NSIPROFILE_SHUTDOWNCURRENTPROFILE, OnInterfacesNsiprofile)

	ON_COMMAND(ID_INTERFACES_NSISHISTORY_GETCOUNT, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_GETENTRYATINDEX, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_GETINDEX, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_GETMAXLENGTH, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_GETSHISTORYENUMERATOR, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_PURGEHISTORY, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_RUNALLTESTS, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_SETMAXLENGTH, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_NSIHISTORYENTRY_GETISSUBFRAME, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_NSIHISTORYENTRY_GETTITLE, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_NSIHISTORYENTRY_GETURI, OnInterfacesNsishistory)
	ON_COMMAND(ID_INTERFACES_NSISHISTORY_NSIHISTORYENTRY_RUNALLTESTS, OnInterfacesNsishistory)

	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GETCANGOBACK, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GETCANGOFORWARD, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GETCURRENTURI, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GETDOCUMENT, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GETSESSIONHISTORY, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GOBACK, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GOFORWARD, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_GOTOINDEX, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_LOADURI, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_RELOAD, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_RUNALLTESTS, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_SETSESSIONHISTORY, OnInterfacesNsiwebnav)
	ON_COMMAND(ID_INTERFACES_NSIWEBNAV_STOP, OnInterfacesNsiwebnav)

	ON_COMMAND(ID_INTERFACES_NSIREQUEST_GETLOADFLAGS, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_GETLOADGROUP, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_GETNAME, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_GETSTATUS, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_ISPENDING, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_CANCEL, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_RESUME, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_SETLOADFLAGS, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_SETLOADGROUP, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_SUSPEND, OnInterfacesNsirequest)
	ON_COMMAND(ID_INTERFACES_NSIREQUEST_RUNALLTESTS, OnInterfacesNsirequest)

	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_CANCUTSELECTION, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_CANCOPYSELECTION, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_CANPASTE, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_COPYLINKLOCATION, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_COPYSELECTION, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_CUTSELECTION, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_PASTE, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_SELECTALL, OnInterfacesNsiclipboardcommands)
	ON_COMMAND(ID_INTERFACES_NSICLIPBOARDCOMMANDS_SELECTNONE, OnInterfacesNsiclipboardcommands)

	ON_COMMAND(ID_INTERFACES_NSIOBSERVERSERVICE_ADDOBSERVERS, OnInterfacesNsiobserverservice)
	ON_COMMAND(ID_INTERFACES_NSIOBSERVERSERVICE_ENUMERATEOBSERVERS, OnInterfacesNsiobserverservice)
	ON_COMMAND(ID_INTERFACES_NSIOBSERVERSERVICE_NOTIFYOBSERVERS, OnInterfacesNsiobserverservice)
	ON_COMMAND(ID_INTERFACES_NSIOBSERVERSERVICE_REMOVEOBSERVERS, OnInterfacesNsiobserverservice)
	ON_COMMAND(ID_INTERFACES_NSIOBSERVERSERVICE_RUNALLTESTS, OnInterfacesNsiobserverservice)

	ON_COMMAND(ID_INTERFACES_NSIFILE_APPENDRELATICEPATH, OnInterfacesNsifile)
	ON_COMMAND(ID_INTERFACES_NSIFILE_COPYTO, OnInterfacesNsifile)
	ON_COMMAND(ID_INTERFACES_NSIFILE_CREATE, OnInterfacesNsifile)
	ON_COMMAND(ID_INTERFACES_NSIFILE_EXISTS, OnInterfacesNsifile)
	ON_COMMAND(ID_INTERFACES_NSIFILE_INITWITHPATH, OnInterfacesNsifile)
	ON_COMMAND(ID_INTERFACES_NSIFILE_MOVETO, OnInterfacesNsifile)
	ON_COMMAND(ID_INTERFACES_NSIFILE_RUNALLTESTS, OnInterfacesNsifile)

	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_RUNALLTESTS, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_ADDWEBBROWSERLISTENER, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_REMOVEWEBBROWSERLISTENER, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_GETCONTAINERWINDOW, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_SETCONTAINERWINDOW, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_GETPARENTURICONTENTLISTENER, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_SETPARENTURICONTENTLISTENER, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_GETCONTENTDOMWINDOW, OnInterfacesNsiwebbrowser)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSER_NSIWBSETUPSETPROPERTY, OnInterfacesNsiwebbrowser)

	ON_COMMAND(ID_INTERFACES_NSIWEBPROGRESS_RUNALLTESTS, OnInterfacesNsiwebprogress)
	ON_COMMAND(ID_INTERFACES_NSIWEBPROGRESS_ADDPROGRESSLISTENER, OnInterfacesNsiwebprogress)
	ON_COMMAND(ID_INTERFACES_NSIWEBPROGRESS_REMOVEPROGRESSLISTENER, OnInterfacesNsiwebprogress)
	ON_COMMAND(ID_INTERFACES_NSIWEBPROGRESS_GETDOMWINDOW, OnInterfacesNsiwebprogress)

	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_RUNALLTESTS, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_SETSEARCHSTRINGTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_GETSEARCHSTRINGTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_FINDNEXTTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_SETFINDBACKWARDSTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_GETFINDBACKWARDSTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_SETWRAPFINDTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_GETWRAPFINDTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_SETENTIREWORDTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_GETENTIREWORDTEST, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_SETMATCHCASE, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_GETMATCHCASE, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_SETSEARCHFRAMES, OnInterfacesNsiwebbrowfind)
	ON_COMMAND(ID_INTERFACES_NSIWEBBROWSERFIND_GETSEARCHFRAMES, OnInterfacesNsiwebbrowfind)

	//}}AFX_MSG_MAP

END_MESSAGE_MAP()


CTests::CTests(nsIWebBrowser* mWebBrowser,
			   nsIBaseWindow* mBaseWindow,
			   nsIWebNavigation* mWebNav,
			   CBrowserImpl *mpBrowserImpl)
{
	qaWebBrowser = mWebBrowser;
	qaBaseWindow = mBaseWindow;
	qaWebNav = mWebNav;

	qaBrowserImpl = mpBrowserImpl;
}

CTests::~CTests()
{
}


// depstein: Start QA test cases here
// *********************************************************
// *********************************************************

void CTests::OnTestsChangeUrl()
{
	CUrlDialog myDialog;

	//nsresult rv;

	if (!qaWebNav)
	{
		QAOutput("Web navigation object not found. Change URL test not performed.", 2);
		return;
	}

	if (myDialog.DoModal() == IDOK)
	{
		QAOutput("Begin Change URL test.", 1);
		rv = qaWebNav->LoadURI(NS_ConvertASCIItoUCS2(myDialog.m_urlfield).get(),
								myDialog.m_flagvalue, nsnull,nsnull, nsnull);
	    RvTestResult(rv, "rv LoadURI() test", 1);
		FormatAndPrintOutput("The url = ", myDialog.m_urlfield, 2);
		FormatAndPrintOutput("The flag = ", myDialog.m_flagvalue, 1);
		QAOutput("End Change URL test.", 1);
	}
	else
		QAOutput("Change URL test not executed.", 1);

}

// *********************************************************

void CTests::OnTestsGlobalHistory()
{
	// create instance of myHistory object. Call's XPCOM
	// service manager to pass the contract ID.

	char *theUrl = "http://www.bogussite.com/";
	CUrlDialog myDialog;

	PRBool theRetVal = PR_FALSE;

	nsCOMPtr<nsIGlobalHistory> myHistory(do_GetService(NS_GLOBALHISTORY_CONTRACTID));

	if (!myHistory)
	{
		QAOutput("Couldn't find history object. No GH tests performed.", 2);
		return;
	}

	if (myDialog.DoModal() == IDOK)
	{
		QAOutput("Begin IsVisited() and AddPage() tests.", 2);

		strcpy(theUrl, myDialog.m_urlfield);

		FormatAndPrintOutput("The history url = ", theUrl, 1);

		// see if url is already in the GH file (pre-AddPage() test)
		rv = myHistory->IsVisited(theUrl, &theRetVal);
	    RvTestResult(rv, "rv IsVisited() test", 1);
		FormatAndPrintOutput("The IsVisited() boolean return value = ", theRetVal, 1);

		if (theRetVal)
			QAOutput("URL has been visited. Won't execute AddPage().", 2);
		else
		{
			QAOutput("URL hasn't been visited. Will execute AddPage().", 2);

			// adds a url to the global history file
			rv = myHistory->AddPage(theUrl);

			// prints addPage() results to output file
			if (NS_FAILED(rv))
			{
				QAOutput("Invalid results for AddPage(). Url not added. Test failed.", 1);
				return;
			}
			else
				QAOutput("Valid results for AddPage(). Url added. Test passed.", 1);

			// checks if url was visited (post-AddPage() test)
 			myHistory->IsVisited(theUrl, &theRetVal);

			if (theRetVal)
				QAOutput("URL is visited; post-AddPage() test. IsVisited() test passed.", 1);
			else
				QAOutput("URL isn't visited; post-AddPage() test. IsVisited() test failed.", 1);
		}
		QAOutput("End IsVisited() and AddPage() tests.", 2);
	}
	else
		QAOutput("IsVisited() and AddPage() tests not executed.", 1);
}


// *********************************************************

void CTests::OnTestsCreateFile()
{
   	//nsresult rv;
	PRBool exists;
    nsCOMPtr<nsILocalFile> theTestFile(do_GetService(NS_LOCAL_FILE_CONTRACTID));

    if (!theTestFile)
	{
		QAOutput("File object doesn't exist. No File tests performed.", 2);
		return;
	}


	QAOutput("Start Create File test.", 2);

	rv = theTestFile->InitWithNativePath(NS_LITERAL_CSTRING("c:\\temp\\theFile.txt"));
	rv = theTestFile->Exists(&exists);

	QAOutput("File (theFile.txt) doesn't exist. We'll create it.\r\n", 1);
	rv = theTestFile->Create(nsIFile::NORMAL_FILE_TYPE, 0777);
	RvTestResult(rv, "File Create() test", 2);
}

// *********************************************************

void CTests::OnTestsCreateprofile()
{
    CProfilesDlg    myDialog;
    nsresult        rv;

	if (myDialog.DoModal() == IDOK)
    {
//      NS_WITH_SERVICE(nsIProfile, profileService, NS_PROFILE_CONTRACTID, &rv);
		nsCOMPtr<nsIProfile> theProfServ(do_GetService(NS_PROFILE_CONTRACTID,&rv));
		if (NS_FAILED(rv))
		{
		   QAOutput("Didn't get profile service. No profile tests performed.", 2);
		   return;
		}

	   QAOutput("Start Profile switch test.", 2);

	   QAOutput("Retrieved profile service.", 2);
       rv = theProfServ->SetCurrentProfile(myDialog.m_SelectedProfile.get());
	   RvTestResult(rv, "SetCurrentProfile() (profile switching) test", 2);

	   QAOutput("End Profile switch test.", 2);
    }
	else
	   QAOutput("Profile switch test not executed.", 2);

}

// *********************************************************

void CTests::OnTestsAddWebProgListener()
{
    nsWeakPtr weakling(
        dont_AddRef(NS_GetWeakReference(NS_STATIC_CAST(nsIWebProgressListener*, qaBrowserImpl))));
    rv = qaWebBrowser->AddWebBrowserListener(weakling, NS_GET_IID(nsIWebProgressListener));

	RvTestResult(rv, "AddWebBrowserListener(). Add Web Prog Lstnr test", 2);
}

// *********************************************************

void CTests::OnTestsAddHistoryListener()
{
   // addSHistoryListener test
	nsWeakPtr weakling(
        dont_AddRef(NS_GetWeakReference(NS_STATIC_CAST(nsISHistoryListener*, qaBrowserImpl))));
	rv = qaWebBrowser->AddWebBrowserListener(weakling, NS_GET_IID(nsISHistoryListener));
	RvTestResult(rv, "AddWebBrowserListener(). Add History Lstnr test", 2);
}

void CTests::OnTestsRemovehistorylistener()
{
  // RemoveSHistoryListener test
	nsWeakPtr weakling(
        dont_AddRef(NS_GetWeakReference(NS_STATIC_CAST(nsISHistoryListener*, qaBrowserImpl))));
	rv = qaWebBrowser->RemoveWebBrowserListener(weakling, NS_GET_IID(nsISHistoryListener));
	RvTestResult(rv, "RemoveWebBrowserListener(). Remove History Lstnr test", 2);
}

// *********************************************************
// *********************************************************
//					TOOLS to help us


void CTests::OnToolsRemoveGHPage()
{
	char *theUrl = "http://www.bogussite.com/";
	CUrlDialog myDialog;
	PRBool theRetVal = PR_FALSE;
	//nsresult rv;
	nsCOMPtr<nsIGlobalHistory> myGHistory(do_GetService(NS_GLOBALHISTORY_CONTRACTID));
	if (!myGHistory)
	{
		QAOutput("Could not get the global history object.", 2);
		return;
	}
	nsCOMPtr<nsIBrowserHistory> myHistory = do_QueryInterface(myGHistory, &rv);
	if(NS_FAILED(rv)) {
		QAOutput("Could not get the history object.", 2);
		return;
	}

	if (myDialog.DoModal() == IDOK)
	{
		QAOutput("Begin URL removal from the GH file.", 2);
		strcpy(theUrl, myDialog.m_urlfield);

		myGHistory->IsVisited(theUrl, &theRetVal);
		if (theRetVal)
		{
			rv = myHistory->RemovePage(theUrl);
			RvTestResult(rv, "RemovePage() test (url removal from GH file)", 2);
		}
		else
		{
			QAOutput("The URL wasn't in the GH file.\r\n", 1);
		}
		QAOutput("End URL removal from the GH file.", 2);
	}
	else
		QAOutput("URL removal from the GH file not executed.", 2);
}

void CTests::OnToolsRemoveAllGH()
{

	nsCOMPtr<nsIGlobalHistory> myGHistory(do_GetService(NS_GLOBALHISTORY_CONTRACTID));
	if (!myGHistory)
	{
		QAOutput("Could not get the global history object.", 2);
		return;
	}
	nsCOMPtr<nsIBrowserHistory> myHistory = do_QueryInterface(myGHistory, &rv);
	if(NS_FAILED(rv)) {
		QAOutput("Could not get the history object.", 2);
		return;
	}

	QAOutput("Begin removal of all pages from the GH file.", 2);

	rv = myHistory->RemoveAllPages();
	RvTestResult(rv, "removeAllPages(). Test .", 2);

	QAOutput("End removal of all pages from the GH file.", 2);

}

// ***********************************************************************
void CTests::OnToolsTestYourMethod()
{
	// place your test code here

	// nsIWebBrowserFind methods
	nsCOMPtr<nsIWebBrowserFind> qaWBFind(do_GetInterface(qaWebBrowser, &rv));
	if (!qaWBFind)
		QAOutput("Didn't get WebBrowserFind object.", 2);
	else
		RvTestResult(rv, "nsIWebBrowserFind object test", 2);

	CUrlDialog myDialog;

	nsString searchString;
	PRBool didFind = PR_FALSE;
	PRBool didFindBackwards = PR_FALSE;
	PRBool didWrapFind = PR_FALSE;
	PRBool didEntireWord = PR_FALSE;
	PRBool didMatchCase = PR_FALSE;
	PRBool didSearchFrames = PR_FALSE;
	if (myDialog.DoModal() == IDOK) {

		// SetSearchString()
		searchString.AssignWithConversion(myDialog.m_urlfield);
		rv = qaWBFind->SetSearchString(searchString.get());
		RvTestResult(rv, "nsIWebBrowserFind::SetSearchString() test", 2);
	}
		// GetSearchString()
		nsXPIDLString stringBuf;
		CString csSearchStr;
		rv = qaWBFind->GetSearchString(getter_Copies(stringBuf));
		RvTestResult(rv, "nsIWebBrowserFind::GetSearchString() test", 2);
		csSearchStr = stringBuf.get();
		FormatAndPrintOutput("The searched string value = ", csSearchStr, 2);

	// FindNext()
	didFind = PR_TRUE;
	rv = qaWBFind->FindNext(&didFind);
	RvTestResult(rv, "nsIWebBrowserFind::FindNext(PR_TRUE) object test", 2);
	FormatAndPrintOutput("returned didFind = ", didFind, 2);

	didFind = PR_FALSE;
	rv = qaWBFind->FindNext(&didFind);
	RvTestResult(rv, "nsIWebBrowserFind::FindNext(PR_FALSE) object test", 2);
	FormatAndPrintOutput("returned didFind = ", didFind, 2);

	// SetFindBackwards()
	didFindBackwards = PR_TRUE;
	rv = qaWBFind->SetFindBackwards(didFindBackwards);
	RvTestResult(rv, "nsIWebBrowserFind::SetFindBackwards(PR_TRUE) object test", 2);

	didFindBackwards = PR_FALSE;
	rv = qaWBFind->SetFindBackwards(didFindBackwards);
	RvTestResult(rv, "nsIWebBrowserFind::SetFindBackwards(PR_FALSE) object test", 2);

	// GetFindBackwards()
	didFindBackwards = PR_TRUE;
	rv = qaWBFind->GetFindBackwards(&didFindBackwards);
	RvTestResult(rv, "nsIWebBrowserFind::GetFindBackwards(PR_TRUE) object test", 2);
	FormatAndPrintOutput("returned didFindBackwards = ", didFindBackwards, 2);

	didFindBackwards = PR_FALSE;
	rv = qaWBFind->GetFindBackwards(&didFindBackwards);
	RvTestResult(rv, "nsIWebBrowserFind::GetFindBackwards(PR_FALSE) object test", 2);
	FormatAndPrintOutput("returned didFindBackwards = ", didFindBackwards, 2);

	// SetWrapFind()
	didWrapFind = PR_TRUE;
	rv = qaWBFind->SetWrapFind(didWrapFind);
	RvTestResult(rv, "nsIWebBrowserFind::SetWrapFind(PR_TRUE) object test", 2);

	didWrapFind = PR_FALSE;
	rv = qaWBFind->SetWrapFind(didWrapFind);
	RvTestResult(rv, "nsIWebBrowserFind::SetWrapFind(PR_FALSE) object test", 2);

	// GetWrapFind()
	didWrapFind = PR_TRUE;
	rv = qaWBFind->GetWrapFind(&didWrapFind);
	RvTestResult(rv, "nsIWebBrowserFind::GetWrapFind(PR_TRUE) object test", 2);
	FormatAndPrintOutput("returned didWrapFind = ", didWrapFind, 2);

	didWrapFind = PR_FALSE;
	rv = qaWBFind->GetWrapFind(&didWrapFind);
	RvTestResult(rv, "nsIWebBrowserFind::GetWrapFind(PR_FALSE) object test", 2);
	FormatAndPrintOutput("returned didWrapFind = ", didWrapFind, 2);

	// SetEntireWord()
	didEntireWord = PR_TRUE;
	rv = qaWBFind->SetEntireWord(didEntireWord);
	RvTestResult(rv, "nsIWebBrowserFind::SetEntireWord(PR_TRUE) object test", 2);

	didEntireWord = PR_FALSE;
	rv = qaWBFind->SetEntireWord(didEntireWord);
	RvTestResult(rv, "nsIWebBrowserFind::SetEntireWord(PR_FALSE) object test", 2);

	// GetEntireWord()
	didEntireWord = PR_TRUE;
	rv = qaWBFind->GetEntireWord(&didEntireWord);
	RvTestResult(rv, "nsIWebBrowserFind::GetEntireWord(PR_TRUE) object test", 2);
	FormatAndPrintOutput("returned didEntireWord = ", didEntireWord, 2);

	didEntireWord = PR_FALSE;
	rv = qaWBFind->GetEntireWord(&didEntireWord);
	RvTestResult(rv, "nsIWebBrowserFind::GetEntireWord(PR_FALSE) object test", 2);
	FormatAndPrintOutput("returned didEntireWord = ", didEntireWord, 2);

	// SetMatchCase()
	didMatchCase = PR_TRUE;
	rv = qaWBFind->SetMatchCase(didMatchCase);
	RvTestResult(rv, "nsIWebBrowserFind::SetMatchCase(PR_TRUE) object test", 2);

	didMatchCase = PR_FALSE;
	rv = qaWBFind->SetMatchCase(didMatchCase);
	RvTestResult(rv, "nsIWebBrowserFind::SetMatchCase(PR_FALSE) object test", 2);

	// GetMatchCase()
	didMatchCase = PR_TRUE;
	rv = qaWBFind->GetMatchCase(&didMatchCase);
	RvTestResult(rv, "nsIWebBrowserFind::GetMatchCase(PR_TRUE) object test", 2);
	FormatAndPrintOutput("returned didMatchCase = ", didMatchCase, 2);

	didMatchCase = PR_FALSE;
	rv = qaWBFind->GetMatchCase(&didMatchCase);
	RvTestResult(rv, "nsIWebBrowserFind::GetMatchCase(PR_FALSE) object test", 2);
	FormatAndPrintOutput("returned didMatchCase = ", didMatchCase, 2);

	// SetSearchFrames()
	didSearchFrames = PR_TRUE;
	rv = qaWBFind->SetSearchFrames(didSearchFrames);
	RvTestResult(rv, "nsIWebBrowserFind::SetSearchFrames(PR_TRUE) object test", 2);

	didSearchFrames = PR_FALSE;
	rv = qaWBFind->SetSearchFrames(didSearchFrames);
	RvTestResult(rv, "nsIWebBrowserFind::SetSearchFrames(PR_FALSE) object test", 2);

	// GetSearchFrames()
	didSearchFrames = PR_TRUE;
	rv = qaWBFind->GetSearchFrames(&didSearchFrames);
	RvTestResult(rv, "nsIWebBrowserFind::GetSearchFrames(PR_TRUE) object test", 2);
	FormatAndPrintOutput("returned didSearchFrames = ", didSearchFrames, 2);

	didSearchFrames = PR_FALSE;
	rv = qaWBFind->GetSearchFrames(&didSearchFrames);
	RvTestResult(rv, "nsIWebBrowserFind::GetSearchFrames(PR_FALSE) object test", 2);
	FormatAndPrintOutput("returned didSearchFrames = ", didSearchFrames, 2);
}

// ***********************************************************************
void CTests::OnToolsTestYourMethod2()
{
	// place your test code here

	nsCAutoString theSpec;
	nsCOMPtr<nsIURI> theURI;
	nsCOMPtr<nsIChannel> theChannel;
	nsCOMPtr<nsILoadGroup> theLoadGroup(do_CreateInstance(NS_LOADGROUP_CONTRACTID));

	theSpec = "javascript:document.write('TEST')";
	FormatAndPrintOutput("the uri spec = ", theSpec, 2);

	rv = NS_NewURI(getter_AddRefs(theURI), theSpec);
	RvTestResult(rv, "NS_NewURI", 2);

	rv = NS_NewChannel(getter_AddRefs(theChannel), theURI, nsnull, theLoadGroup);
	RvTestResult(rv, "NS_OpenURI", 2);

	nsCOMPtr<nsIStreamListener> listener(NS_STATIC_CAST(nsIStreamListener*, qaBrowserImpl));
	nsCOMPtr<nsIWeakReference> thisListener(dont_AddRef(NS_GetWeakReference(listener)));
	qaWebBrowser->AddWebBrowserListener(thisListener, NS_GET_IID(nsIStreamListener));

	// this calls nsIStreamListener::OnDataAvailable()
	rv = theChannel->AsyncOpen(listener, nsnull);
	RvTestResult(rv, "AsyncOpen()", 2);

	nsCOMPtr<nsIRequest> theRequest = do_QueryInterface(theChannel);

	CNsIRequest::IsPendingReqTest(theRequest);
	CNsIRequest::GetStatusReqTest(theRequest);
	CNsIRequest::SuspendReqTest(theRequest);	
	CNsIRequest::ResumeReqTest(theRequest);	
	CNsIRequest::CancelReqTest(theRequest);	
	CNsIRequest::SetLoadGroupTest(theRequest, theLoadGroup);	
	CNsIRequest::GetLoadGroupTest(theRequest);

}

// ***********************************************************************
// ***************** Bug Verifications ******************
// ***********************************************************************

void CTests::OnVerifybugs70228()
{
	nsCOMPtr<nsIHelperAppLauncherDialog>
			myHALD(do_CreateInstance(NS_IHELPERAPPLAUNCHERDLG_CONTRACTID));
	if (!myHALD)
		QAOutput("Object not created. It should be. It's a component!", 2);
	else
		QAOutput("Object is created. It's a component!", 2);

/*
nsCOMPtr<nsIHelperAppLauncher>
			myHAL(do_CreateInstance(NS_IHELPERAPPLAUNCHERDLG_CONTRACTID));

	rv = myHALD->show(myHal, nsnull);
*/
}

BOOL CTests::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo)
{
   // To handle Menu handlers add here. Don't have to do if not handling
   // menu handlers
	nCommandID = nID ;

	return CWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CTests::OnInterfacesNsirequest()
{
	CNsIRequest oNsIRequest(qaWebBrowser,/*qaBaseWindow,qaWebNav,*/ qaBrowserImpl);
	oNsIRequest.OnStartTests(nCommandID);
}

void CTests::OnInterfacesNsidirectoryservice()
{
	CNsIDirectoryService oNsIDirectoryService;
	oNsIDirectoryService.StartTests(nCommandID);
}

void CTests::OnInterfacesNsidomwindow()
{
	CDomWindow oDomWindow(qaWebBrowser) ;
	oDomWindow.OnStartTests(nCommandID);
}

void CTests::OnInterfacesNsiselection()
{
	CSelection oSelection(qaWebBrowser);
	oSelection.OnStartTests(nCommandID);
}

void CTests::OnVerifybugs90195()
{
    nsWeakPtr weakling(
        dont_AddRef(NS_GetWeakReference(NS_STATIC_CAST(nsITooltipListener*, qaBrowserImpl))));
    rv = qaWebBrowser->AddWebBrowserListener(weakling, NS_GET_IID(nsITooltipListener));

	RvTestResult(rv, "AddWebBrowserListener(). Add Tool Tip Lstnr test", 2);

/*	nsCOMPtr<nsITooltipTextProvider> oTooltipTextProvider = do_GetService(NS_TOOLTIPTEXTPROVIDER_CONTRACTID) ;
	if (!oTooltipTextProvider)
		AfxMEssageBox("Asdfadf");
*/
}

void CTests::OnInterfacesNsiprofile()
{
	CProfile oProfile(qaWebBrowser);
	oProfile.OnStartTests(nCommandID);
}

void CTests::OnInterfacesNsishistory()
{
	CNsIHistory oHistory(qaWebNav);
	oHistory.OnStartTests(nCommandID);
}


void CTests::OnInterfacesNsiwebnav()
{
	CNsIWebNav oWebNav(qaWebNav);
	oWebNav.OnStartTests(nCommandID);
}


void CTests::OnInterfacesNsiclipboardcommands()
{
	CNsIClipBoardCmd  oClipCmd(qaWebBrowser) ;
	oClipCmd.OnStartTests(nCommandID);
}


void CTests::OnInterfacesNsiobserverservice()
{
	CnsIObserServ oObserv  ;
	oObserv.OnStartTests(nCommandID);
}


void CTests::OnInterfacesNsifile()
{
	CNsIFile oFile ;
	oFile.OnStartTests(nCommandID);
}

void CTests::OnInterfacesNsiwebbrowser()
{
	CNsIWebBrowser oWebBrowser(qaWebBrowser, qaBrowserImpl);
	oWebBrowser.OnStartTests(nCommandID);
}

void CTests::OnInterfacesNsiwebprogress()
{
	CnsiWebProg oWebProgress(qaWebBrowser, qaBrowserImpl);
	oWebProgress.OnStartTests(nCommandID);
}

void CTests::OnInterfacesNsiwebbrowfind()
{
	CNsIWebBrowFind oWebBrowFind(qaWebBrowser, qaBrowserImpl);
	oWebBrowFind.OnStartTests(nCommandID);
}