//string with all supported sizes 
const defaultSizes = "468;60;234;60;120;60;336;280;338;282;728;105;728;90;500;62;184;90;160;600;160;60;150;70;140;800;120;800;120;600;0;0;";
//string with the on/off flags for all the sizes (the first value is the global on/off if it is 0 then bannerblind is disabled)
const defaultFlags = "1;1;1;1;0;0;0;0;0;0;0;0;0;0;0;0;0;";

// function that modifies the UI based on the perferences
function loadConfig(){
	try{//try to get the config from mozilla preferences
		var pref = Components.classes["@mozilla.org/preferences;1"].getService(Components.interfaces.nsIPref);
		bannerSizes = pref.GetCharPref("bannerblind.sizes");
		bannerFlags = pref.GetCharPref("bannerblind.flags");
		bannerVoid = pref.GetBoolPref("bannerblind.void");
	}catch (error){//if cannot access the prefs then use the default values
		bannerSizes = defaultSizes; 
		bannerFlags = defaultFlags;
		bannerVoid = true;
	}
	var bannersizeArray = bannerSizes.split(";"); //array with all the supported bannersizes
	var sizeenabled	= bannerFlags.split(";"); //array with the on/off table
	var cbcontainer	= document.getElementById("checkbox-container");//the element that stores the checkboxes
	var cbindex=1;//index variable for the checkboxes
	var cbchecked ="";//if the checkbox is checked or not
	var onoff = document.getElementById("bannerblind-on");
	if(sizeenabled[0]=="1"){
		onoff.setAttribute("checked","true");
	}else{
		onoff.setAttribute("checked","false");
	}
	for (var i=0;i<bannersizeArray.length-1;i+=2){
		if(sizeenabled[cbindex]=="1"){
			cbchecked = "true";
		}else{
			cbchecked="false";
		}
		addSize(bannersizeArray[i],bannersizeArray[i+1],cbchecked);
		cbindex++;
	}
	var voidon = document.getElementById("bannervoid-on");
	var voidoff = document.getElementById("bannervoid-off");
	voidon.setAttribute("oncommand","removeOn();");
	voidoff.setAttribute("oncommand","hideOn();");
	if (bannerVoid)	{
		//old mozillas
		voidon.setAttribute("checked","true");
		voidoff.setAttribute("checked","false");
		//mozillas post 0.9.7
		voidon.setAttribute("selected","true");
		voidoff.removeAttribute("selected");
	}
	else {
		//old mozillas
		voidoff.setAttribute("checked","true");
		voidon.setAttribute("checked","false");
		//mozillas post 0.9.7
		voidoff.setAttribute("selected","true");
		voidon.removeAttribute("selected");
	}
}
function addSize(width,height,flag){
	
	if((width==undefined)&&(height==undefined)){ //when the function is called without parameters it's an user input
		var width = document.getElementById("newwidth").value;
		var height = document.getElementById("newheight").value;
		var flag = "true";
	}
	width = parseInt(width);
	height= parseInt(height);
	
	if((width >= 0)&&(height >=0)){//the sizes are numbers
		if(document.getElementById("li-"+width+"x"+height)==undefined){//check if this size already exists
			var lb = document.getElementById("sizes-list"); //the listbox that contains the sizes
			var listitemnode = document.createElement("listitem");
			var label = width+"x"+height;

			var cbcontainer	= document.getElementById("checkbox-container");
			var checkboxnode = document.createElement("checkbox");
			
			listitemnode.setAttribute("id",	"li-"+label); 
			listitemnode.setAttribute("label",label);
			lb.appendChild(listitemnode);
	
			checkboxnode.setAttribute("id",	"cb-"+label); 
			checkboxnode.setAttribute("label", label); 
			checkboxnode.setAttribute("checked", flag); 
			//checkboxnode.setAttribute("autocheck", "false"); 
			//checkboxnode.setAttribute("oncommand", "checkClicked(\"cb-"+label+"\")"); 

			var power = document.getElementById("bannerblind-on").getAttribute("checked");
			if(power=="true"){//bannerblind	is on
				checkboxnode.removeAttribute("disabled");
			}else{
				checkboxnode.setAttribute("disabled","true");
			}
			cbcontainer.appendChild(checkboxnode);
		}else{
			alert("Those dimensions	already	exist.");
		}
	}else{
		alert("Only integer sizes are allowed.");
	}
}

function powerOnOff(){
	var power = document.getElementById("bannerblind-on").getAttribute("checked");
	var cbcontainer	= document.getElementById("checkbox-container");
	if(power=="true"){//bannerblind	ligado
		for(var	i=0; i<cbcontainer.childNodes.length;i++){
			cbcontainer.childNodes[i].removeAttribute("disabled");
		}	
	}else{
		for(var	i=0; i<cbcontainer.childNodes.length;i++){
			cbcontainer.childNodes[i].setAttribute("disabled","true");
		}	
	}
}


function removeSizes(){
	var lb = document.getElementById("sizes-list"); //the listbox that contains the sizes
	var cbcontainer	= document.getElementById("checkbox-container");
	var items=lb.selectedItems;
	if (items.length==0) alert("No items are selected.");
	else {
		for (t=items.length-1;t>=0;t--){//it must remove backwards because the selection array changes his length when you remove a listitem
			var listitem=items[t];
			lb.removeChild(listitem);
			var checkboxid="cb-"+listitem.id.substring(3,listitem.id.length);
			var cb = document.getElementById(checkboxid);
			cbcontainer.removeChild(cb);
		}
	}
}

function commitChanges(){
	var bannerSizes="";
	var bannerFlags="";
	var cbcontainer	= document.getElementById("checkbox-container");

	if(document.getElementById("bannerblind-on").getAttribute("checked")=="true"){
		bannerFlags += "1;";
	}else{
		bannerFlags += "0;";
	}

	for (var i=0; i<cbcontainer.childNodes.length;i++){
		if(cbcontainer.childNodes[i].label.length>2){
			bannerSizes += cbcontainer.childNodes[i].label.substring(0,cbcontainer.childNodes[i].label.indexOf("x"))+";";
			bannerSizes += cbcontainer.childNodes[i].label.substring(cbcontainer.childNodes[i].label.indexOf("x")+1,cbcontainer.childNodes[i].label.length)+";";
			if(cbcontainer.childNodes[i].getAttribute("checked")=="true"){
				bannerFlags += "1;";
			}else{
				bannerFlags += "0;";
			}
		}
	}
	var pref = Components.classes["@mozilla.org/preferences;1"].getService(Components.interfaces.nsIPref);
	pref.SetCharPref("bannerblind.sizes",bannerSizes);
	pref.SetCharPref("bannerblind.flags",bannerFlags);
	pref.SetBoolPref("bannerblind.void", bannerVoid);
	closeWindow();
}

function removeOn(){
	bannerVoid = true;
}
function hideOn(){
	bannerVoid = false;
}
function checkClicked(id){
	alert(document.getElementById(id).getAttribute("checked"));
} 

function restoreDefaults(){
	var pref = Components.classes["@mozilla.org/preferences;1"].getService(Components.interfaces.nsIPref);
	pref.SetCharPref("bannerblind.sizes",defaultSizes);
	pref.SetCharPref("bannerblind.flags",defaultFlags);
	pref.SetBoolPref("bannerblind.void", true);
	closeWindow();
}

function closeWindow(){
	window.close();
} 