/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com> 
 *  Ben Williams <benw@webmedia.com.au>
 *  Jeremy Wrinkle (Exotrip)        FIXME  email
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie                         FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME  email
 *  Squarefree.com                  FIXME who exactly: whole name, email
 *  David Illsley <illsleydc@bigfoot.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

// preferences root branch
var prefRoot = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService).getBranch("");

function initGestureTable() {
  // *** navigational gestures (& related) ***
  addGesture("L", "g.BrowserBack", "BrowserBack();");
  addGesture("R", "g.BrowserForward", "BrowserForward();");
  addGesture("UD", "g.BrowserReload", "BrowserReload();");
  addGesture("UDU", "g.BrowserReloadSkipCache", "BrowserReloadSkipCache();");
  addGesture("LU", "g.BrowserStop", "BrowserStop();");
  addGesture("DURD", "g.BrowserHome", "BrowserHome();");
  addGesture("RDU", "g.scrollDown", "window._content.scrollBy(0,200);");
  addGesture("RUD", "g.scrollUp", "window._content.scrollBy(0,-200);");
  addGesture("D", "g.openNewDocument", "openNewDocument();");
  addGesture("DU", "g.duplicateWindow", "duplicateWindow()");
  addGesture("ULU", "g.upDir", "upDir();");
  // *** tab gestures ***
  addGesture("U", "g.BrowserOpenTab", "if(globalOnLink) linkInTab(globalOnLink[0]); else BrowserOpenTab();");
  addGesture("DUD", "g.duplicateTab", "linkInTab(window._content.document.location);");
  addGesture("UR", "g.nextTab", "getBrowser().mTabBox._tabs.advanceSelectedTab(+1);");
  addGesture("UL", "g.previousTab", "getBrowser().mTabBox._tabs.advanceSelectedTab(-1);");
  // *** window manipulation (minimize etc.)
  addGesture("RU", "g.restMaxWin", "restMaxWin();");
  addGesture("DL", "g.minWin", "minWin();");
  addGesture("RLR", "g.closeDoc", "BrowserCloseTabOrWindow();");
  addGesture("DR", "g.closeDoc", "BrowserCloseTabOrWindow();");
  // *** misc *** 
  addGesture("URD", "g.viewFrameSource", "BrowserViewSourceOfDocument(globalSrcEvent.target.ownerDocument);");
  addGesture("LDRDL", "g.viewFrameSource", "BrowserViewSourceOfDocument(globalSrcEvent.target.ownerDocument);"); //Squarish "S"
  addGesture("LDR", "g.viewSiteCookies", "viewSiteCookies();");
  addGesture("URDURD", "g.metaInfo", "metaInfo();");
  addGesture("RLDUR", "g.explodeBackground", "explodeBackground();");
  addGesture("DRDLU", "g.addBookmark", "addBookmarkAs();");
  // *** link drag over gestures ***
  addGesture("RUDR", "g.doubleStackWin", "doubleStackWin();");
  // Diagonals stuff
  addGesture("3", "g.doubleImageSize", "setImageSize(2);");
  addGesture("7", "g.halveImageSize", "setImageSize(.5);");
  addGesture("1", "g.hideImage", "setImageSize(0);");
  addGesture("39", "g.w3cValidate", "w3cValidate();");
  // globalOnLink stuff
  addGesture("+RU", "g.linksInWindows", "linksInWindows();");
  addGesture("+RUL", "g.linksInTabs", "linksInTabs();");
}

function setImageSize(aSize)
{
  if(globalOnImage) {
    globalOnImage.width = globalOnImage.width * aSize;
    globalOnImage.height = globalOnImage.height * aSize;
  }
}

function linkInTab(url){
  var browser = getBrowser();
  var tab = browser.addTab(url, getReferrer(document));
  if (!prefRoot.getBoolPref("browser.tabs.loadInBackground"))
    browser.selectedTab = tab;
}

function linksInTabs(){
  var browser = getBrowser();
  for(i = 0; i < globalOnLink.length; i++) {
    tab = browser.addTab(globalOnLink[i], getReferrer(document));
  }
}

function linksInWindows(){
  for(i = 0; i < globalOnLink.length; i++) {
    tempW = openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no",
              globalOnLink[i], null, true, getReferrer(document) );
  }
}

function openNewDocument(){
  var tempW;
    if(globalOnImage) {     // Open image in new window
      tempW = window.open(globalOnImage);
    }  
    else {
      if(!globalOnLink) { // open new browser window  
        var uriToLoad = "";
        if (prefRoot.getIntPref("browser.startup.page") == 1)
          uriToLoad = getHomePage();
        tempW = openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no",
                  uriToLoad, null, true, getReferrer(document) );
      }
      else { // open link in new window 
        tempW = openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no",
                  globalOnLink[0], null, true, getReferrer(document) );} 
    }
}

function duplicateWindow(){
 openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no",
           window._content.document.location, null, true, getReferrer(document));
}

function upDir(){ //from bookmarklets.com
  var aUrl = window._content.document.location.href;
  if (window._content.document.location.protocol != "about:")
    aUrl = aUrl.substring(0, aUrl.substring(0, aUrl.length-1).lastIndexOf('/')+1);
    window._content.document.location.href = aUrl;
}

function restMaxWin(){
  if(window.maximize != 'undefined') {
   if (window.windowState == STATE_MAXIMIZED)
     window.restore();
   else window.maximize();
  }
}

function minWin(){
  if(window.minimize != 'undefined') {
    window.minimize();
  }
}

function viewSiteCookies(){ //Contributed by Squarefree.com
  if (window._content.document.cookie)
    alert(bundle.getString("cookies") + "\n\n"
      + window._content.document.cookie.replace(/; /g,"\n"));
  else alert(bundle.getString("noCookies"));
}

function metaInfo(){
  var metas = window._content.document.getElementsByTagName("meta");
  if (metas.length != 0){
    var metastr = bundle.getString("meta") + "\n\n";
    for(var ameta = 0; ameta < metas.length; ameta++) {
      var mymeta = metas.item(ameta);
      metastr += "<META ";
      if (mymeta.name) metastr += "name=\"" + mymeta.name + "\" ";
      if (mymeta.httpEquiv) metastr+= "http-equiv=\"" + mymeta.httpEquiv + "\" ";
      if (mymeta.content) metastr += "content=\"" + mymeta.content + "\" ";
      if (mymeta.scheme) metastr += "scheme=\"" + mymeta.scheme + "\" ";
      metastr += '>\n';
    }
    alert(metastr);
  }
  else alert(bundle.getString("noMeta"));
}

function explodeBackground(){
  myBod = window._content.document.body;
    myBod.background='http://www.surfmind.com/images/explode.gif';
    myBod.setAttribute("style", "background:url(http://www.surfmind.com/images/explode.gif)");
}

function doubleStackWin(){
  var tempW;
  if(globalOnLink) { 
    window.moveTo(0,0);
    window.resizeTo(screen.availWidth/2, screen.availHeight);
    tempW = openDialog(getBrowserURL(), "_blank", "chrome,all,dialog=no",
              globalOnLink[0], null, true, getReferrer(document) );
    tempW.moveTo(screen.availWidth/2 + 1, 0);
    tempW.resizeTo(screen.availWidth/2,screen.availHeight);
  }
}

function w3cValidate() {
window._content.document.location='http://validator.w3.org/check?uri='+window._content.document.location;
}