/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Andy Edmonds <aedmonds@mindspring.com> 
 *  Ben Williams <benw@webmedia.com.au>
 *  David Illsley <illsleydc@bigfoot.com>
 *  Jeremy Wrinkle (Exotrip)        FIXME  email
 *  Pavol Vaskovic <pali@pali.sk>
 *  Scurrie            FIXME whole name, email
 *  Steve Kangas <bookmarklets.com> FIXME  email
 *  Squarefree.com     FIXME who exactly: whole name, email
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

/**
    U      Function processCoordinates returns in global variable 'gesture' 
    |      list of 4-directional movements made in gesture. Function fireGesture 
R---x---L  takes compacted 4dir chain code and fires the desired action.
    |      Ex. "DL" means that user has moved mouse down, then left
    D          "LRL" was gesture right-left-right etc.
 globalOnLink is an array that holds a list of all the links traversed during
 the active gesture.  It's defined in mozgestOverlay.js.
*/

var gesturesTable = new Array();

/* This function attampt to fire the gesture, initially with the unmodified
   gesture it has been passed. If that fails, it fires the case with an onLink
   where the ending of the gesture matches a specific pattern. If those fail,
   then the gestire is processed to see if it is a diagonal. If so, the gesture
   is modified to another form and we attampt to fire that gesture. */
function fireGesture(aGesture){
  if(!fireGestureFromTable(aGesture))
    if(!firstLookupFailed())
      if(!fireGestureFromTable(processDiagonal(aGesture))){
        window.status = bundle.getString("g.unknown") + " " + aGesture;
        dump("MozGest: Unknown Gesture: " + aGesture + "\n");
        disableContextMenu = false;
      }
  setTimeout("window.status=''", 1500);  // clear our message
}

function fireGestureFromTable(aGesture){
  if(gesturesTable[aGesture]!=null){
    eval(gesturesTable[aGesture][1]);
    dump("MozGest: "+gesturesTable[aGesture][0]+ "\n");
    window.status=gesturesTable[aGesture][0];
    return true;
  }
  else{ 
    return false;
  }
}
 
function firstLookupFailed(){
    if(globalOnLink) {
      lastgesture = gesture.join("");
      var twoStroke = lastgesture.substr(lastgesture.length-2,2);
      var threeStroke = lastgesture.substr(lastgesture.length-3,3);
      dump("MozGest: Multiple link spawn: " + lastgesture
        + ' spotted... \n  ...Looking for Finishing Move\n');
      if(!fireGestureFromTable("+"+twoStroke))
        return fireGestureFromTable("+"+threeStroke);
      else return true;
    }
    return false;
}

/*
7   U   9  This part adds the second pass analyzer for diagonal gestures. 
  \ | /    It is launched after the normal recognizer, when there is no match. 
R---x---L  Diagonals are coded as shown on the picture.
  / | \    Returns true if it has recognized something. Otherwise false.    
1   D   3   */
      
function processDiagonal(gesture) {
  var gestureMod;
  dump("MozGest: Recognizer 2nd pass: \n" );
  dump("MozGest: Org Diag " + gesture + " \n");
  var diag9 = new RegExp("U?RU(RU)*R?");
  var diag7 = new RegExp("U?LU(LU)*L?");
  var diag3 = new RegExp("D?RD(RD)*R?");
  var diag1 = new RegExp("D?LD(LD)*L?");
  
  gestureMod = gesture.replace(diag1, "1");
  gestureMod = gestureMod.replace(diag3, "3");
  gestureMod = gestureMod.replace(diag7, "7");
  gestureMod = gestureMod.replace(diag9, "9");
  dump("MozGest: Mod Gesture " + gestureMod + "\n");

  if(gesture == gestureMod) {
    // filter weak diagonals
    dump("MozGest:  2nd pass: false (weak)\n");
    return "";
  } 
  else return gestureMod;  
}

function addGesture(gestCode, descString, evalCode){
  gesturesTable[gestCode] = new Array(bundle.getString(descString), evalCode);
}
