/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is Mouse Gesture for Mozilla.
 *
 * The Initial Developer of the Original Code is Pavol Vaskovic.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Chase Tingley <tingley@sundell.net>
 *  David Perry <d.perry@utoronto.ca>
 *  Pavol Vaskovic <pali@pali.sk>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */


// semaphore for synchronizig with RDF changes, so that we do not shut down
// sooner then everything is safely written to disk
var semaphore = 4; // there will be 4 async operations
var timerID;
var bundle, mozgestRemoved, dirNotDeleted;
 
function showWebPage(pageUrl) {
  //check for an existing browser window
  const kWindowMediatorContractID = "@mozilla.org/rdf/datasource;1?name=window-mediator";
  const kWindowMediatorIID = Components.interfaces.nsIWindowMediator;
  const kWindowMediator = Components.classes[kWindowMediatorContractID].getService(kWindowMediatorIID);
  var browserWindow = kWindowMediator.getMostRecentWindow("navigator:browser");
  if (browserWindow) {
    try {
      browserWindow.delayedOpenTab(pageUrl);
    }
    catch(e) {
      browserWindow.loadURI(pageUrl);
    }
  }
  else {
    window.open(pageUrl);
  }
}

function confirmUninstall(){
  // initialize strings first
  document.getElementById('mozgestbundle');
  bundle = document.getElementById("mozgestbundle");
  mozgestRemoved = bundle.getString("mozgestRemoved");
  dirNotDeleted = bundle.getFormattedString("dirNotDeleted", ["'mozgest'"], 1);

  // ask user if he really wants it
  if (confirm(bundle.getString("uninstallWarning")))
    mozgestUninstall();
}

function mozgestUninstall(){
  dump("MozGest: mozgestUninstall\n");
/*// this is 'correct' way to uninstall, modified from skin uninstallation code
  // untill .uninstallPackage gets implemented (bug XXXXX) - we'll HACK for now 
  const DEBUG_USE_PROFILE = true; //?
  try {
    var chromeRegistry = Components.classes["@mozilla.org/chrome/chrome-registry;1"].getService();
    if (chromeRegistry)
      chromeRegistry = chromeRegistry.QueryInterface( Components.interfaces.nsIChromeRegistry );
  }
  catch(e) {}
  chromeRegistry.uninstallPackage("mozgest", DEBUG_USE_PROFILE);
*/

// *****************************************************************************
// *************** everything below is HACK!!! *********************************
// *****************************************************************************
  
  // remove all references to our package from various rdf files, we also delete 
  // 'mozgest' directory in this function, because chromeDir is defined in there
  removePackageReferences(); 

  // remove MozGest preferences
  var pref = Components.classes["@mozilla.org/preferences-service;1"].getService(Components.interfaces.nsIPrefService);
  var rootBranch = pref.getBranch("");
  rootBranch.deleteBranch("mozgest");

  // shut down mozilla, that's the only way to get rid of our own overlays
  // running, which would try to read preferences etc...

  timerID = setInterval("if (semaphore == 0) { clearInterval(timerID); alert(mozgestRemoved); goQuitApplication();};",500);
}

function removePackageReferences(){
  dump("MozGest: removePackageReferences\n");
  /////////////////////////////////////////////////////////////////////////
  // This is a sketchy, sketchy way to do it.  But since actual support for
  // loading chrome.rdf via a resource channel seems to be far away, 
  // I'll do this the way that the chrome registry does: 
  // THROUGH FORCE OF WILL ALONE.

  // Basically, load the directory service and look up the key "AChrom"
  // (see NS_APP_CHROME_DIR in nsAppDirectoryServiceDefs.h).  This gives
  // us an nsIFile for the chrome directory, from which the url is easily
  // extracted...

  // nsAppDirectoryServiceDefs.h contains many other useful magic words for
  // finding other places (prefs, profile, etc).

  const kDirServiceCID = Components.ID("{f00152d0-b40b-11d3-8c9c-000064657374}");
  const nsIProperties = Components.interfaces.nsIProperties;
  const nsIFileIID = Components.ID("{c8c0a080-0868-11d3-915f-d9d889d48e3c}");
  const magicChromeKey = "AChrom";

  var dirService = Components.classesByID[kDirServiceCID].getService(nsIProperties);

  var chromeDir = dirService.get(magicChromeKey, nsIFileIID);

  // chromeUrl is the file:// url of the chrome directory, eg
  // file:///home/tingley/src/mozilla/dist/bin/chrome/
  var chromeUrl = "file:///" + chromeDir.path + "/";
  dump("\tchrome url is "+chromeUrl+"\n");
  
  // remove our references from chrome/chrome.rdf
  dump("Attempting to load "+chromeUrl+"chrome.rdf\n");
  RDFU.loadDataSource(chromeUrl + "chrome.rdf", removeFromChrome);

  // let's remove our overlays (these were installed from our contents.rdf)
  var overlay1 = new overlayRemover(chromeUrl + 
                 "overlayinfo/communicator/content/overlays.rdf",
                 "chrome://communicator/content/pref/preftree.xul",
                 "chrome://mozgest/content/pref/mozgestPrefOverlay.xul");
  overlay1.remove();

  var overlay2 = new overlayRemover(chromeUrl + 
                 "overlayinfo/navigator/content/overlays.rdf",
                 "chrome://navigator/content/navigator.xul",
                 "chrome://mozgest/content/mozgestOverlay.xul");
  overlay2.remove();

  // delete mozgest directory
  var ios = Components.classes["@mozilla.org/network/io-service;1"].getService(Components.interfaces['nsIIOService']);
  var fileUri = ios.newURI(chromeUrl + "mozgest", null, null);
  fileUri = fileUri.QueryInterface(Components.interfaces.nsIFileURL);
  dump("\tDeleting mozgest directory: \n\t" + fileUri.spec + "\n");
  try {
    fileUri.file.remove(true);
    dump("\tmozgest directory deleted OK\n");
  }
  catch (err) {
    dump("\tmozgest directory NOT deleted. ERROR:\n" + err + "\n");
    alert(dirNotDeleted + chromeDir.path);
  }
  semaphore--; // asyncronous operation finished
}

// removeFromChrome is listener that removes all mozgest references from 
// chrome/chrome.rdf when this DataSource is loaded
var removeFromChrome = {
  onDataSourceReady: function(aDS) 
  {
    dump("MozGest: removeFromChrome\n");

    // get the sequence that holds all the packages
    var rootSeq = RDFU.findSeq(aDS, "urn:mozilla:package:root");

    // get resource and node for your package
    var myResource = gRDF.GetResource("urn:mozilla:package:mozgest");
    var myNode = myResource.QueryInterface(Components.interfaces.nsIRDFNode);

    // and snip out your arc
    rootSeq.RemoveElement(myNode, true);

    // now remove everything else we know about your package
    var arcs = aDS.ArcLabelsOut(myResource);

    while(arcs.hasMoreElements()) {
      var arc = arcs.getNext();
    
      // each arc is a property
      var prop = arc.QueryInterface(Components.interfaces.nsIRDFResource);

      // For each property, get all targets, and unassert.  nested 
      // enumeration is the best!
      var targets = aDS.GetTargets(myResource, prop, true);

      while(targets.hasMoreElements()) {
        var target = targets.getNext();

        var targetNode = target.QueryInterface(Components.interfaces.nsIRDFNode);
        aDS.Unassert(myResource, prop, targetNode);
      }
    }

    // now flush the datasource back to disk
    RDFU.saveDataSource(aDS);
    dump("MozGest: removeFromChrome OK\n");
    semaphore--; // asyncronous operation finished
  },

  onError: function(aStatus, aErrorMsg)
  {
    dump("MozGest: removeFromChrome ERROR: status="+aStatus+",", aErrorMsg);
  }
};

// overlayRemover removes target from sequence in datasourceURI
// we clean our references from overlay files with these
function overlayRemover(datasourceURI, seq, target) {
  this.mDS = datasourceURI;
  this.mTarget = target;
  this.mSeq = seq;
};
overlayRemover.prototype = {

  remove: function()
  {
    RDFU.loadDataSource(this.mDS, this);
  },

  onDataSourceReady: function(aDS)
  {
    dump("MozGest: overlayRemover: Attempting to remove\n\t" + this.mTarget + 
         "\n\tfrom sequence " + this.mSeq+"\n");
    var seq = RDFU.findSeq(aDS, this.mSeq);
    var target = gRDF.GetLiteral(this.mTarget);
    seq.RemoveElement(target, true);
    RDFU.saveDataSource(aDS);
    dump("MozGest: overlayRemover: OK\n");
    semaphore--; // asyncronous operation finished
  },

  onError: function(aStatus, aErrorMsg)
  {
    dump("MozGest: overlayRemover: Error: status="+aStatus+",", aErrorMsg);
  }
};
